/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.model;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentInstance;

public class ComponentConfiguration {
    private ComponentDescription cd;
    private Hashtable properties;
    private ServiceRegistration serviceRegistration;
    private List references;
    private List instances;
    protected List delayActivateComponentConfigurationNames;
    protected boolean componentFactory;

    public ComponentConfiguration(ComponentDescription cd, List references, Hashtable properties, boolean componentFactory) {
        this.cd = cd;
        this.references = references;
        this.properties = properties;
        this.delayActivateComponentConfigurationNames = new ArrayList();
        this.instances = new ArrayList();
        this.componentFactory = componentFactory;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public ComponentDescription getComponentDescription() {
        return this.cd;
    }

    public void setDelayActivateComponentConfigurationName(String componentConfigurationName) {
        if (!this.delayActivateComponentConfigurationNames.contains(componentConfigurationName)) {
            this.delayActivateComponentConfigurationNames.add(componentConfigurationName);
        }
    }

    public ServiceRegistration getServiceRegistration() {
        return this.serviceRegistration;
    }

    public void setServiceRegistration(ServiceRegistration serviceRegistration) {
        this.serviceRegistration = serviceRegistration;
    }

    public List getDelayActivateComponentConfigurationNames() {
        return this.delayActivateComponentConfigurationNames;
    }

    public void clearDelayActivateComponentConfigurationNames() {
        this.delayActivateComponentConfigurationNames.clear();
    }

    public List getReferences() {
        return this.references;
    }

    public void addInstance(ComponentInstance instance) {
        this.instances.add(instance);
    }

    public List getInstances() {
        return this.instances;
    }

    public void removeInstance(Object object) {
        this.instances.remove(object);
    }

    public void removeAllInstances() {
        this.instances.clear();
    }

    public boolean isComponentFactory() {
        return this.componentFactory;
    }
}

