/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLImageHandler;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.IImage;

public class HTMLServerImageHandler
extends HTMLImageHandler {
    protected Logger log;
    private String handlerId;
    private int count;
    private static HashMap map;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.HTMLServerImageHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        map = new HashMap();
    }

    public HTMLServerImageHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.HTMLServerImageHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.count = 0;
        String codePart = Integer.toHexString(this.hashCode());
        String timePart = Long.toHexString(System.currentTimeMillis());
        this.handlerId = String.valueOf(codePart) + timePart;
    }

    public String onDesignImage(IImage image, Object context) {
        return this.handleImage(image, context, "design", true);
    }

    public String onDocImage(IImage image, Object context) {
        return null;
    }

    public String onURLImage(IImage image, Object context) {
        if (!$assertionsDisabled && image == null) {
            throw new AssertionError();
        }
        String uri = image.getID();
        if (uri.startsWith("http:") || uri.startsWith("https:")) {
            return uri;
        }
        return this.handleImage(image, context, "uri", true);
    }

    public String onCustomImage(IImage image, Object context) {
        return this.handleImage(image, context, "custom", false);
    }

    protected String createUniqueFileName(String imageDir, String prefix) {
        return this.createUniqueFileName(imageDir, prefix, null);
    }

    protected String createUniqueFileName(String imageDir, String prefix, String postfix) {
        File file = null;
        postfix = postfix == null ? "" : postfix;
        String uniCount = null;
        do {
            uniCount = this.genUniqueCount();
        } while ((file = new File(String.valueOf(imageDir) + "/" + prefix + uniCount + postfix)).exists());
        return String.valueOf(prefix) + uniCount + postfix;
    }

    private synchronized String genUniqueCount() {
        ++this.count;
        return String.valueOf(this.handlerId) + this.count;
    }

    public String onFileImage(IImage image, Object context) {
        return this.handleImage(image, context, "file", true);
    }

    protected String handleImage(IImage image, Object context, String prefix, boolean needMap) {
        String mapID = null;
        if (needMap && map.containsKey(mapID = this.getImageMapID(image))) {
            return (String)map.get(mapID);
        }
        String ret = null;
        if (context != null && context instanceof HTMLRenderContext) {
            HTMLRenderContext myContext = (HTMLRenderContext)context;
            String imageURL = myContext.getBaseImageURL();
            String imageDir = myContext.getImageDirectory();
            if (imageURL == null || imageURL.length() == 0 || imageDir == null || imageDir.length() == 0) {
                this.log.log(Level.SEVERE, "imageURL or ImageDIR is not set!");
                return null;
            }
            String extension = image.getExtension();
            String fileName = extension != null && extension.length() > 0 ? this.createUniqueFileName(imageDir, prefix, extension) : this.createUniqueFileName(imageDir, prefix);
            File file = new File(imageDir, fileName);
            try {
                image.writeImage(file);
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
            ret = imageURL.indexOf("?") > 0 ? String.valueOf(imageURL) + fileName : (imageURL.endsWith("/") ? String.valueOf(imageURL) + fileName : String.valueOf(imageURL) + "/" + fileName);
            if (needMap) {
                map.put(mapID, ret);
            }
        } else {
            ret = this.handleTempImage(image, prefix, needMap);
        }
        return ret;
    }

    protected String handleTempImage(IImage image, String prefix, boolean needMap) {
        try {
            File imageFile = File.createTempFile(prefix, ".img");
            image.writeImage(imageFile);
            String fileName = imageFile.getAbsolutePath();
            if (needMap) {
                String mapID = this.getImageMapID(image);
                map.put(mapID, fileName);
            }
            return fileName;
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
            return "unknow.img";
        }
    }

    protected String getImageMapID(IImage image) {
        if (image.getReportRunnable() != null) {
            return String.valueOf(image.getReportRunnable().hashCode()) + image.getID();
        }
        return image.getID();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getImage(OutputStream out, String imageDir, String imageID) throws EngineException {
        File image = new File(imageDir, imageID);
        if (!image.exists()) {
            throw new EngineException("Error.MissingImageFileError");
        }
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(image);
                byte[] buffer = new byte[1024];
                int size = 0;
                do {
                    if ((size = ((InputStream)in).read(buffer)) <= 0) continue;
                    out.write(buffer, 0, size);
                } while (size > 0);
                ((InputStream)in).close();
            }
            catch (IOException ex) {
                throw new EngineException("Error.Error", ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (in == null) return;
        ((InputStream)in).close();
    }
}

