/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.mozilla.javascript.Scriptable;

public class DataExtractionTaskV0
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.engine.api.impl.DataExtractionTaskV0");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.DteDataEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public DataExtractionTaskV0(IReportEngine engine, IReportRunnable runnable, IReportDocument reader) throws EngineException {
        super(engine, runnable, 4);
        this.report = ((ReportRunnable)runnable).getReportIR();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
    }

    private void prepareMetaData() {
        if (this.isMetaDataPrepared) {
            return;
        }
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, this.executionContext.getAppContext());
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        Iterator iter = queryIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)entry.getKey();
            if (!(baseQuery instanceof IQueryDefinition)) continue;
            IQueryDefinition query = (IQueryDefinition)baseQuery;
            String queryId = (String)entry.getValue();
            ReportItemDesign item = (ReportItemDesign)query2itemMapping.get(query);
            String queryName = item.getName();
            if (queryName == null) {
                queryName = "ELEMENT_" + item.getID();
            }
            this.queryId2NameMapping.put(queryId, queryName);
            this.queryId2QueryMapping.put(queryId, query);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IQueryDefinition getQuery(String queryId) {
        return (IQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    private void loadResultSetMetaData() throws EngineException {
        try {
            HashMap query2ResultMetaData = this.report.getResultMetaData();
            IDocArchiveReader reader = this.reportDocReader.getArchive();
            HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
            ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
            if (result != null) {
                int i = 0;
                while (i < result.size()) {
                    String[] rsetRelation = (String[])result.get(i);
                    String queryId = rsetRelation[2];
                    String rsetId = rsetRelation[3];
                    IQueryDefinition query = this.getQuery(queryId);
                    this.rsetId2queryIdMapping.put(rsetId, queryId);
                    if (this.isMasterQuery(query)) {
                        ResultMetaData metaData;
                        int count = -1;
                        Integer countObj = (Integer)queryCounts.get(queryId);
                        if (countObj != null) {
                            count = countObj;
                        }
                        String rsetName = this.getQueryName(queryId);
                        if (++count > 0) {
                            rsetName = String.valueOf(rsetName) + "_" + count;
                        }
                        queryCounts.put(queryId, new Integer(count));
                        this.rsetName2IdMapping.put(rsetName, rsetId);
                        if (query2ResultMetaData != null && (metaData = (ResultMetaData)query2ResultMetaData.get(query)).getColumnCount() > 0) {
                            ResultSetItem resultItem = new ResultSetItem(rsetName, metaData);
                            this.resultMetaList.add(resultItem);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
        }
    }

    private boolean isMasterQuery(IQueryDefinition query) {
        if (query.getDataSetName() == null) {
            return false;
        }
        IBaseQueryDefinition parent = query.getParentQuery();
        while (parent != null) {
            if (parent instanceof IQueryDefinition) {
                IQueryDefinition parentQuery = (IQueryDefinition)parent;
                if (parentQuery.getDataSetName() != null) {
                    return false;
                }
            } else {
                return false;
            }
            parent = parent.getParentQuery();
        }
        return true;
    }

    protected String instanceId2RsetName(InstanceID iid) {
        String rsetId;
        DataSetID dataSetId;
        DataID dataId = iid.getDataID();
        if (dataId != null && (dataSetId = dataId.getDataSetID()) != null && (rsetId = dataSetId.getDataSetName()) != null) {
            return this.rsetId2Name(rsetId);
        }
        return null;
    }

    protected String queryId2rsetId(String id) {
        Iterator iter = this.rsetId2queryIdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        Iterator iter = this.rsetName2IdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    public void setInstanceID(InstanceID iid) {
        if (!$assertionsDisabled && iid == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    public void selectResultSet(String displayName) {
        if (!$assertionsDisabled && displayName == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            String rsetName = this.instanceId2RsetName(this.instanceId);
            if (rsetName != null) {
                IResultMetaData metaData = this.getResultMetaData(rsetName);
                if (metaData != null) {
                    rsetList.add(new ResultSetItem(rsetName, metaData));
                }
            } else {
                IResultMetaData metaData = this.getMetaDateByInstanceID(this.instanceId);
                if (metaData != null) {
                    rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId, metaData));
                }
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        Iterator iter = this.resultMetaList.iterator();
        while (iter.hasNext()) {
            IResultSetItem rsetItem = (IResultSetItem)iter.next();
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    public IExtractionResults extract() throws EngineException {
        String rsetName = this.resultSetName;
        if (rsetName == null && this.instanceId != null) {
            rsetName = this.instanceId2RsetName(this.instanceId);
        }
        if (rsetName != null) {
            return this.extractByResultSetName(rsetName);
        }
        if (this.instanceId != null) {
            return this.extractByInstanceID(this.instanceId);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IExtractionResults extractByResultSetName(String rsetName) throws EngineException {
        if (!$assertionsDisabled && rsetName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.executionContext.getDataEngine() == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        try {
            String rsetId = this.rsetName2Id(rsetName);
            if (rsetId == null) return null;
            IQueryResults results = null;
            if (this.filterExpressions == null) {
                results = dataSession.getQueryResults(rsetId);
            } else {
                String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
                QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
                QueryDefinition newQuery = this.queryCopy(query);
                if (newQuery == null) {
                    return null;
                }
                int iNum = 0;
                while (true) {
                    if (iNum >= this.filterExpressions.length) {
                        this.filterExpressions = null;
                        newQuery.setQueryResultsID(rsetId);
                        Scriptable scope = this.executionContext.getSharedScope();
                        IPreparedQuery preparedQuery = dataSession.prepare((IQueryDefinition)newQuery);
                        results = preparedQuery.execute(scope);
                        break;
                    }
                    newQuery.getFilters().add(this.filterExpressions[iNum]);
                    ++iNum;
                }
            }
            if (results == null) return null;
            IResultMetaData metaData = this.getResultMetaData(rsetName);
            if (metaData == null) return null;
            return new ExtractionResults(results, metaData, this.selectedColumns);
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private IExtractionResults extractByInstanceID(InstanceID iid) throws EngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 329->332)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) {
        ResultMetaData metaData = null;
        long id = iid.getComponentID();
        ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
        IDataQueryDefinition query = design.getQuery();
        if (query == null) {
            return null;
        }
        HashMap query2ResultMetaData = this.report.getResultMetaData();
        if (query2ResultMetaData != null) {
            metaData = (ResultMetaData)query2ResultMetaData.get(query);
        }
        return metaData;
    }

    private IResultIterator getResultSetIterator(DataRequestSession dataSession, DataSetID dataSet, Scriptable scope) throws BirtException {
        DataSetID parent = dataSet.getParentID();
        if (parent == null) {
            String rsetName = dataSet.getDataSetName();
            if (!$assertionsDisabled && rsetName == null) {
                throw new AssertionError();
            }
            IQueryResults rset = dataSession.getQueryResults(rsetName);
            return rset.getResultIterator();
        }
        IResultIterator iter = this.getResultSetIterator(dataSession, parent, scope);
        long rowId = dataSet.getRowID();
        String queryName = dataSet.getQueryName();
        if (!$assertionsDisabled && rowId == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryName == null) {
            throw new AssertionError();
        }
        iter.moveTo((int)rowId);
        return iter.getSecondaryIterator(queryName, scope);
    }

    private IResultIterator getFilterResultSetIterator(DataRequestSession dataSession, DataSetID dataSet, Scriptable scope, IQueryResults rset) throws BirtException {
        DataSetID parent = dataSet.getParentID();
        if (parent == null) {
            return rset.getResultIterator();
        }
        IResultIterator iter = this.getFilterResultSetIterator(dataSession, parent, scope, rset);
        long rowId = dataSet.getRowID();
        String queryName = dataSet.getQueryName();
        if (!$assertionsDisabled && rowId == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryName == null) {
            throw new AssertionError();
        }
        iter.moveTo((int)rowId);
        return iter.getSecondaryIterator(queryName, scope);
    }

    private QueryDefinition queryCopy(QueryDefinition query) {
        if (query == null) {
            return null;
        }
        QueryDefinition newQuery = new QueryDefinition((BaseQueryDefinition)query.getParentQuery());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        return newQuery;
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }
}

