/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.PDFRenderContext;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.api.UnsupportedFormatException;
import org.eclipse.birt.report.engine.api.impl.EngineLogger;
import org.eclipse.birt.report.engine.api.impl.EngineLoggerHandler;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ScriptedDesignVisitor;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.emitter.EngineEmitterServices;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.LayoutEngineFactory;
import org.eclipse.birt.report.engine.script.internal.ReportContextImpl;
import org.eclipse.birt.report.engine.script.internal.ReportScriptExecutor;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SlotHandle;

public abstract class EngineTask
implements IEngineTask {
    protected static int id;
    protected String pagination;
    protected static final String FORMAT_HTML = "html";
    protected boolean cancelFlag;
    protected int runningStatus;
    protected IReportEngine engine;
    protected Logger log;
    protected Locale locale = Locale.getDefault();
    protected ExecutionContext executionContext;
    protected int taskID;
    protected IReportRunnable runnable;
    protected IRenderOption renderOptions;
    protected String emitterID;
    protected boolean parameterChanged = true;
    protected HashMap inputValues = new HashMap();
    protected HashMap runValues = new HashMap();
    protected int taskType = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.EngineTask");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        id = 0;
    }

    protected EngineTask(IReportEngine engine, IReportRunnable runnable) {
        this.taskID = id++;
        this.engine = engine;
        this.log = engine.getLogger();
        this.executionContext = new ExecutionContext(this);
        this.executionContext.setReportContext(new ReportContextImpl(this.executionContext));
        this.setReportRunnable(runnable);
        this.executionContext.setAppContext(engine.getConfig().getAppContext());
        this.cancelFlag = false;
        this.runningStatus = 0;
    }

    protected EngineTask(IReportEngine engine, IReportRunnable runnable, int taskType) {
        this(engine, runnable);
        this.taskType = taskType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ULocale getULocale() {
        return ULocale.forLocale((Locale)this.locale);
    }

    public void setLocale(Locale locale) {
        this.log.log(Level.FINE, "EngineTask.setLocale: locale={0}", locale == null ? null : locale.getDisplayName());
        this.doSetLocale(locale);
    }

    private void doSetLocale(Locale locale) {
        this.locale = locale;
        this.executionContext.setLocale(locale);
        EngineException.setULocale(ULocale.forLocale((Locale)locale));
    }

    public void setLocale(ULocale uLocale) {
        this.log.log(Level.FINE, "EngineTask.setLocale: uLocale={0}", uLocale == null ? null : uLocale.getDisplayName());
        this.doSetLocale(uLocale.toLocale());
    }

    public void setAppContext(Map context) {
        HashMap appContext = new HashMap();
        HashMap sysAppContext = this.engine.getConfig().getAppContext();
        if (sysAppContext != null) {
            appContext.putAll(sysAppContext);
        }
        if (context != null) {
            appContext.putAll(context);
        }
        this.executionContext.setAppContext(appContext);
        StringBuffer logStr = null;
        if (this.log.isLoggable(Level.FINE)) {
            logStr = new StringBuffer();
        }
        if (!appContext.isEmpty()) {
            Set entries = appContext.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (entry.getKey() instanceof String) {
                    this.executionContext.registerBean((String)entry.getKey(), entry.getValue());
                    if (logStr == null) continue;
                    logStr.append(entry.getKey());
                    logStr.append("=");
                    logStr.append(entry.getValue());
                    logStr.append(";");
                    continue;
                }
                this.log.log(Level.WARNING, "Map entry {0} is invalid and ignored, because its key is a not string.", entry.getKey().toString());
            }
        }
        if (logStr != null) {
            this.log.log(Level.FINE, "EngineTask.setAppContext: context={0}", logStr);
        }
    }

    public Map getAppContext() {
        return this.executionContext.getAppContext();
    }

    public IReportEngine getEngine() {
        return this.engine;
    }

    public void setReportRunnable(IReportRunnable runnable) {
        if (runnable != null) {
            this.runnable = runnable;
            this.executionContext.setRunnable(runnable);
            this.executionContext.registerBeans(System.getProperties());
            this.executionContext.registerBeans(runnable.getTestConfig());
            this.executionContext.getConfigs().putAll(System.getProperties());
            this.executionContext.getConfigs().putAll(runnable.getTestConfig());
        }
    }

    public IReportRunnable getReportRunnable() {
        return this.runnable;
    }

    public void setRenderOption(IRenderOption options) {
        if (options == null) {
            throw new NullPointerException("options can't be null");
        }
        this.renderOptions = options;
    }

    public IRenderOption getRenderOption() {
        return this.renderOptions;
    }

    public void setEmitterID(String id) {
        this.emitterID = id;
    }

    public String getEmitterID() {
        return this.emitterID;
    }

    public DataRequestSession getDataSession() {
        return this.executionContext.getDataEngine().getDTESession();
    }

    public void addScriptableJavaObject(String jsName, Object obj) {
        this.executionContext.registerBean(jsName, obj);
    }

    public int getID() {
        return this.taskID;
    }

    protected Object convertToType(Object value, String type) {
        try {
            if ("boolean".equals(type)) {
                return DataTypeUtil.toBoolean((Object)value);
            }
            if ("dateTime".equals(type)) {
                return DataTypeUtil.toDate((Object)value);
            }
            if ("date".equals(type)) {
                return DataTypeUtil.toSqlDate((Object)value);
            }
            if ("time".equals(type)) {
                return DataTypeUtil.toSqlTime((Object)value);
            }
            if ("decimal".equals(type)) {
                return DataTypeUtil.toBigDecimal((Object)value);
            }
            if ("float".equals(type)) {
                return DataTypeUtil.toDouble((Object)value);
            }
            if ("string".equals(type)) {
                return DataTypeUtil.toString((Object)value);
            }
            if ("integer".equals(type)) {
                return DataTypeUtil.toInteger((Object)value);
            }
            return value;
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public boolean validateParameters() {
        if (this.runnable == null) {
            return false;
        }
        this.usingParameterValues();
        if (this.log.isLoggable(Level.FINE)) {
            this.loggerParamters();
        }
        return new ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
                return EngineTask.this.validateScalarParameter(param);
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                return this.visitParametersInGroup(group, value);
            }
        }.visit((ReportDesignHandle)this.runnable.getDesignHandle(), null);
    }

    protected void loggerParamters() {
        if (this.log.isLoggable(Level.FINE)) {
            final StringBuffer buffer = new StringBuffer();
            new ParameterVisitor(){

                boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
                    String paramName = param.getName();
                    Object paramValue = EngineTask.this.runValues.get(paramName);
                    buffer.append(paramName);
                    buffer.append(":");
                    buffer.append(paramValue);
                    buffer.append("\n");
                    return EngineTask.this.validateScalarParameter(param);
                }

                boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                    return this.visitParametersInGroup(group, value);
                }
            }.visit((ReportDesignHandle)this.runnable.getDesignHandle(), null);
            this.log.log(Level.FINE, "Running the report with paramters: {0}", buffer);
        }
    }

    private boolean validateScalarParameter(ScalarParameterHandle paramHandle) {
        Object result;
        String paramName = paramHandle.getName();
        Object paramValue = this.runValues.get(paramName);
        String type = paramHandle.getDataType();
        if (paramValue == null) {
            if (!paramHandle.isRequired()) {
                return true;
            }
            this.log.log(Level.SEVERE, "Parameter {0} doesn't allow a null value.", paramName);
            return false;
        }
        String source = paramHandle.getValidate();
        if (!(source == null || source.length() == 0 || (result = this.executionContext.evaluate(source)) instanceof Boolean && ((Boolean)result).booleanValue())) {
            this.log.log(Level.SEVERE, "Parameter validate failed: ", source);
            return false;
        }
        if ("decimal".equals(type) || "float".equals(type)) {
            if (paramValue instanceof Number) {
                return true;
            }
            this.log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a number.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        if ("dateTime".equals(type)) {
            if (paramValue instanceof java.util.Date) {
                return true;
            }
            this.log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a valid date time.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        if ("date".equals(type)) {
            if (paramValue instanceof Date) {
                return true;
            }
            this.log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a valid date.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        if ("time".equals(type)) {
            if (paramValue instanceof Time) {
                return true;
            }
            this.log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a valid time.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        if ("string".equals(type)) {
            String value = paramValue.toString().trim();
            if (paramHandle.isRequired() && value.equals("")) {
                this.log.log(Level.SEVERE, "parameter {0} can't be blank.", paramName);
                return false;
            }
            return true;
        }
        if ("boolean".equals(type)) {
            if (paramValue instanceof Boolean) {
                return true;
            }
            this.log.log(Level.SEVERE, "The supplied value {0} for parameter {1} is not a boolean.", new String[]{paramValue.toString(), paramName});
            return false;
        }
        return true;
    }

    public void setParameterValues(Map params) {
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.setParameterValue(name, value);
        }
    }

    public void setParameterValue(String name, Object value) {
        this.log.log(Level.FINE, "EngineTask.setParameterValue: {0}={1} [{2}]", new Object[]{name, value, value == null ? null : value.getClass().getName()});
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
                throw new AssertionError();
            }
            ((ParameterAttribute)parameter).setValue(value);
        } else {
            this.inputValues.put(name, new ParameterAttribute(value, null));
        }
    }

    public void setValue(String name, Object value) {
        this.setParameterValue(name, value);
    }

    public HashMap getParameterValues() {
        HashMap result = new HashMap();
        Iterator iterator = this.inputValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ParameterAttribute parameter = (ParameterAttribute)entry.getValue();
            result.put(entry.getKey(), parameter.getValue());
        }
        return result;
    }

    public Object getParameterValue(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter == null) {
            return null;
        }
        if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
            throw new AssertionError();
        }
        return ((ParameterAttribute)parameter).getValue();
    }

    public void setParameter(String name, Object value, String displayText) {
        this.parameterChanged = true;
        this.inputValues.put(name, new ParameterAttribute(value, displayText));
    }

    public String getParameterDisplayText(String name) {
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
                throw new AssertionError();
            }
            return ((ParameterAttribute)parameter).getDisplayText();
        }
        return null;
    }

    public void setParameterDisplayTexts(Map params) {
        Iterator iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            String text = (String)entry.getValue();
            this.setParameterDisplayText(name, text);
        }
    }

    public void setParameterDisplayText(String name, String displayText) {
        this.parameterChanged = true;
        Object parameter = this.inputValues.get(name);
        if (parameter != null) {
            if (!$assertionsDisabled && !(parameter instanceof ParameterAttribute)) {
                throw new AssertionError();
            }
            ((ParameterAttribute)parameter).setDisplayText(displayText);
        } else {
            this.inputValues.put(name, new ParameterAttribute(null, displayText));
        }
    }

    public void cancel() {
        this.cancelFlag = true;
        this.executionContext.cancel();
    }

    public void cancel(Object signal) {
        if (signal == null) {
            throw new IllegalArgumentException("signal can't be null");
        }
        this.cancelFlag = true;
        long waitingTime = 0L;
        do {
            waitingTime += 100L;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            if (this.runningStatus == 1) continue;
            return;
        } while (waitingTime < 5000L);
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    public void setErrorHandlingOption(int option) {
        if (option == 1) {
            this.executionContext.setCancelOnError(true);
        } else {
            this.executionContext.setCancelOnError(false);
        }
    }

    protected IQueryResults executeDataSet(DataSetHandle hDataSet, HashMap parameters) {
        return null;
    }

    protected void usingParameterValues() {
        if (!this.parameterChanged) {
            return;
        }
        this.parameterChanged = false;
        this.executionContext.clearParameters();
        this.runValues.clear();
        Iterator iterator = this.inputValues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object key = entry.getKey();
            ParameterAttribute attribute = (ParameterAttribute)entry.getValue();
            this.runValues.put(key, attribute.getValue());
            this.executionContext.setParameter((String)key, attribute.getValue(), attribute.getDisplayText());
        }
        if (this.runnable == null) {
            return;
        }
        new ParameterVisitor(){

            boolean visitScalarParameter(ScalarParameterHandle param, Object userData) {
                String name = param.getName();
                if (!EngineTask.this.inputValues.containsKey(name)) {
                    Object value = EngineTask.this.convertToType(param.getDefaultValue(), param.getDataType());
                    EngineTask.this.executionContext.setParameterValue(name, value);
                    EngineTask.this.runValues.put(name, value);
                }
                return true;
            }

            boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
                return this.visitParametersInGroup(group, value);
            }
        }.visit((ReportDesignHandle)this.runnable.getDesignHandle());
    }

    public void close() {
        this.executionContext.close();
        EngineLoggerHandler.setLogger(null);
    }

    protected IContentEmitter createContentEmitter() throws EngineException {
        String format = this.renderOptions.getOutputFormat();
        if (format == null) {
            format = FORMAT_HTML;
        }
        ExtensionManager extManager = ExtensionManager.getInstance();
        boolean supported = false;
        Collection supportedFormats = extManager.getSupportedFormat();
        Iterator iter = supportedFormats.iterator();
        while (iter.hasNext()) {
            String supportedFormat = (String)iter.next();
            if (supportedFormat == null || !supportedFormat.equalsIgnoreCase(format)) continue;
            supported = true;
            break;
        }
        if (!supported) {
            this.log.log(Level.SEVERE, "Error.OutputFormatNotSupported", format);
            throw new UnsupportedFormatException("Error.OutputFormatNotSupported", format);
        }
        this.pagination = extManager.getPagination(format);
        IContentEmitter emitter = null;
        try {
            emitter = extManager.createEmitter(format, this.emitterID);
        }
        catch (Throwable t) {
            this.log.log(Level.SEVERE, "Report engine can not create {0} emitter.", format);
            throw new EngineException("Error.CannotCreateExtensionInstance", format, t);
        }
        if (emitter == null) {
            this.log.log(Level.SEVERE, "Report engine can not create {0} emitter.", format);
            throw new EngineException("Error.CannotCreateExtensionInstance", format);
        }
        return emitter;
    }

    protected IReportLayoutEngine createReportLayoutEngine(String pagination, IRenderOption options) {
        IReportLayoutEngine layoutEngine = LayoutEngineFactory.createLayoutEngine(pagination);
        if (options != null) {
            Object pagebreakOnly;
            Object fitToPage = this.renderOptions.getOption("pdfRenderOption.fitToPage");
            if (fitToPage != null) {
                layoutEngine.setOption("pdfRenderOption.fitToPage", fitToPage);
            }
            if ((pagebreakOnly = this.renderOptions.getOption("pdfRenderOption.pagebreakPaginationOnly")) != null) {
                layoutEngine.setOption("pdfRenderOption.pagebreakPaginationOnly", pagebreakOnly);
            }
        }
        return layoutEngine;
    }

    protected void loadDesign() {
        if (this.runnable != null) {
            ReportDesignHandle reportDesign = this.executionContext.getDesign();
            Iterator iter = reportDesign.includeScriptsIterator();
            while (iter.hasNext()) {
                IncludeScriptHandle includeScript = (IncludeScriptHandle)iter.next();
                String fileName = includeScript.getFileName();
                this.executionContext.loadScript(fileName);
            }
            ReportScriptExecutor.handleInitialize(reportDesign, this.executionContext);
        }
    }

    protected void prepareDesign() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ScriptedDesignVisitor visitor = new ScriptedDesignVisitor(reportDesign, this.executionContext);
        visitor.apply((DesignElementHandle)reportDesign.getRoot());
        this.runnable.setDesignHandle(reportDesign);
    }

    protected void startFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleBeforeFactory(reportDesign, this.executionContext);
    }

    protected void closeFactory() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleAfterFactory(reportDesign, this.executionContext);
    }

    protected void startRender() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleBeforeRender(reportDesign, this.executionContext);
    }

    protected void closeRender() {
        ReportDesignHandle reportDesign = this.executionContext.getDesign();
        ReportScriptExecutor.handleAfterRender(reportDesign, this.executionContext);
    }

    public void setDataSource(IDocArchiveReader dataSource) {
        try {
            ReportDocumentReader document = new ReportDocumentReader(this.engine, dataSource, true);
            Map values = document.getParameterValues();
            Map texts = document.getParameterDisplayTexts();
            this.setParameterValues(values);
            this.setParameterDisplayTexts(texts);
            document.close();
        }
        catch (EngineException ex) {
            this.log.log(Level.WARNING, "failed to load the paremters in the data source", (Throwable)((Object)ex));
        }
        try {
            this.executionContext.setDataSource(dataSource);
        }
        catch (IOException ioex) {
            this.log.log(Level.WARNING, "failed to open the data source document", ioex);
        }
    }

    public int getStatus() {
        return this.runningStatus;
    }

    public List getErrors() {
        return this.executionContext.getErrors();
    }

    public IReportContext getReportContext() {
        return this.executionContext.getReportContext();
    }

    private void mergeOption(IRenderOption options, String name, Object value) {
        if (options != null && value != null && !options.hasOption(name)) {
            options.setOption(name, value);
        }
    }

    protected void setupRenderOption() {
        IRenderOption emitterOptions;
        IRenderOption formatOptions;
        Object renderContext;
        String format = FORMAT_HTML;
        if (this.renderOptions != null && ((format = this.renderOptions.getOutputFormat()) == null || format.length() == 0)) {
            format = FORMAT_HTML;
            this.renderOptions.setOutputFormat(format);
        }
        Map appContext = this.executionContext.getAppContext();
        if ("pdf".equals(format)) {
            renderContext = appContext.get("PDF_RENDER_CONTEXT");
            if (renderContext instanceof PDFRenderContext) {
                PDFRenderContext pdfContext = (PDFRenderContext)renderContext;
                this.mergeOption(this.renderOptions, "baseUrl", pdfContext.getBaseURL());
                this.mergeOption(this.renderOptions, "pdfRenderOption.fontDirectory", pdfContext.getFontDirectory());
                this.mergeOption(this.renderOptions, "supportedImageFormats", pdfContext.getSupportedImageFormats());
                this.mergeOption(this.renderOptions, "pdfRenderOption.embeddedFonts", new Boolean(pdfContext.isEmbededFont()));
            }
        } else {
            renderContext = appContext.get("HTML_RENDER_CONTEXT");
            if (renderContext instanceof HTMLRenderContext) {
                HTMLRenderContext htmlContext = (HTMLRenderContext)renderContext;
                this.mergeOption(this.renderOptions, "baseImageURL", htmlContext.getBaseImageURL());
                this.mergeOption(this.renderOptions, "baseUrl", htmlContext.getBaseURL());
                this.mergeOption(this.renderOptions, "imageDirectory", htmlContext.getImageDirectory());
                this.mergeOption(this.renderOptions, "supportedImageFormats", htmlContext.getSupportedImageFormats());
            }
        }
        HashMap options = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions == null) {
            defaultOptions = (IRenderOption)configs.get(FORMAT_HTML);
        }
        if (defaultOptions != null) {
            options.putAll(defaultOptions.getOptions());
        }
        if ((formatOptions = (IRenderOption)configs.get(format)) != null) {
            options.putAll(formatOptions.getOptions());
        }
        if (this.emitterID != null && (emitterOptions = (IRenderOption)configs.get(this.emitterID)) != null) {
            options.putAll(emitterOptions.getOptions());
        }
        if (this.renderOptions != null) {
            options.putAll(this.renderOptions.getOptions());
        }
        RenderOption allOptions = new RenderOption(options);
        this.executionContext.setRenderOption(allOptions);
        if ("pdf".equals(format)) {
            Object renderContext2 = appContext.get("PDF_RENDER_CONTEXT");
            if (renderContext2 == null) {
                PDFRenderOption pdfOptions = new PDFRenderOption(allOptions);
                PDFRenderContext pdfContext = new PDFRenderContext();
                pdfContext.setBaseURL(pdfOptions.getBaseURL());
                pdfContext.setEmbededFont(pdfOptions.isEmbededFont());
                pdfContext.setFontDirectory(pdfOptions.getFontDirectory());
                pdfContext.setSupportedImageFormats(pdfOptions.getSupportedImageFormats());
                appContext.put("PDF_RENDER_CONTEXT", pdfContext);
            }
        } else {
            Object renderContext3 = appContext.get("HTML_RENDER_CONTEXT");
            if (renderContext3 == null) {
                HTMLRenderContext htmlContext = new HTMLRenderContext();
                HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
                htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
                htmlContext.setBaseURL(htmlOptions.getBaseURL());
                htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
                htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
                htmlContext.SetRenderOption(allOptions);
                appContext.put("HTML_RENDER_CONTEXT", htmlContext);
            }
        }
    }

    protected void initializeContentEmitter(IContentEmitter emitter, IReportExecutor executor) {
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IReportContext reportContext = this.executionContext.getReportContext();
        IRenderOption options = this.executionContext.getRenderOption();
        EngineEmitterServices services = new EngineEmitterServices(reportContext, options, configs);
        emitter.initialize(services);
    }

    public int getTaskType() {
        return this.taskType;
    }

    protected void changeStatusToRunning() {
        this.runningStatus = 1;
    }

    protected void changeStatusToStopped() {
        this.runningStatus = this.cancelFlag ? 4 : (this.executionContext.hasErrors() ? 3 : 2);
    }

    public Logger getLogger() {
        return this.log;
    }

    public void setLogger(Logger logger) {
        if (logger == null || !EngineLogger.isValidLogger(logger)) {
            throw new IllegalArgumentException("the logger can't be NULL or children or in namespace of org.eclipse.birt");
        }
        EngineLoggerHandler.setLogger(logger);
        this.log = logger;
        this.executionContext.setLogger(logger);
    }

    static abstract class ParameterVisitor {
        ParameterVisitor() {
        }

        boolean visitParametersInGroup(ParameterGroupHandle group, Object value) {
            SlotHandle parameters = group.getParameters();
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                Object param = iter.next();
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : param instanceof ScalarParameterHandle && !this.visitScalarParameter((ScalarParameterHandle)param, value)))) continue;
                return false;
            }
            return true;
        }

        boolean visitCascadingParamterGroup(CascadingParameterGroupHandle group, Object value) {
            return this.visitParameterGroup((ParameterGroupHandle)group, value);
        }

        boolean visitParameterGroup(ParameterGroupHandle group, Object value) {
            return false;
        }

        boolean visitScalarParameter(ScalarParameterHandle param, Object value) {
            return false;
        }

        boolean visit(ReportDesignHandle report) {
            return this.visit(report, null);
        }

        boolean visit(ReportDesignHandle report, Object value) {
            SlotHandle parameters = report.getParameters();
            Iterator iter = parameters.iterator();
            while (iter.hasNext()) {
                Object param = iter.next();
                if (!(param instanceof CascadingParameterGroupHandle ? !this.visitCascadingParamterGroup((CascadingParameterGroupHandle)param, value) : (param instanceof ParameterGroupHandle ? !this.visitParameterGroup((ParameterGroupHandle)param, value) : param instanceof ScalarParameterHandle && !this.visitScalarParameter((ScalarParameterHandle)param, value)))) continue;
                return false;
            }
            return true;
        }
    }
}

