/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.CompositeContentEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.executor.OnPageBreakLayoutPageHandle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.ReportPageExecutor;
import org.eclipse.birt.report.engine.internal.document.ReportletExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.PageRangeIterator;
import org.eclipse.birt.report.engine.internal.executor.dup.SuppressDuplciateReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.l18n.LocalizedReportExecutor;
import org.eclipse.birt.report.engine.internal.executor.wrap.WrappedReportExecutor;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class RenderTask
extends EngineTask
implements IRenderTask {
    IReportDocument reportDoc;
    private InnerRender innerRender;

    public RenderTask(IReportEngine engine, IReportRunnable runnable, IReportDocument reportDoc) {
        super(engine, runnable, 2);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        this.openReportDocument(reportDoc);
        this.loadDesign();
        this.innerRender = new PageRangeRender(new long[]{1L, this.reportDoc.getPageCount()});
    }

    protected void openReportDocument(IReportDocument reportDoc) {
        this.reportDoc = reportDoc;
        this.executionContext.setReportDocument(reportDoc);
        this.setParameterValues(reportDoc.getParameterValues());
        this.setParameterDisplayTexts(reportDoc.getParameterDisplayTexts());
        this.usingParameterValues();
        this.executionContext.registerGlobalBeans(reportDoc.getGlobalVariables(null));
    }

    protected void closeReportDocument() {
    }

    public void render(long pageNumber) throws EngineException {
        this.setPageNumber(pageNumber);
        this.render();
    }

    public void close() {
        this.closeReportDocument();
        super.close();
    }

    public void render(String pageRange) throws EngineException {
        this.setPageRange(pageRange);
        this.render();
    }

    private List parsePageSequence(String pageRange, long totalPage) {
        ArrayList<long[]> list = new ArrayList<long[]>();
        if (pageRange == null || "".equals(pageRange) || pageRange.toUpperCase().indexOf("ALL") >= 0) {
            list.add(new long[]{1L, totalPage});
            return list;
        }
        String[] ps = pageRange.split(",");
        int i = 0;
        while (i < ps.length) {
            try {
                if (ps[i].indexOf("-") > 0) {
                    String[] psi = ps[i].split("-");
                    if (psi.length == 2) {
                        long start = Long.parseLong(psi[0].trim());
                        long end = Long.parseLong(psi[1].trim());
                        if (end > start) {
                            list.add(new long[]{Math.max(start, 1L), Math.min(end, totalPage)});
                        }
                    } else {
                        this.log.log(Level.SEVERE, "error page number range: {0}", ps[i]);
                    }
                } else {
                    long number = Long.parseLong(ps[i].trim());
                    if (number > 0L && number <= totalPage) {
                        list.add(new long[]{number, number});
                    } else {
                        this.log.log(Level.SEVERE, "error page number range: {0}", ps[i]);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.log.log(Level.SEVERE, "error page number rang:", ps[i]);
            }
            ++i;
        }
        return this.sort(list);
    }

    private List sort(List list) {
        int i = 0;
        while (i < list.size()) {
            long[] currentI = (long[])list.get(i);
            int minIndex = i;
            long[] min = currentI;
            int j = i + 1;
            while (j < list.size()) {
                long[] currentJ = (long[])list.get(j);
                if (currentJ[0] < min[0]) {
                    minIndex = j;
                    min = currentJ;
                }
                ++j;
            }
            if (minIndex != i) {
                list.set(i, min);
                list.set(minIndex, currentI);
            }
            ++i;
        }
        long[] current = null;
        long[] last = null;
        ArrayList<long[]> ret = new ArrayList<long[]>();
        int i2 = 0;
        while (i2 < list.size()) {
            block7: {
                block8: {
                    block6: {
                        current = (long[])list.get(i2);
                        if (last == null) break block6;
                        if (current[1] <= last[1]) break block7;
                        if (current[0] <= last[1]) {
                            current[0] = last[1];
                        }
                        ret.add(current);
                        break block8;
                    }
                    ret.add(current);
                }
                last = current;
            }
            ++i2;
        }
        return ret;
    }

    public void render(InstanceID iid) throws EngineException {
        this.setInstanceID(iid);
        this.render();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render() throws EngineException {
        try {
            try {
                this.changeStatusToRunning();
                if (this.renderOptions == null) {
                    throw new EngineException("Render options have to be specified to render a report.");
                }
                if (this.runnable == null) {
                    throw new EngineException("Can not find the report design in the report document {0}.", new Object[]{this.reportDoc.getName()});
                }
                this.innerRender.render();
            }
            catch (EngineException e) {
                this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", (Throwable)((Object)e));
                throw e;
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "An error happened while running the report. Cause:", ex);
                throw new EngineException("Error happened while running the report", ex);
            }
            catch (OutOfMemoryError err) {
                this.log.log(Level.SEVERE, "An OutOfMemory error happened while running the report.");
                throw err;
            }
            catch (Throwable t) {
                this.log.log(Level.SEVERE, "Error happened while running the report.", t);
                throw new EngineException("Error happened while running the report", t);
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            this.changeStatusToStopped();
            throw throwable;
        }
        {
            Object var2_7 = null;
        }
        this.changeStatusToStopped();
    }

    public void setPageNumber(long pageNumber) throws EngineException {
        long totalPage = this.reportDoc.getPageCount();
        if (pageNumber <= 0L || pageNumber > totalPage) {
            throw new EngineException("Page {0} is not found ", new Long(pageNumber));
        }
        this.innerRender = new PageRangeRender(new long[]{pageNumber, pageNumber});
    }

    public void setInstanceID(InstanceID iid) throws EngineException {
        this.innerRender = new ReportletRender(iid);
    }

    public void setPageRange(String pageRange) throws EngineException {
        this.innerRender = new PageRangeRender(this.parsePageSequence(pageRange, this.reportDoc.getPageCount()));
    }

    public void setBookmark(String bookmark) throws EngineException {
        long pageNumber = this.reportDoc.getPageNumber(bookmark);
        if (pageNumber <= 0L) {
            throw new EngineException("Can not find bookmark :{0}", bookmark);
        }
        this.innerRender = new PageRangeRender(new long[]{pageNumber, pageNumber});
    }

    public void setReportlet(String bookmark) throws EngineException {
        this.innerRender = new ReportletRender(bookmark);
    }

    public void setInstanceID(String iid) throws EngineException {
        this.setInstanceID(InstanceID.parse(iid));
    }

    private abstract class InnerRender {
        private InnerRender() {
        }

        void render() throws Exception {
            RenderTask.this.setupRenderOption();
            IContentEmitter emitter = RenderTask.this.createContentEmitter();
            String format = RenderTask.this.executionContext.getOutputFormat();
            IReportExecutor executor = this.createExecutor();
            executor = new SuppressDuplciateReportExecutor(executor);
            executor = new LocalizedReportExecutor(RenderTask.this.executionContext, executor);
            RenderTask.this.executionContext.setExecutor(executor);
            RenderTask.this.initializeContentEmitter(emitter, executor);
            IReportLayoutEngine layoutEngine = RenderTask.this.createReportLayoutEngine(RenderTask.this.pagination, RenderTask.this.renderOptions);
            layoutEngine.setLocale(RenderTask.this.executionContext.getLocale());
            OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(RenderTask.this.executionContext);
            layoutEngine.setPageHandler(handle);
            CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
            outputEmitters.addEmitter(emitter);
            outputEmitters.addEmitter(handle.getEmitter());
            RenderTask.this.startRender();
            boolean paged = true;
            if ("page-break-pagination".equals(RenderTask.this.pagination)) {
                IRenderOption renderOption = RenderTask.this.executionContext.getRenderOption();
                HTMLRenderOption htmlRenderOption = new HTMLRenderOption(renderOption);
                boolean htmlPagination = htmlRenderOption.getHtmlPagination();
                if (!htmlPagination) {
                    paged = false;
                }
            } else if ("no-pagination".equals(RenderTask.this.pagination)) {
                paged = false;
            }
            IReportContent report = executor.execute();
            outputEmitters.start(report);
            layoutEngine.layout(executor, report, outputEmitters, paged);
            outputEmitters.end(report);
            RenderTask.this.closeRender();
            executor.close();
        }

        IReportExecutor createExecutor() throws Exception {
            return null;
        }
    }

    private class PageRangeRender
    extends InnerRender {
        protected List pageSequences;

        public PageRangeRender(long[] arrayRange) {
            this.pageSequences = new ArrayList();
            this.pageSequences.add(arrayRange);
        }

        public PageRangeRender(List pageRange) {
            this.pageSequences = pageRange;
        }

        protected boolean isPagedExecutor() {
            if ("paper-size-pagination".equals(RenderTask.this.pagination)) {
                return false;
            }
            boolean paged = true;
            IRenderOption renderOption = RenderTask.this.executionContext.getRenderOption();
            HTMLRenderOption htmlRenderOption = new HTMLRenderOption(renderOption);
            boolean htmlPagination = htmlRenderOption.getHtmlPagination();
            if (!htmlPagination) {
                paged = false;
            }
            return paged;
        }

        protected boolean needPaginate() {
            return false;
        }

        protected IPageHint getPageHint(ReportPageExecutor executor, long pageNumber) {
            try {
                return executor.getLayoutPageHint(pageNumber);
            }
            catch (IOException ex) {
                RenderTask.this.executionContext.addException(new EngineException("can't load the page hint", ex));
                return null;
            }
        }

        void render() throws Exception {
            RenderTask.this.setupRenderOption();
            IContentEmitter emitter = RenderTask.this.createContentEmitter();
            String format = RenderTask.this.executionContext.getOutputFormat();
            boolean paged = this.isPagedExecutor();
            ReportPageExecutor pagesExecutor = new ReportPageExecutor(RenderTask.this.executionContext, this.pageSequences, paged);
            WrappedReportExecutor executor = new SuppressDuplciateReportExecutor(pagesExecutor);
            executor = new LocalizedReportExecutor(RenderTask.this.executionContext, executor);
            RenderTask.this.executionContext.setExecutor(executor);
            RenderTask.this.initializeContentEmitter(emitter, executor);
            IReportLayoutEngine layoutEngine = RenderTask.this.createReportLayoutEngine(RenderTask.this.pagination, RenderTask.this.renderOptions);
            layoutEngine.setLocale(RenderTask.this.executionContext.getLocale());
            PageRangeIterator iter = new PageRangeIterator(this.pageSequences);
            if ("paper-size-pagination".equals(RenderTask.this.pagination)) {
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(RenderTask.this.executionContext);
                layoutEngine.setPageHandler(handle);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                RenderTask.this.startRender();
                IReportContent report = executor.execute();
                outputEmitters.start(report);
                long pageNumber = iter.next();
                layoutEngine.setLayoutPageHint(this.getPageHint(pagesExecutor, pageNumber));
                layoutEngine.layout(executor, report, outputEmitters, true);
                outputEmitters.end(report);
                RenderTask.this.closeRender();
                executor.close();
            } else if ("page-break-pagination".equals(RenderTask.this.pagination)) {
                RenderTask.this.startRender();
                IReportContent report = executor.execute();
                emitter.start(report);
                if (paged) {
                    while (iter.hasNext()) {
                        long pageNumber = iter.next();
                        IReportItemExecutor pageExecutor = executor.getNextChild();
                        if (pageExecutor == null) continue;
                        ReportExecutorWrapper pExecutor = new ReportExecutorWrapper(pageExecutor, executor);
                        layoutEngine.setLayoutPageHint(this.getPageHint(pagesExecutor, pageNumber));
                        layoutEngine.layout(pExecutor, report, emitter, false);
                    }
                } else {
                    long pageNumber = iter.next();
                    layoutEngine.setLayoutPageHint(this.getPageHint(pagesExecutor, pageNumber));
                    layoutEngine.layout(executor, report, emitter, this.needPaginate());
                }
                emitter.end(report);
                RenderTask.this.closeRender();
                executor.close();
            } else if ("no-pagination".equals(RenderTask.this.pagination)) {
                RenderTask.this.startRender();
                IReportContent report = executor.execute();
                emitter.start(report);
                long pageNumber = iter.next();
                layoutEngine.setLayoutPageHint(this.getPageHint(pagesExecutor, pageNumber));
                layoutEngine.layout(executor, report, emitter, false);
                emitter.end(report);
                RenderTask.this.closeRender();
                executor.close();
            }
        }
    }

    private static class ReportExecutorWrapper
    implements IReportExecutor {
        IReportItemExecutor executor;
        IReportExecutor reportExecutor;

        ReportExecutorWrapper(IReportItemExecutor itemExecutor, IReportExecutor reportExecutor) {
            this.executor = itemExecutor;
            this.reportExecutor = reportExecutor;
        }

        public void close() {
            this.executor.close();
        }

        public IReportItemExecutor createPageExecutor(long pageNumber, MasterPageDesign pageDesign) {
            return this.reportExecutor.createPageExecutor(pageNumber, pageDesign);
        }

        public IReportContent execute() {
            return this.reportExecutor.execute();
        }

        public IReportItemExecutor getNextChild() {
            return this.executor.getNextChild();
        }

        public boolean hasNextChild() {
            return this.executor.hasNextChild();
        }
    }

    private class ReportletRender
    extends InnerRender {
        private long offset;

        ReportletRender(InstanceID iid) throws EngineException {
            this.offset = RenderTask.this.reportDoc.getInstanceOffset(iid);
            if (this.offset == -1L) {
                throw new EngineException("Invalid instance id :" + iid);
            }
        }

        ReportletRender(String bookmark) throws EngineException {
            this.offset = RenderTask.this.reportDoc.getBookmarkOffset(bookmark);
            if (this.offset == -1L) {
                throw new EngineException("Invalid bookmark :" + bookmark);
            }
        }

        void render() throws Exception {
            RenderTask.this.setupRenderOption();
            IContentEmitter emitter = RenderTask.this.createContentEmitter();
            String format = RenderTask.this.executionContext.getOutputFormat();
            IReportExecutor executor = new ReportletExecutor(RenderTask.this.executionContext, this.offset);
            executor = new SuppressDuplciateReportExecutor(executor);
            executor = new LocalizedReportExecutor(RenderTask.this.executionContext, executor);
            RenderTask.this.executionContext.setExecutor(executor);
            RenderTask.this.initializeContentEmitter(emitter, executor);
            IReportLayoutEngine layoutEngine = RenderTask.this.createReportLayoutEngine(RenderTask.this.pagination, RenderTask.this.renderOptions);
            layoutEngine.setLocale(RenderTask.this.executionContext.getLocale());
            if ("paper-size-pagination".equals(RenderTask.this.pagination)) {
                OnPageBreakLayoutPageHandle handle = new OnPageBreakLayoutPageHandle(RenderTask.this.executionContext);
                layoutEngine.setPageHandler(handle);
                CompositeContentEmitter outputEmitters = new CompositeContentEmitter(format);
                outputEmitters.addEmitter(emitter);
                outputEmitters.addEmitter(handle.getEmitter());
                emitter = outputEmitters;
            }
            RenderTask.this.startRender();
            IReportContent report = executor.execute();
            emitter.start(report);
            layoutEngine.layout(executor, report, emitter, false);
            emitter.end(report);
            RenderTask.this.closeRender();
            executor.close();
        }
    }
}

