/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.ir.GroupDesign;

public class GroupContent
extends AbstractContent
implements IGroupContent {
    Boolean headerRepeat;
    String groupId;
    transient int groupLevel = -1;
    protected static final short FIELD_HEADER_REPEAT = 1500;

    public int getContentType() {
        return 15;
    }

    public GroupContent(IReportContent report) {
        super(report);
    }

    public IBandContent getHeader() {
        return this.getBand(3);
    }

    public IBandContent getFooter() {
        return this.getBand(4);
    }

    protected IBandContent getBand(int type) {
        if (this.children == null) {
            return null;
        }
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            IBandContent band;
            Object child = iter.next();
            if (!(child instanceof IBandContent) || (band = (IBandContent)child).getBandType() != type) continue;
            return band;
        }
        return null;
    }

    public String getGroupID() {
        return this.groupId;
    }

    public void setGroupID(String groupId) {
        this.groupId = groupId;
    }

    public boolean isHeaderRepeat() {
        if (this.headerRepeat != null) {
            return this.headerRepeat;
        }
        if (this.generateBy instanceof GroupDesign) {
            GroupDesign design = (GroupDesign)this.generateBy;
            return design.isHeaderRepeat();
        }
        return false;
    }

    public int getGroupLevel() {
        if (this.groupLevel == -1) {
            if (this.generateBy instanceof GroupDesign) {
                GroupDesign design = (GroupDesign)this.generateBy;
                this.groupLevel = design.getGroupLevel();
            } else if (this.parent instanceof GroupContent) {
                this.groupLevel = ((GroupContent)this.parent).getGroupLevel();
            } else {
                return 0;
            }
        }
        return this.groupLevel;
    }

    public void setHeaderRepeat(boolean repeat) {
        this.headerRepeat = repeat;
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitGroup(this, value);
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.headerRepeat != null) {
            IOUtil.writeShort((OutputStream)out, (short)1500);
            IOUtil.writeBool((OutputStream)out, (boolean)this.headerRepeat);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 1500: {
                this.headerRepeat = IOUtil.readBool((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }

    public boolean needSave() {
        if (this.headerRepeat != null) {
            return true;
        }
        return super.needSave();
    }
}

