/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class VerticalAlignManager
extends AbstractLengthManager {
    protected static final StringMap values;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.css.engine.value.css.VerticalAlignManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        values = new StringMap();
        values.put("baseline", CSSValueConstants.BASELINE_VALUE);
        values.put("sub", CSSValueConstants.SUB_VALUE);
        values.put("super", CSSValueConstants.SUPER_VALUE);
        values.put("top", CSSValueConstants.TOP_VALUE);
        values.put("text-top", CSSValueConstants.TEXT_TOP_VALUE);
        values.put("middle", CSSValueConstants.MIDDLE_VALUE);
        values.put("bottom", CSSValueConstants.BOTTOM_VALUE);
        values.put("text-bottom", CSSValueConstants.TEXT_BOTTOM_VALUE);
    }

    public String getPropertyName() {
        return "vertical-align";
    }

    public boolean isInheritedProperty() {
        return false;
    }

    public Value getDefaultValue() {
        return CSSValueConstants.BASELINE_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 21: {
                    return value;
                }
                case 2: {
                    float scale = value.getFloatValue();
                    float fs = 0.0f;
                    IStyle cs = elt.getComputedStyle();
                    if (!$assertionsDisabled && cs == null) {
                        throw new AssertionError();
                    }
                    Value lineHeight = (Value)cs.getProperty(2);
                    if (!$assertionsDisabled && lineHeight == null) {
                        throw new AssertionError();
                    }
                    Value fontSize = (Value)cs.getProperty(38);
                    fs = lineHeight == CSSValueConstants.NORMAL_VALUE ? 1.2f * fontSize.getFloatValue() : (lineHeight.getPrimitiveType() == 1 ? lineHeight.getFloatValue() * fontSize.getFloatValue() : lineHeight.getFloatValue());
                    return new FloatValue(1, fs * scale);
                }
            }
        }
        return super.computeValue(elt, engine, idx, value);
    }
}

