/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ExtendedGenerateExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;

public class ExtendedItemExecutor
extends ReportItemExecutor {
    protected IReportItemExecutor executor;

    public ExtendedItemExecutor(ExecutorManager manager) {
        super(manager, 8);
    }

    public IContent execute() {
        if (this.executor != null) {
            if (this.executor instanceof ExtendedGenerateExecutor) {
                ExtendedGenerateExecutor gExecutor = (ExtendedGenerateExecutor)this.executor;
                gExecutor.parent = this.parent;
                gExecutor.context = this.context;
                gExecutor.report = this.report;
                gExecutor.design = this.design;
            }
            this.content = this.executor.execute();
            if (this.content != null) {
                InstanceID iid;
                IContent pContent = (IContent)this.content.getParent();
                if (pContent == null) {
                    pContent = this.getParentContent();
                    this.content.setParent(pContent);
                }
                if ((iid = this.content.getInstanceID()) != null) {
                    long uid;
                    InstanceID pid = iid.getParentID();
                    if (pid == null && pContent != null) {
                        pid = pContent.getInstanceID();
                    }
                    if ((uid = iid.getUniqueID()) == -1L) {
                        uid = this.generateUniqueID();
                    }
                    iid = new InstanceID(pid, uid, iid.getComponentID(), iid.getDataID());
                    this.content.setInstanceID(iid);
                } else {
                    iid = this.getInstanceID();
                    this.content.setInstanceID(iid);
                }
                if (this.context.isInFactory()) {
                    this.handleOnCreate(this.content);
                }
                this.startTOCEntry(this.content);
            }
        }
        return this.content;
    }

    public boolean hasNextChild() {
        if (this.executor != null) {
            return this.executor.hasNextChild();
        }
        return false;
    }

    public IReportItemExecutor getNextChild() {
        IReportItemExecutor child;
        if (this.executor != null && (child = this.executor.getNextChild()) != null) {
            if (child instanceof ReportItemExecutor) {
                child.setParent(this);
                return child;
            }
            return this.manager.createExtendedExecutor(this, child);
        }
        return null;
    }

    public void close() {
        if (this.executor != null) {
            this.executor.close();
            this.finishTOCEntry();
        }
        this.executor = null;
        super.close();
    }

    public IBaseResultSet[] getQueryResults() {
        if (this.executor != null) {
            return this.executor.getQueryResults();
        }
        return null;
    }
}

