/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.net.URL;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.util.FileUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;

public class ImageItemExecutor
extends QueryItemExecutor {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.executor.ImageItemExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ImageItemExecutor(ExecutorManager manager) {
        super(manager, 1);
    }

    public IContent execute() {
        ImageItemDesign imageDesign = (ImageItemDesign)this.getDesign();
        IImageContent imageContent = this.report.createImageContent();
        this.setContent(imageContent);
        this.executeQuery();
        this.initializeContent(imageDesign, imageContent);
        this.processAction(imageDesign, imageContent);
        this.processBookmark(imageDesign, imageContent);
        this.processStyle(imageDesign, imageContent);
        this.processVisibility(imageDesign, imageContent);
        this.handleImage(imageDesign, imageContent);
        if (this.context.isInFactory()) {
            this.handleOnCreate(imageContent);
        }
        this.startTOCEntry(imageContent);
        return imageContent;
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }

    protected void handleImage(ImageItemDesign imageDesign, IImageContent imageContent) {
        switch (imageDesign.getImageSource()) {
            case 0: {
                String imageExpr = imageDesign.getImageUri();
                if (imageExpr == null) break;
                this.handleURIImage(imageExpr, imageContent);
                break;
            }
            case 3: {
                String fileExpr = imageDesign.getImageUri();
                if (!$assertionsDisabled && fileExpr == null) {
                    throw new AssertionError();
                }
                this.handleFileExpressionImage(fileExpr, imageContent);
                break;
            }
            case 1: {
                String imageName = imageDesign.getImageName();
                if (!$assertionsDisabled && imageName == null) {
                    throw new AssertionError();
                }
                this.handleNamedImage(imageName, imageContent);
                break;
            }
            case 2: {
                String imgExpr = imageDesign.getImageExpression();
                String fmtExpr = imageDesign.getImageFormat();
                if (!$assertionsDisabled && imgExpr == null) {
                    throw new AssertionError();
                }
                this.handleValueImage(imgExpr, fmtExpr, imageContent);
                break;
            }
            default: {
                logger.log(Level.SEVERE, "[ImageItemExecutor] invalid image source");
                this.context.addException(imageDesign.getHandle(), new EngineException("Error.InvalidImageSourceError"));
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
    }

    protected void handleURIImage(String uriExpr, IImageContent imageContent) {
        imageContent.setImageSource(3);
        if (!$assertionsDisabled && uriExpr == null) {
            throw new AssertionError();
        }
        Object uriObj = this.evaluate(uriExpr);
        String strUri = null;
        if (uriObj != null) {
            strUri = uriObj.toString();
        } else if (uriExpr != null && uriExpr.length() > 0) {
            strUri = uriExpr;
        }
        ReportDesignHandle reportDesign = this.context.getDesign();
        URL uri = reportDesign.findResource(strUri, 1);
        if (uri != null) {
            if ("file".equals(uri.getProtocol())) {
                this.handleFileImage(strUri, imageContent);
            } else {
                imageContent.setURI(uri.toExternalForm());
            }
        } else {
            this.handleFileImage(strUri, imageContent);
        }
    }

    protected void handleNamedImage(String imageName, IImageContent imageContent) {
        imageContent.setImageSource(1);
        imageContent.setURI(null);
        EmbeddedImage embeddedImage = this.context.getReport().getReportDesign().findImage(imageName);
        if (embeddedImage != null) {
            imageContent.setData(embeddedImage.getData(this.context.getDesign().getModule()));
            String extension = FileUtil.getExtFromType(embeddedImage.getType(this.context.getDesign().getModule()));
            if (extension != null) {
                imageContent.setExtension(extension);
            }
            imageContent.setURI(imageName);
        }
    }

    protected void handleValueImage(String imgExpr, String fmtExpr, IImageContent imageContent) {
        Object strValue;
        byte[] imgData = null;
        String imgExt = "";
        imageContent.setImageSource(2);
        Object value = this.evaluate(imgExpr);
        if (value instanceof byte[]) {
            imgData = (byte[])value;
        }
        if (fmtExpr != null && (strValue = this.evaluate(fmtExpr)) != null) {
            imgExt = strValue.toString();
            imgExt = FileUtil.getExtFromType(imgExt);
        }
        if (imgData != null) {
            imageContent.setData(imgData);
            imageContent.setExtension(imgExt);
            imageContent.setURI(null);
        }
    }

    protected void handleFileExpressionImage(String fileExpr, IImageContent imageContent) {
        String imageFile = "";
        Object file = this.evaluate(fileExpr);
        if (file != null) {
            imageFile = file.toString();
        } else if (fileExpr != null && fileExpr.length() > 0) {
            imageFile = fileExpr;
        }
        this.handleFileImage(imageFile, imageContent);
    }

    protected void handleFileImage(String imageFile, IImageContent imageContent) {
        URL url;
        ReportDesignHandle reportDesign = this.context.getDesign();
        if (reportDesign != null && (url = reportDesign.findResource(imageFile, 1)) != null) {
            imageFile = url.toString();
        }
        imageContent.setURI(imageFile);
        imageContent.setImageSource(0);
        imageContent.setExtension(FileUtil.getExtFromFileName(imageFile));
        if (imageFile == null) {
            logger.log(Level.SEVERE, "[ImageItemExecutor] Source image file is missing");
            this.context.addException(this.design.getHandle(), new EngineException("Error.MissingImageFileError"));
        }
    }
}

