/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.StyledItemExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public abstract class QueryItemExecutor
extends StyledItemExecutor {
    protected boolean rsetEmpty;

    protected QueryItemExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    protected void closeQuery() {
        if (this.rset != null) {
            this.rset.close();
            this.rset = null;
        }
    }

    protected void executeQuery() {
        IDataQueryDefinition[] queries;
        DesignElementHandle elementHandle;
        this.rset = null;
        boolean useCache = false;
        IDataQueryDefinition query = this.design.getQuery();
        if (query == null && (elementHandle = this.design.getHandle()) instanceof ReportElementHandle && (queries = this.report.getDesign().getQueryByReportHandle((ReportElementHandle)elementHandle)) != null && queries.length > 0) {
            query = queries[0];
            useCache = true;
        }
        IBaseResultSet parentRset = this.getParentResultSet();
        this.context.setResultSet(parentRset);
        if (query != null) {
            try {
                this.rset = (IQueryResultSet)this.context.executeQuery(parentRset, query, useCache);
                this.context.setResultSet(this.rset);
                if (this.rset != null) {
                    this.rsetEmpty = !this.rset.next();
                    return;
                }
            }
            catch (BirtException ex) {
                this.rsetEmpty = true;
                this.context.addException(ex);
            }
        }
    }

    protected void accessQuery(ReportItemDesign design, IContentEmitter emitter) {
    }

    public void close() {
        this.rset = null;
        this.rsetEmpty = false;
        super.close();
    }
}

