/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.SecurityController;

public class ScriptUtil {
    public static SecurityController createSecurityController() {
        return new SecurityController(){

            public GeneratedClassLoader createClassLoader(ClassLoader parentLoader, Object securityDomain) {
                ProtectionDomain domain = (ProtectionDomain)securityDomain;
                return new Loader(parentLoader, domain);
            }

            public Object getDynamicSecurityDomain(Object securityDomain) {
                ProtectionDomain staticDomain = (ProtectionDomain)securityDomain;
                return this.getDynamicDomain(staticDomain);
            }

            private ProtectionDomain getDynamicDomain(ProtectionDomain staticDomain) {
                ContextPermissions permission = new ContextPermissions(staticDomain);
                ProtectionDomain contextDomain = new ProtectionDomain(null, permission);
                return contextDomain;
            }
        };
    }

    public static class ContextPermissions
    extends PermissionCollection {
        private AccessControlContext context = AccessController.getContext();
        private PermissionCollection statisPermissions;
        private static final long serialVersionUID = -1721494496320750721L;

        public ContextPermissions(ProtectionDomain staticDomain) {
            if (staticDomain != null) {
                this.statisPermissions = staticDomain.getPermissions();
            }
            this.setReadOnly();
        }

        public void add(Permission permission) {
            throw new RuntimeException("NOT IMPLEMENTED");
        }

        public boolean implies(Permission permission) {
            if (this.statisPermissions != null && !this.statisPermissions.implies(permission)) {
                return false;
            }
            try {
                this.context.checkPermission(permission);
                return true;
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
        }

        public Enumeration elements() {
            return new Enumeration(this){
                final /* synthetic */ ContextPermissions this$1;
                {
                    this.this$1 = contextPermissions;
                }

                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }
    }

    public static class Loader
    extends ClassLoader
    implements GeneratedClassLoader {
        private ProtectionDomain domain;

        Loader(ClassLoader parent, ProtectionDomain domain) {
            super(parent != null ? parent : Loader.getSystemClassLoader());
            this.domain = domain;
        }

        public Class defineClass(String name, byte[] data) {
            return super.defineClass(name, data, 0, data.length, this.domain);
        }

        public void linkClass(Class cl) {
            this.resolveClass(cl);
        }
    }
}

