/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout;

import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;

public class LayoutUtil {
    public static boolean isRowHidden(Object rowContent, String format) {
        if (rowContent != null && rowContent instanceof IRowContent) {
            IStyle style = ((IRowContent)rowContent).getStyle();
            if (IStyle.NONE_VALUE.equals(style.getProperty(33))) {
                return true;
            }
            String formats = style.getVisibleFormat();
            if (formats != null && (formats.indexOf(format) >= 0 || formats.indexOf("all") >= 0)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRepeatableRow(IRowContent row) {
        IContent parent = (IContent)row.getParent();
        if (parent != null && parent instanceof IBandContent) {
            IContent pp;
            IBandContent band = (IBandContent)parent;
            int type = band.getBandType();
            if (type == 1) {
                IContent pp2 = (IContent)band.getParent();
                if (pp2 != null && pp2 instanceof ITableContent) {
                    ITableContent table = (ITableContent)band.getParent();
                    return table.isHeaderRepeat();
                }
            } else if (type == 3 && (pp = (IContent)band.getParent()) != null && pp instanceof IGroupContent) {
                IGroupContent group = (IGroupContent)band.getParent();
                return group.isHeaderRepeat();
            }
        }
        return false;
    }
}

