/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.area.impl;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.w3c.dom.css.CSSValue;

public class CellArea
extends ContainerArea {
    static Value DEFAULT_PADDING = new FloatValue(1, 1500.0f);
    protected int rowSpan = 0;

    public CellArea() {
        super((IContent)null);
    }

    CellArea(ICellContent cell) {
        super(cell);
        this.removeBorder();
        this.setDefaultPadding();
    }

    public int getColumnID() {
        if (this.content != null) {
            return ((ICellContent)this.content).getColumn();
        }
        return 0;
    }

    public int getRowID() {
        if (this.content != null) {
            return ((ICellContent)this.content).getRow();
        }
        return 0;
    }

    public int getColSpan() {
        if (this.content != null) {
            return ((ICellContent)this.content).getColSpan();
        }
        return 1;
    }

    public int getRowSpan() {
        if (this.rowSpan == 0 && this.content != null) {
            return ((ICellContent)this.content).getRowSpan();
        }
        return this.rowSpan;
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    protected void setDefaultPadding() {
        if (this.content != null) {
            IStyle contentStyle = this.content.getStyle();
            CSSValue padding = contentStyle.getProperty(56);
            if (padding == null) {
                this.style.setProperty(56, DEFAULT_PADDING);
            }
            if ((padding = contentStyle.getProperty(55)) == null) {
                this.style.setProperty(55, DEFAULT_PADDING);
            }
            if ((padding = contentStyle.getProperty(36)) == null) {
                this.style.setProperty(36, DEFAULT_PADDING);
            }
            if ((padding = contentStyle.getProperty(37)) == null) {
                this.style.setProperty(37, DEFAULT_PADDING);
            }
        }
    }
}

