/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.layout.html.HTMLReportLayoutEngine;
import org.eclipse.birt.report.engine.presentation.IPageHint;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class HTMLLayoutContext {
    protected String masterPage = null;
    protected boolean allowPageBreak = true;
    protected boolean pageEmpty = true;
    protected boolean finished;
    protected long pageNumber;
    protected HTMLReportLayoutEngine engine;
    protected HashMap layoutHint = new HashMap();
    boolean cancelFlag = false;
    boolean skipPageHint = false;
    ArrayList pageHint = new ArrayList();
    IContent startContent = null;
    IContent currentContent = null;
    protected ArrayList hints = new ArrayList();
    protected ArrayList currentHints = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void reset() {
        this.pageEmpty = true;
        this.layoutHint = new HashMap();
        this.finished = false;
        this.allowPageBreak = true;
        this.masterPage = null;
    }

    public void addLayoutHint(IContent content, boolean finished) {
        this.layoutHint.put(content, new Boolean(finished));
    }

    public boolean getLayoutHint(IContent content) {
        Object finished = this.layoutHint.get(content);
        if (finished != null && finished instanceof Boolean) {
            return (Boolean)finished;
        }
        return true;
    }

    public void removeLayoutHint() {
        this.layoutHint.clear();
    }

    public String getMasterPage() {
        return this.masterPage;
    }

    public void setMasterPage(String masterPage) {
        this.masterPage = masterPage;
    }

    public HTMLLayoutContext(HTMLReportLayoutEngine engine) {
        this.engine = engine;
    }

    public boolean allowPageBreak() {
        return this.allowPageBreak;
    }

    public void setAllowPageBreak(boolean allowPageBreak) {
        this.allowPageBreak = allowPageBreak;
    }

    public boolean isPageEmpty() {
        return this.pageEmpty;
    }

    public void setPageEmpty(boolean pageEmpty) {
        this.pageEmpty = pageEmpty;
    }

    public void setFinish(boolean finished) {
        this.finished = finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    void setCancelFlag(boolean flag) {
        this.cancelFlag = flag;
    }

    public boolean getCancelFlag() {
        return this.cancelFlag;
    }

    void setSkipPageHint(boolean skip) {
        this.skipPageHint = skip;
    }

    boolean getSkipPageHint() {
        return this.skipPageHint;
    }

    public void startContent(IContent content) {
        if (!this.skipPageHint) {
            if (this.startContent == null) {
                this.startContent = content;
            }
            this.currentContent = content;
        }
    }

    public void continueContent(IContent content) {
        if (!this.skipPageHint && this.startContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public void endContent(IContent content) {
    }

    public void endContentWithPageBreak(IContent content) {
        if (!this.skipPageHint && this.startContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public void skipContent(IContent content) {
        if (!this.skipPageHint && this.startContent != null) {
            this.pageHint.add(new IContent[]{this.startContent, this.currentContent});
            this.startContent = null;
            this.currentContent = null;
        }
    }

    public ArrayList getPageHint() {
        ArrayList<IContent[]> hint = new ArrayList<IContent[]>();
        hint.addAll(this.pageHint);
        if (this.startContent != null) {
            if (!$assertionsDisabled && this.currentContent == null) {
                throw new AssertionError();
            }
            hint.add(new IContent[]{this.startContent, this.currentContent});
        }
        return hint;
    }

    public List getUnresolvedRowHints() {
        return this.hints;
    }

    public UnresolvedRowHint getUnresolvedRowHint(ITableContent table) {
        if (this.hints.size() > 0) {
            String idStr = table.getInstanceID().toUniqueString();
            Iterator iter = this.hints.iterator();
            while (iter.hasNext()) {
                UnresolvedRowHint rowHint = (UnresolvedRowHint)iter.next();
                if (!idStr.equals(rowHint.getTableId())) continue;
                return rowHint;
            }
        }
        return null;
    }

    public void addUnresolvedRowHint(UnresolvedRowHint hint) {
        this.currentHints.add(hint);
    }

    public void clearPageHint() {
        this.pageHint.clear();
        this.hints.clear();
        this.hints.addAll(this.currentHints);
        this.currentHints.clear();
        this.startContent = null;
        this.currentContent = null;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        if (pageHint != null) {
            this.pageNumber = pageHint.getPageNumber();
            int count = pageHint.getUnresolvedRowCount();
            int i = 0;
            while (i < count) {
                this.hints.add(pageHint.getUnresolvedRowHint(i));
                ++i;
            }
        }
    }
}

