/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.html.HTMLAbstractLM;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.html.HTMLPageLM;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class HTMLReportLayoutEngine
implements IReportLayoutEngine {
    protected HTMLLayoutContext context;
    protected HTMLLayoutManagerFactory factory;
    protected ILayoutPageHandler pageHandler;
    protected IReportExecutor executor;
    protected HashMap options = new HashMap();
    protected Locale locale;
    protected IPageHint pageHint;

    public HTMLReportLayoutEngine() {
        this.context = new HTMLLayoutContext(this);
        this.factory = new HTMLLayoutManagerFactory(this);
    }

    HTMLLayoutContext getContext() {
        return this.context;
    }

    HTMLLayoutManagerFactory getFactory() {
        return this.factory;
    }

    public void layout(IReportExecutor executor, IReportContent report, IContentEmitter emitter, boolean pagination) {
        this.executor = executor;
        this.context.setAllowPageBreak(pagination);
        this.context.setFinish(false);
        if (this.pageHint != null) {
            this.context.setLayoutPageHint(this.pageHint);
        }
        HTMLPageLM pageLM = new HTMLPageLM(this, report, executor, emitter);
        boolean finished = false;
        do {
            pageLM.layout();
        } while (!(finished = pageLM.isFinished()));
        pageLM.close();
        this.context.setFinish(true);
        if (this.pageHandler != null) {
            this.pageHandler.onPage(this.context.getPageNumber(), this.context);
        }
        executor.close();
        this.context.reset();
        this.pageHint = null;
    }

    public void layout(ILayoutManager parent, IReportItemExecutor executor, IContentEmitter emitter) {
        IContent content = executor.execute();
        HTMLAbstractLM layoutManager = this.factory.createLayoutManager((HTMLAbstractLM)parent, content, executor, emitter);
        boolean hasNext = layoutManager.layout();
        while (hasNext) {
            hasNext = layoutManager.layout();
        }
        layoutManager.close();
    }

    public void layout(ILayoutManager parent, IContent content, IContentEmitter output) {
        DOMReportItemExecutor executor = new DOMReportItemExecutor(content);
        this.layout(parent, executor, output);
        executor.close();
    }

    ILayoutManager createLayoutManager(HTMLAbstractLM parent, IContent content, IReportItemExecutor executor, IContentEmitter emitter) {
        return this.factory.createLayoutManager(parent, content, executor, emitter);
    }

    public void setPageHandler(ILayoutPageHandler handler) {
        this.pageHandler = handler;
    }

    public ILayoutPageHandler getPageHandler() {
        return this.pageHandler;
    }

    public void cancel() {
        if (this.context != null) {
            this.context.setCancelFlag(true);
        }
    }

    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        this.pageHint = pageHint;
    }
}

