/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableRegionLM;

public class PDFTableGroupLM
extends PDFGroupLM
implements IBlockStackingLayoutManager {
    protected PDFTableLM tableLM = this.getTableLayoutManager();
    protected boolean needRepeat = false;

    public PDFTableGroupLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.tableLM.startGroup((IGroupContent)content);
    }

    protected boolean traverseChildren() {
        boolean childBreak = super.traverseChildren();
        if (!childBreak) {
            this.tableLM.endGroup((IGroupContent)this.content);
        }
        return childBreak;
    }

    protected void createRoot() {
        if (this.root == null) {
            this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
        }
    }

    protected void initialize() {
        if (this.root == null && this.keepWithCache.isEmpty() && !this.isFirst) {
            this.repeatCount = 0;
            this.needRepeat = true;
        }
        super.initialize();
    }

    private void repeat() {
        IContent content;
        if (this.isFirst || this.tableLM.isFirst) {
            this.isFirst = false;
            return;
        }
        if (!this.needRepeat || !this.isCurrentDetailBand()) {
            return;
        }
        ITableBandContent header = (ITableBandContent)this.groupContent.getHeader();
        if (!this.isRepeatHeader() || header == null) {
            return;
        }
        if (header.getChildren().isEmpty()) {
            return;
        }
        if (this.child != null && (content = this.child.getContent()) instanceof ITableBandContent && ((ITableBandContent)content).getBandType() == 3) {
            return;
        }
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(header);
        headerExecutor.execute();
        PDFTableRegionLM regionLM = this.tableLM.getTableRegionLayout();
        regionLM.initialize(header);
        regionLM.setGroupLevel(this.getGroupLevel());
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.tableLM.getContent().getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getCurrentMaxContentHeight()) {
            Iterator iter = tableRegion.getChildren();
            RowArea row = null;
            int count = 0;
            while (iter.hasNext()) {
                row = (RowArea)iter.next();
                this.addArea(row, false, this.pageBreakAvoid);
                this.tableLM.addRow(row, true, false);
                ++count;
            }
            this.repeatCount += count;
        }
        this.tableLM.getContent().setExtension(1, null);
        this.needRepeat = false;
    }

    protected int getGroupLevel() {
        if (this.content != null && this.content instanceof IGroupContent) {
            return ((IGroupContent)this.content).getGroupLevel();
        }
        return 0;
    }

    protected void repeatHeader() {
        this.repeat();
        this.skipCachedRow();
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    protected boolean isCurrentDetailBand() {
        if (this.child != null) {
            IContent c = this.child.getContent();
            if (c != null) {
                IBandContent band;
                if (c instanceof IGroupContent) {
                    return true;
                }
                if (c instanceof IBandContent && (band = (IBandContent)c).getBandType() == 0) {
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    protected void skipCachedRow() {
        if (this.keepWithCache.isEmpty()) {
            return;
        }
        Iterator iter = this.keepWithCache.getChildren();
        while (iter.hasNext()) {
            ContainerArea container = (ContainerArea)iter.next();
            this.skip(container);
        }
    }

    protected void skip(ContainerArea area) {
        if (area instanceof RowArea) {
            this.tableLM.skipRow((RowArea)area);
        } else {
            Iterator iter = area.getChildren();
            while (iter.hasNext()) {
                ContainerArea container = (ContainerArea)iter.next();
                this.skip(container);
            }
        }
    }
}

