/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.engine.layout.pdf.cache.ClonedCellContent;
import org.eclipse.birt.report.engine.layout.pdf.cache.CursorableList;
import org.eclipse.birt.report.engine.layout.pdf.cache.DummyCell;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;
import org.w3c.dom.css.CSSValue;

public class TableAreaLayout {
    protected CursorableList rows = new CursorableList();
    protected BorderConflictResolver bcr = new BorderConflictResolver();
    protected int columnNumber;
    protected PDFTableLM.TableLayoutInfo layoutInfo = null;
    protected ITableContent tableContent;
    protected ICellContent lastCellContent;
    protected int start = 0;
    protected int end = 0;
    protected boolean hasDropCell = true;
    protected Row unresolvedRow;
    protected boolean firstRow = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.cache.TableAreaLayout");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TableAreaLayout(ITableContent tableContent, PDFTableLM.TableLayoutInfo layoutInfo, int start, int columnNumber) {
        this.tableContent = tableContent;
        this.layoutInfo = layoutInfo;
        this.start = start;
        this.end = start + columnNumber;
        this.columnNumber = columnNumber;
    }

    public void initTableLayout(UnresolvedRowHint hint) {
        if (hint != null) {
            IReportContent report = this.tableContent.getReportContent();
            IRowContent rowContent = report.createRowContent();
            InstanceID rowId = InstanceID.parse(hint.getRowId());
            rowContent.setInstanceID(rowId);
            rowContent.setParent(this.tableContent);
            RowArea rowArea = AreaFactory.createRowArea(rowContent);
            this.unresolvedRow = new Row(rowArea, this.start, this.end - this.start, false);
            int i = this.start;
            while (i < this.end) {
                ICellContent cellContent = report.createCellContent();
                hint.initUnresolvedCell(cellContent, rowId, i);
                cellContent.setParent(rowContent);
                CellArea cellArea = AreaFactory.createCellArea(cellContent);
                this.unresolvedRow.addArea(cellArea);
                i = i + cellArea.getColSpan() - 1;
                ++i;
            }
        }
    }

    public void setUnresolvedRow(Row row) {
        this.unresolvedRow = row;
    }

    public Row getUnresolvedRow() {
        return (Row)this.rows.getCurrent();
    }

    protected int resolveBottomBorder(CellArea cell, boolean isLast) {
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IContent cellContent = cell.getContent();
        IStyle columnStyle = this.getColumnStyle(cell.getColumnID());
        IStyle cellAreaStyle = cell.getStyle();
        if (isLast) {
            IStyle cellContentStyle = cellContent.getComputedStyle();
            IStyle rowStyle = ((IContent)cellContent.getParent()).getComputedStyle();
            this.bcr.resolveTableBottomBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
        } else {
            this.bcr.resolveTableBottomBorder(tableStyle, null, columnStyle, null, cellAreaStyle);
        }
        return PropertyUtil.getDimensionValue(cellAreaStyle.getProperty(19));
    }

    protected void add(ContainerArea area, ArrayList rows) {
        if (area instanceof RowArea) {
            rows.add(area);
        } else {
            Iterator iter = area.getChildren();
            while (iter.hasNext()) {
                ContainerArea container = (ContainerArea)iter.next();
                this.add(container, rows);
            }
        }
    }

    public void remove(TableArea table) {
        this.firstRow = true;
        ArrayList rowColloection = new ArrayList();
        this.add(table, rowColloection);
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (!rowColloection.contains(row.getArea())) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    public void resolveBorderConflict(CellArea cellArea, boolean isFirst) {
        IContent cellContent = cellArea.getContent();
        int columnID = cellArea.getColumnID();
        int colSpan = cellArea.getColSpan();
        IRowContent row = (IRowContent)cellContent.getParent();
        IStyle cellContentStyle = cellContent.getComputedStyle();
        IStyle cellAreaStyle = cellArea.getStyle();
        IStyle tableStyle = this.tableContent.getComputedStyle();
        IStyle rowStyle = row.getComputedStyle();
        IStyle columnStyle = this.getColumnStyle(columnID);
        IStyle preRowStyle = null;
        IStyle preColumnStyle = this.getColumnStyle(columnID - 1);
        IStyle leftCellContentStyle = null;
        IStyle topCellStyle = null;
        if (this.lastCellContent != null && this.lastCellContent.getColumn() < columnID) {
            leftCellContentStyle = this.lastCellContent.getComputedStyle();
        }
        Row lastRow = null;
        if (this.rows.size() > 0) {
            lastRow = (Row)this.rows.getCurrent();
        }
        if (lastRow != null) {
            preRowStyle = lastRow.getContent().getComputedStyle();
            CellArea cell = lastRow.getCell(columnID);
            if (cell != null && cell.getContent() != null) {
                topCellStyle = cell.getContent().getComputedStyle();
            }
        }
        if (this.rows.size() == 0 && lastRow == null) {
            if (isFirst) {
                this.bcr.resolveTableTopBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveTableTopBorder(tableStyle, null, columnStyle, null, cellAreaStyle);
            }
            if (columnID == 0) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan == this.columnNumber) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        } else {
            if (isFirst) {
                this.bcr.resolveCellTopBorder(preRowStyle, rowStyle, topCellStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellTopBorder(preRowStyle, null, topCellStyle, null, cellAreaStyle);
            }
            if (columnID == 0) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan == this.columnNumber) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        }
        this.lastCellContent = (ICellContent)cellContent;
    }

    private IStyle getColumnStyle(int columnID) {
        return null;
    }

    protected void verticalAlign(CellArea c) {
        CSSValue align;
        Iterator iter;
        CellArea cell = c instanceof DummyCell ? ((DummyCell)c).getCell() : c;
        IContent content = cell.getContent();
        if (content == null) {
            return;
        }
        CSSValue verticalAlign = content.getComputedStyle().getProperty(30);
        if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
            int totalHeight = 0;
            iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                totalHeight += child.getAllocatedHeight();
            }
            int offset = cell.getContentHeight() - totalHeight;
            if (offset > 0) {
                AbstractArea child;
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                    }
                }
            }
        }
        if (IStyle.RIGHT_VALUE.equals(align = content.getComputedStyle().getProperty(26)) || IStyle.CENTER_VALUE.equals(align)) {
            iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                int spacing = cell.getContentWidth() - area.getAllocatedWidth();
                if (spacing <= 0) continue;
                if (IStyle.RIGHT_VALUE.equals(align)) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        }
    }

    public void reset(TableArea table) {
        this.firstRow = true;
        Iterator iter = this.rows.iterator();
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            if (!table.contains(row.getArea())) continue;
            iter.remove();
        }
        this.rows.resetCursor();
    }

    public void resolveDropCells(int dropValue) {
        int rowHeight;
        if (!$assertionsDisabled && dropValue >= 0) {
            throw new AssertionError();
        }
        if (this.rows.size() == 0 || !this.hasDropCell) {
            return;
        }
        Row row = (Row)this.rows.getCurrent();
        if (!$assertionsDisabled && row == null) {
            throw new AssertionError();
        }
        int height = rowHeight = row.getArea().getHeight();
        boolean needResolve = false;
        int i = 0;
        while (i < this.columnNumber) {
            CellArea cell = row.getCell(this.start + i);
            if (cell != null && cell.getRowSpan() == dropValue) {
                height = Math.max(height, cell.getHeight());
                needResolve = true;
            }
            ++i;
        }
        if (needResolve) {
            HashSet<CellArea> dropCells = new HashSet<CellArea>();
            int delta = height - rowHeight;
            int i2 = 0;
            while (i2 < this.columnNumber) {
                CellArea cell = row.getCell(this.start + i2);
                if (cell != null) {
                    CellArea ref;
                    if (cell.getRowSpan() == dropValue) {
                        if (cell instanceof DummyCell) {
                            ref = ((DummyCell)cell).getCell();
                            int cellHeight = cell.getHeight();
                            int refHeight = ref.getHeight();
                            if (!dropCells.contains(ref)) {
                                ref.setHeight(refHeight - cellHeight + delta);
                                this.verticalAlign(ref);
                                dropCells.add(ref);
                            }
                        } else {
                            cell.setHeight(height);
                            this.verticalAlign(cell);
                        }
                        cell.setRowSpan(1);
                    } else if (cell.getRowSpan() == 1) {
                        if (cell instanceof DummyCell) {
                            ref = ((DummyCell)cell).getCell();
                            if (!dropCells.contains(ref)) {
                                ref.setHeight(ref.getHeight() + delta);
                                if (delta > 0) {
                                    this.verticalAlign(ref);
                                }
                                dropCells.add(ref);
                            }
                        } else {
                            cell.setHeight(height);
                            this.verticalAlign(cell);
                        }
                    }
                }
                ++i2;
            }
        }
    }

    public void resolveAll() {
        int rowHeight;
        if (this.rows.size() == 0 || !this.hasDropCell) {
            return;
        }
        Row row = (Row)this.rows.getCurrent();
        int height = rowHeight = row.getArea().getHeight();
        boolean hasDropCell = false;
        int i = 0;
        while (i < this.columnNumber) {
            CellArea cell = row.getCell(this.start + i);
            if (cell != null && (this.isDropCell(cell) || cell.getRowSpan() > 1)) {
                height = Math.max(height, cell.getHeight());
                hasDropCell = true;
            }
            ++i;
        }
        if (hasDropCell) {
            HashSet<CellArea> dropCells = new HashSet<CellArea>();
            int delta = height - rowHeight;
            if (delta > 0) {
                row.getArea().setHeight(height);
            }
            int i2 = 0;
            while (i2 < this.columnNumber) {
                CellArea cell = row.getCell(this.start + i2);
                if (cell != null) {
                    CellArea ref;
                    int rowSpan = cell.getRowSpan();
                    if (rowSpan < 0 || rowSpan > 1) {
                        if (cell instanceof DummyCell) {
                            ref = ((DummyCell)cell).getCell();
                            int cellHeight = cell.getHeight();
                            int refHeight = ref.getHeight();
                            if (!dropCells.contains(ref)) {
                                ref.setHeight(refHeight - cellHeight + delta);
                                this.verticalAlign(ref);
                                dropCells.add(ref);
                            }
                        } else {
                            cell.setHeight(height);
                            this.verticalAlign(cell);
                        }
                    } else if (rowSpan == 1) {
                        if (cell instanceof DummyCell) {
                            ref = ((DummyCell)cell).getCell();
                            if (!dropCells.contains(ref)) {
                                ref.setHeight(ref.getHeight() + delta);
                                if (delta > 0) {
                                    this.verticalAlign(ref);
                                }
                                dropCells.add(ref);
                            }
                        } else {
                            cell.setHeight(height);
                            this.verticalAlign(cell);
                        }
                    }
                }
                ++i2;
            }
        }
        if (hasDropCell || row != null && !row.finished) {
            this.unresolvedRow = row;
        }
    }

    public int resolveBottomBorder() {
        CellArea cell;
        if (this.rows.size() == 0) {
            return 0;
        }
        Row row = (Row)this.rows.getCurrent();
        HashSet<CellArea> cells = new HashSet<CellArea>();
        int result = 0;
        int i = 0;
        while (i < this.columnNumber) {
            cell = row.getCell(this.start + i);
            if (cell != null) {
                if (cell instanceof DummyCell) {
                    CellArea ref = ((DummyCell)cell).getCell();
                    if (!cells.contains(ref)) {
                        int width = this.resolveBottomBorder(ref, row.finished);
                        if (width > result) {
                            result = width;
                        }
                        cells.add(ref);
                    }
                } else if (!cells.contains(cell)) {
                    int width = this.resolveBottomBorder(cell, row.finished);
                    if (width > result) {
                        result = width;
                    }
                    cells.add(cell);
                }
            }
            ++i;
        }
        if (result > 0 && cells.size() > 0) {
            Iterator iter = cells.iterator();
            while (iter.hasNext()) {
                cell = (CellArea)iter.next();
                cell.setHeight(cell.getHeight() + result);
            }
            row.getArea().setHeight(row.getArea().getHeight() + result);
        }
        return result;
    }

    public void addRow(RowArea rowArea, boolean finished, boolean repeated) {
        if (!repeated) {
            this.firstRow = false;
        }
        this.hasDropCell = !finished;
        Row lastRow = (Row)this.rows.getCurrent();
        Row row = new Row(rowArea, this.start, this.columnNumber, finished, repeated);
        int rowHeight = rowArea.getHeight();
        HashSet<CellArea> dropCells = new HashSet<CellArea>();
        int i = 0;
        while (i < this.columnNumber) {
            CellArea cell;
            CellArea lastCell = null;
            if (lastRow != null) {
                lastCell = lastRow.getCell(this.start + i);
            }
            if ((cell = row.getCell(this.start + i)) != null && (cell.getRowSpan() > 1 || this.isDropCell(cell))) {
                this.hasDropCell = true;
            }
            if (lastCell != null && (lastCell.getRowSpan() > 1 || this.isDropCell(lastCell)) && cell == null) {
                DummyCell dummyCell = null;
                if (lastCell instanceof DummyCell) {
                    DummyCell refDummy = (DummyCell)lastCell;
                    dummyCell = new DummyCell(refDummy.getCell());
                    if (lastCell.getRowSpan() > 0) {
                        dummyCell.setRowSpan(lastCell.getRowSpan() - 1);
                    } else {
                        dummyCell.setRowSpan(lastCell.getRowSpan());
                    }
                    dummyCell.setHeight(refDummy.getHeight() - rowHeight);
                } else {
                    dummyCell = new DummyCell(lastCell);
                    if (lastCell.getRowSpan() > 0) {
                        dummyCell.setRowSpan(lastCell.getRowSpan() - 1);
                    } else {
                        dummyCell.setRowSpan(lastCell.getRowSpan());
                    }
                    dummyCell.setHeight(lastCell.getHeight() - lastRow.getArea().getHeight() - rowHeight);
                }
                row.addArea(dummyCell);
                if (dummyCell.getRowSpan() == 1) {
                    CellArea cArea;
                    if (dummyCell.getHeight() < 0 && !dropCells.contains(cArea = dummyCell.getCell())) {
                        cArea.setHeight(cArea.getHeight() - dummyCell.getHeight());
                        this.verticalAlign(cArea);
                        dropCells.add(cArea);
                    }
                } else {
                    this.hasDropCell = true;
                }
                i = i + dummyCell.getColSpan() - 1;
            }
            ++i;
        }
        this.rows.add(row);
    }

    public void skipRow(RowArea area) {
    }

    protected boolean existDropCells() {
        if (this.unresolvedRow != null) {
            int i = 0;
            while (i < this.columnNumber) {
                CellArea cell = this.unresolvedRow.getCell(this.start + i);
                if (cell != null && this.isDropCell(cell)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void updateRow(RowArea rowArea, int specifiedHeight, boolean finished) {
        this.hasDropCell = !finished;
        Row lastRow = this.getPreviousRow();
        if (lastRow == null && this.existDropCells() && !LayoutUtil.isRepeatableRow((IRowContent)rowArea.getContent())) {
            lastRow = this.unresolvedRow;
        }
        Row row = new Row(rowArea, this.start, this.columnNumber, finished);
        int height = specifiedHeight;
        int i = 0;
        while (i < this.columnNumber) {
            CellArea lastCell = null;
            if (lastRow != null) {
                lastCell = lastRow.getCell(this.start + i);
            }
            CellArea cell = row.getCell(this.start + i);
            if (lastCell != null && (lastCell.getRowSpan() > 1 || this.isDropCell(lastCell))) {
                if (cell != null) {
                    row.remove(this.start + i);
                }
                if (lastCell.getRowSpan() == 2) {
                    height = lastCell instanceof DummyCell ? Math.max(height, lastCell.getHeight()) : Math.max(height, lastCell.getHeight() - lastRow.getArea().getHeight());
                }
                i = i + lastCell.getColSpan() - 1;
            } else {
                if (cell != null && cell.getRowSpan() == 1) {
                    height = Math.max(height, cell.getHeight());
                }
                if (cell == null) {
                    CellArea ca;
                    ICellContent cellContent = null;
                    if (this.unresolvedRow != null && (ca = this.unresolvedRow.getCell(i)) != null) {
                        ICellContent cc = (ICellContent)ca.getContent();
                        cellContent = new ClonedCellContent(cc, this.getRowSpan((IRowContent)rowArea.getContent(), ca));
                    }
                    if (cellContent == null) {
                        cellContent = this.tableContent.getReportContent().createCellContent();
                        cellContent.setColumn(i);
                        cellContent.setColSpan(1);
                        cellContent.setRowSpan(1);
                        cellContent.setParent(rowArea.getContent());
                    }
                    int startColumn = cellContent.getColumn();
                    int endColumn = cellContent.getColSpan() + startColumn;
                    CellArea emptyCell = AreaFactory.createCellArea(cellContent);
                    this.resolveBorderConflict(emptyCell, false);
                    IStyle areaStyle = emptyCell.getStyle();
                    areaStyle.setProperty(56, IStyle.NUMBER_0);
                    areaStyle.setProperty(53, IStyle.NUMBER_0);
                    emptyCell.setWidth(this.getCellWidth(startColumn, endColumn));
                    emptyCell.setPosition(this.layoutInfo.getXPosition(i), 0);
                    rowArea.addChild(emptyCell);
                    i = i + emptyCell.getColSpan() - 1;
                }
            }
            ++i;
        }
        if (specifiedHeight == 0 && this.isEmptyRow(row)) {
            height = Math.max(height, this.getHeightOfEmptyRow(row));
        }
        if (height >= 0) {
            Iterator iter = rowArea.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                if (cell.getRowSpan() != 1) continue;
                cell.setHeight(height);
                this.verticalAlign(cell);
            }
            rowArea.setHeight(height);
        }
        if (this.firstRow && this.existDropCells() && !LayoutUtil.isRepeatableRow((IRowContent)rowArea.getContent())) {
            this.mergeDropCell(rowArea);
        }
    }

    private int getHeightOfEmptyRow(Row row) {
        int heightOfEmptyRow = 0;
        int i = 0;
        while (i < this.columnNumber) {
            CellArea cell = row.getCell(this.start + i);
            if (cell != null) {
                IStyle style = cell.getStyle();
                int bottomBorderWidth = PropertyUtil.getDimensionValue(style.getProperty(19));
                int topBorderWidth = PropertyUtil.getDimensionValue(style.getProperty(15));
                int heightOfEmptyCell = topBorderWidth + bottomBorderWidth;
                heightOfEmptyRow = Math.max(heightOfEmptyCell, heightOfEmptyRow);
            }
            ++i;
        }
        return heightOfEmptyRow;
    }

    private boolean isEmptyRow(Row row) {
        int i = 0;
        while (i < this.columnNumber) {
            CellArea cell = row.getCell(this.start + i);
            if (cell != null && !this.isDropCell(cell) && cell.getChildrenCount() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isDropCell(CellArea cell) {
        return cell != null && cell.getRowSpan() < 0;
    }

    protected void mergeDropCell(RowArea row) {
        if (this.unresolvedRow == null) {
            return;
        }
        CellArea[] cells = new CellArea[this.columnNumber];
        Iterator iter = row.getChildren();
        while (iter.hasNext()) {
            CellArea cell = (CellArea)iter.next();
            int colStart = cell.getColumnID();
            int colEnd = colStart + cell.getColSpan();
            int i = colStart;
            while (i < colEnd) {
                int index = colStart - this.start;
                if (index >= 0 && index < this.columnNumber) {
                    cells[colStart - this.start] = cell;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.columnNumber) {
            if (cells[i] == null) {
                ClonedCellContent cellContent = null;
                CellArea ca = this.unresolvedRow.getCell(this.start + i);
                if (ca != null) {
                    ICellContent cc = (ICellContent)ca.getContent();
                    cellContent = new ClonedCellContent(cc, this.getRowSpan((IRowContent)row.getContent(), ca));
                    int startColumn = cellContent.getColumn();
                    int endColumn = cellContent.getColSpan() + startColumn;
                    CellArea emptyCell = AreaFactory.createCellArea(cellContent);
                    emptyCell.setRowSpan(ca.getRowSpan());
                    this.resolveBorderConflict(emptyCell, false);
                    emptyCell.setWidth(this.getCellWidth(startColumn, endColumn));
                    emptyCell.setPosition(this.layoutInfo.getXPosition(i), 0);
                    emptyCell.setHeight(row.getHeight());
                    row.addChild(emptyCell);
                }
            }
            ++i;
        }
    }

    protected int getRowSpan(IRowContent row, CellArea cell) {
        int rowSpan = cell.getRowSpan();
        IContent rowContent = (IContent)cell.getContent().getParent();
        if (rowSpan > 1 && !row.getInstanceID().toUniqueString().equals(rowContent.getInstanceID().toUniqueString())) {
            return rowSpan - 1;
        }
        return rowSpan;
    }

    protected CellArea getReference() {
        return null;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    public Row getLastRow() {
        Row row = (Row)this.rows.getCurrent();
        return row;
    }

    protected Row getPreviousRow() {
        int size = this.rows.size();
        int i = size - 1;
        while (i >= 0) {
            Row row = (Row)this.rows.get(i);
            if (row != null && !row.repeated) {
                return row;
            }
            --i;
        }
        return null;
    }

    public static class Row {
        protected int start;
        protected int length;
        protected int end;
        protected RowArea row;
        protected CellArea[] cells;
        protected boolean finished = true;
        protected boolean repeated = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.cache.TableAreaLayout");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        Row(RowArea row, int start, int length, boolean finished) {
            this(row, start, length);
            this.finished = finished;
        }

        Row(RowArea row, int start, int length, boolean finished, boolean repeated) {
            this(row, start, length, finished);
            this.repeated = repeated;
        }

        Row(RowArea row, int start, int length) {
            this.row = row;
            this.start = start;
            this.end = start + length;
            this.length = length;
            this.cells = new CellArea[length];
            int i = 0;
            while (i < length) {
                Iterator iter = row.getChildren();
                while (iter.hasNext()) {
                    CellArea cell = (CellArea)iter.next();
                    int colId = cell.getColumnID();
                    int colSpan = cell.getColSpan();
                    if (colId < start || colId + colSpan > this.end) continue;
                    int j = 0;
                    while (j < colSpan) {
                        this.cells[colId - start + j] = cell;
                        ++j;
                    }
                }
                ++i;
            }
        }

        public IContent getContent() {
            return this.row.getContent();
        }

        public void remove(int colId) {
            this.row.removeChild(this.getCell(colId));
        }

        public void remove(IArea area) {
            if (area != null) {
                if (!(area instanceof DummyCell)) {
                    this.row.removeChild(area);
                }
                CellArea cell = (CellArea)area;
                int colId = cell.getColumnID();
                int colSpan = cell.getColSpan();
                if (colId >= this.start && colId + colSpan <= this.end) {
                    int j = 0;
                    while (j < colSpan) {
                        this.cells[colId - this.start + j] = null;
                        ++j;
                    }
                }
            }
        }

        public CellArea getCell(int colId) {
            if (colId < this.start || colId >= this.end) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            return this.cells[colId - this.start];
        }

        public void addArea(IArea area) {
            if (!(area instanceof DummyCell)) {
                this.row.addChild(area);
            }
            CellArea cell = (CellArea)area;
            int colId = cell.getColumnID();
            int colSpan = cell.getColSpan();
            if (colId >= this.start && colId + colSpan <= this.end) {
                int j = 0;
                while (j < colSpan) {
                    this.cells[colId - this.start + j] = cell;
                    ++j;
                }
            }
        }

        public RowArea getArea() {
            return this.row;
        }
    }

    private static class UnresolvedRow {
        IContent rowContent;
        protected HashMap map = new HashMap();

        public UnresolvedRow(IContent row) {
            this.rowContent = row;
        }

        public void addUnresolvedCell(ICellContent cell, int rowSpan) {
            int start = cell.getColumn();
            int end = start + cell.getColSpan();
            int i = start;
            while (i < end) {
                this.map.put(new Integer(start), new ClonedCellContent(cell, rowSpan));
                ++i;
            }
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public ICellContent getDropCellContent(int colId, IContent row) {
            ClonedCellContent dropCellContent = (ClonedCellContent)this.map.get(new Integer(colId));
            if (dropCellContent != null) {
                if (row != this.rowContent && dropCellContent.getRowSpan() > 0) {
                    return new ClonedCellContent(dropCellContent.getCellContent(), dropCellContent.rowSpan - 1);
                }
                return new ClonedCellContent(dropCellContent.getCellContent(), dropCellContent.rowSpan);
            }
            return null;
        }
    }
}

