/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.text;

import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.ISplitter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.BidiSplitter;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;

public class ChunkGenerator {
    private ITextContent textContent;
    private ISplitter bidiSplitter = null;
    private ISplitter fontSplitter = null;
    private String format = null;

    public ChunkGenerator(ITextContent textContent, String format) {
        this.textContent = textContent;
        this.bidiSplitter = new BidiSplitter(new Chunk(textContent.getText()));
        this.format = format;
        if (this.bidiSplitter.hasMore()) {
            this.fontSplitter = new FontSplitter(this.bidiSplitter.getNext(), textContent, format);
        }
    }

    public boolean hasMore() {
        if (this.bidiSplitter == null) {
            return false;
        }
        if (this.bidiSplitter.hasMore()) {
            return true;
        }
        if (this.fontSplitter == null) {
            return false;
        }
        return this.fontSplitter.hasMore();
    }

    public Chunk getNext() {
        while (this.fontSplitter != null) {
            if (this.fontSplitter.hasMore()) {
                return this.fontSplitter.getNext();
            }
            this.fontSplitter = null;
            if (this.bidiSplitter.hasMore()) {
                this.fontSplitter = new FontSplitter(this.bidiSplitter.getNext(), this.textContent, this.format);
                continue;
            }
            return null;
        }
        return null;
    }
}

