/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.w3c.dom.css.CSSValue;

public class PropertyUtil {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public static boolean isBoldFont(CSSValue value) {
        return value != null && (IStyle.BOLD_VALUE.equals(value) || IStyle.BOLDER_VALUE.equals(value) || IStyle.NUMBER_600.equals(value) || IStyle.NUMBER_700.equals(value) || IStyle.NUMBER_800.equals(value) || IStyle.NUMBER_900.equals(value));
    }

    public static boolean isInlineElement(IContent content) {
        IStyle style = content.getStyle();
        if (style != null) {
            return IStyle.INLINE_VALUE.equals(style.getProperty(33));
        }
        return false;
    }

    public static int getLineHeight(String lineHeight) {
        block3: {
            try {
                if (!lineHeight.equalsIgnoreCase("normal")) break block3;
                return 0;
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.WARNING, "invalid line height: {0}", lineHeight);
                return 0;
            }
        }
        return (int)Float.parseFloat(lineHeight);
    }

    public static Color getColor(CSSValue value) {
        if (value != null && value instanceof RGBColorValue) {
            RGBColorValue color = (RGBColorValue)value;
            try {
                return new Color(color.getRed().getFloatValue((short)1) / 255.0f, color.getGreen().getFloatValue((short)1) / 255.0f, color.getBlue().getFloatValue((short)1) / 255.0f);
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.WARNING, "invalid color: {0}", value);
            }
        }
        return null;
    }

    public static String getBackgroundImage(CSSValue value) {
        String strValue;
        if (value != null && value instanceof StringValue && (strValue = ((StringValue)value).getStringValue()) != null && !"none".equals(strValue)) {
            return strValue;
        }
        return null;
    }

    public static int getDimensionValue(CSSValue value) {
        return PropertyUtil.getDimensionValue(value, 0);
    }

    public static int getDimensionValue(CSSValue value, int referenceLength) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (int)((double)(v * 72000.0f) / 2.54);
                }
                case 8: {
                    return (int)(v * 72000.0f);
                }
                case 7: {
                    return (int)((double)(v * 7200.0f) / 2.54);
                }
                case 9: {
                    return (int)(v * 1000.0f);
                }
                case 1: {
                    return (int)v;
                }
                case 2: {
                    return (int)((double)((float)referenceLength * v) / 100.0);
                }
            }
        }
        return 0;
    }

    public static float getPercentageValue(CSSValue value) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            if (2 == fv.getPrimitiveType()) {
                return v / 100.0f;
            }
        }
        return 0.0f;
    }
}

