/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.presentation;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.core.template.TemplateParser;
import org.eclipse.birt.core.template.TextTemplate;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.report.engine.api.CachedImage;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.content.ContentVisitorAdapter;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.template.TemplateExecutor;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.extension.internal.RowSet;
import org.eclipse.birt.report.engine.extension.internal.SingleRowSet;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.script.internal.OnRenderScriptVisitor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.w3c.dom.css.CSSValue;

public class LocalizedContentVisitor
extends ContentVisitorAdapter {
    protected static Logger logger;
    private ExecutionContext context;
    private Locale locale;
    private String outputFormat;
    protected HashMap templates = new HashMap();
    private OnRenderScriptVisitor onRenderVisitor;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.presentation.LocalizedContentVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public LocalizedContentVisitor(ExecutionContext context) {
        this.context = context;
        this.locale = context.getLocale();
        this.outputFormat = context.getOutputFormat();
        this.onRenderVisitor = new OnRenderScriptVisitor(context);
    }

    IReportContent getReportContent() {
        return this.context.getReportContent();
    }

    ReportDesignHandle getReportDesign() {
        return this.context.getDesign();
    }

    public IContent localize(IContent content) {
        Object value = content.accept(this, content);
        return (IContent)value;
    }

    protected IContent localizeAllChildren(IContent content) {
        ArrayList children = (ArrayList)content.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                IContent child = (IContent)children.get(i);
                IContent localChild = this.localize(child);
                if (localChild != child) {
                    children.set(i, localChild);
                    localChild.setParent(content);
                    Collection childrenOfLocalChild = localChild.getChildren();
                    Iterator iter = child.getChildren().iterator();
                    while (iter.hasNext()) {
                        IContent childOfChild = (IContent)iter.next();
                        if (childrenOfLocalChild.contains(childOfChild)) continue;
                        childOfChild.setParent(localChild);
                        childrenOfLocalChild.add(childOfChild);
                    }
                }
                this.localizeAllChildren(localChild);
                ++i;
            }
        }
        return content;
    }

    public Object visitPage(IPageContent page, Object value) {
        return page;
    }

    protected TextTemplate parseTemplate(String text) {
        SoftReference<TextTemplate> templateRef = (SoftReference<TextTemplate>)this.templates.get(text);
        TextTemplate template = null;
        if (templateRef != null && (template = (TextTemplate)templateRef.get()) != null) {
            return template;
        }
        try {
            template = new TemplateParser().parse(text);
            templateRef = new SoftReference<TextTemplate>(template);
            this.templates.put(text, templateRef);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return template;
    }

    String executeTemplate(TextTemplate template, HashMap values) {
        return new TemplateExecutor(this.context).execute(template, values);
    }

    public Object visitList(IListContent list, Object value) {
        if (list.getGenerateBy() instanceof ListItemDesign) {
            this.handleOnRender(list);
        }
        return list;
    }

    public Object visitTable(ITableContent table, Object value) {
        this.handleOnRender(table);
        String captionText = table.getCaption();
        String captionKey = table.getCaptionKey();
        captionText = this.localize(table, captionKey, captionText);
        table.setCaption(captionText);
        return table;
    }

    public Object visitRow(IRowContent row, Object value) {
        this.handleOnRender(row);
        return row;
    }

    public Object visitCell(ICellContent cell, Object value) {
        this.handleOnRender(cell);
        return cell;
    }

    public Object visitData(IDataContent data, Object value) {
        this.handleOnRender(data);
        this.processData(data);
        return data;
    }

    protected void processData(IDataContent data) {
        String helpText = this.localize(data, data.getHelpKey(), data.getHelpText());
        data.setHelpText(helpText);
        String text = "";
        if (data.getLabelKey() != null || data.getLabelText() != null) {
            text = this.localize(data, data.getLabelKey(), data.getLabelText());
        } else {
            Object value = data.getValue();
            if (value != null) {
                IStyle style = data.getComputedStyle();
                if (value instanceof Number) {
                    String format = style.getNumberFormat();
                    NumberFormatter fmt = this.context.getNumberFormatter(format);
                    text = fmt.format((Number)value);
                    CSSValue align = style.getProperty(50);
                    if (align != null && align != CSSValueConstants.NONE_VALUE) {
                        data.getStyle().setProperty(26, align);
                    }
                } else if (value instanceof String) {
                    StringFormatter fmt = this.context.getStringFormatter(style.getStringFormat());
                    text = fmt.format((String)value);
                } else if (value instanceof Date) {
                    DateFormatter fmt = this.context.getDateFormatter(style.getDateFormat());
                    text = fmt.format((Date)value);
                } else {
                    text = value.toString();
                }
            }
        }
        if (text != null) {
            data.setText(text);
        } else {
            data.setText("");
        }
    }

    public Object visitLabel(ILabelContent label, Object value) {
        this.handleOnRender(label);
        this.processLabel(label);
        return label;
    }

    protected void processLabel(ILabelContent label) {
        String helpText = this.localize(label, label.getHelpKey(), label.getHelpText());
        label.setHelpText(helpText);
        if (label.getText() == null) {
            String text = this.localize(label, label.getLabelKey(), label.getLabelText());
            label.setText(text);
        }
    }

    public Object visitText(ITextContent text, Object value) {
        this.handleOnRender(text);
        return value;
    }

    public Object visitForeign(IForeignContent foreignContent, Object value) {
        IReportContent reportContent = this.getReportContent();
        String rawFormat = foreignContent.getRawType();
        Object rawValue = foreignContent.getRawValue();
        if ("text/template".equals(rawFormat)) {
            this.handleOnRender(foreignContent);
            this.processTemplateContent(foreignContent);
            return foreignContent;
        }
        if ("object/external".equals(rawFormat)) {
            return this.processExtendedContent(foreignContent);
        }
        if ("binary/image".equals(rawFormat)) {
            if (rawValue instanceof IImageContent) {
                IImageContent image = (IImageContent)rawValue;
                this.processImage(image);
                return image;
            }
            if (rawValue instanceof byte[]) {
                IImageContent imageContent = reportContent.createImageContent(foreignContent);
                imageContent.setImageSource(2);
                imageContent.setData((byte[])rawValue);
                this.processImage(imageContent);
                return imageContent;
            }
        }
        if ("text/plaintext".equals(rawFormat)) {
            this.handleOnRender(foreignContent);
            IDataContent textContent = reportContent.createDataContent(foreignContent);
            textContent.setText(rawValue == null ? "" : rawValue.toString());
            return textContent;
        }
        if ("text/html".equals(rawFormat)) {
            String text;
            this.handleOnRender(foreignContent);
            String key = foreignContent.getRawKey();
            if (key != null && (text = this.localize(foreignContent, key, null)) != null) {
                foreignContent.setRawValue(text);
            }
            return foreignContent;
        }
        if ("binary/value".equals(rawFormat)) {
            this.handleOnRender(foreignContent);
            IDataContent dataContent = reportContent.createDataContent(foreignContent);
            dataContent.setValue(rawValue);
            this.processData(dataContent);
            return dataContent;
        }
        return foreignContent;
    }

    private String localize(IContent content, String key, String text) {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (content.getGenerateBy() != null) {
            String t;
            DesignElementHandle element = ((ReportItemDesign)content.getGenerateBy()).getHandle();
            if (key != null && element != null && (t = ModuleUtil.getExternalizedValue((DesignElementHandle)element, (String)key, (String)text, (ULocale)ULocale.forLocale((Locale)this.locale))) != null) {
                return t;
            }
        }
        return text;
    }

    public Object visitImage(IImageContent image, Object value) {
        this.handleOnRender(image);
        this.processImage(image);
        return image;
    }

    protected void processImage(IImageContent image) {
        String altText = this.localize(image, image.getAltTextKey(), image.getAltText());
        image.setAltText(altText);
        String helpText = this.localize(image, image.getHelpKey(), image.getHelpText());
        image.setHelpText(helpText);
    }

    protected void processTemplateContent(IForeignContent foreignContent) {
        if (!$assertionsDisabled && !"text/template".equals(foreignContent.getRawType())) {
            throw new AssertionError();
        }
        if (foreignContent.getGenerateBy() instanceof TextItemDesign) {
            TextItemDesign design = (TextItemDesign)foreignContent.getGenerateBy();
            String text = null;
            HashMap rawValues = null;
            if (foreignContent.getRawValue() instanceof Object[]) {
                Object[] rawValue = (Object[])foreignContent.getRawValue();
                if (!$assertionsDisabled && rawValue.length != 2) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && rawValue[0] != null && !(rawValue[0] instanceof String)) {
                    throw new AssertionError();
                }
                if (rawValue[0] != null) {
                    text = (String)rawValue[0];
                }
                if (rawValue[1] instanceof HashMap) {
                    rawValues = (HashMap)rawValue[1];
                }
            }
            if (text == null) {
                text = this.localize(foreignContent, design.getTextKey(), design.getText());
            }
            TextTemplate template = this.parseTemplate(text);
            String result = this.executeTemplate(template, rawValues);
            foreignContent.setRawType("text/html");
            foreignContent.setRawValue(result);
        }
    }

    protected String getOutputFormat() {
        return this.outputFormat;
    }

    protected boolean isForPrinting() {
        String outputFormat = this.getOutputFormat();
        return "FO".equalsIgnoreCase(outputFormat) || "PDF".equalsIgnoreCase(outputFormat) || "POSTSCRIPT".equalsIgnoreCase(outputFormat);
    }

    protected IContent processExtendedContent(IForeignContent content) {
        String imageId;
        CachedImage cachedImage;
        IHTMLImageHandler imageHandler;
        if (!$assertionsDisabled && !"object/external".equals(content.getRawType())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(content.getGenerateBy() instanceof ExtendedItemDesign)) {
            throw new AssertionError();
        }
        IContent generatedContent = content;
        ExtendedItemDesign design = (ExtendedItemDesign)content.getGenerateBy();
        ExtendedItemHandle handle = (ExtendedItemHandle)design.getHandle();
        String tagName = handle.getExtensionName();
        if ("Chart".equals(tagName) && (imageHandler = this.context.getImageHandler()) != null && (cachedImage = imageHandler.getCachedImage(imageId = content.getInstanceID().toString(), 4, this.context.getReportContext())) != null) {
            IImageContent imageObj = this.getReportContent().createImageContent(content);
            imageObj.setParent(content.getParent());
            imageObj.setImageSource(0);
            imageObj.setURI(cachedImage.getURL());
            imageObj.setMIMEType(cachedImage.getMIMEType());
            imageObj.setImageMap(cachedImage.getImageMap());
            imageObj.setAltText(content.getAltText());
            imageObj.setAltTextKey(content.getAltTextKey());
            this.processImage(imageObj);
            return imageObj;
        }
        IReportItemPresentation itemPresentation = ExtensionManager.getInstance().createPresentationItem(tagName);
        if (itemPresentation != null) {
            DesignElementHandle elementHandle;
            Object tmp;
            itemPresentation.setModelObject(handle);
            itemPresentation.setApplicationClassLoader(this.context.getApplicationClassLoader());
            itemPresentation.setScriptContext(this.context.getReportContext());
            IBaseQueryDefinition[] queries = (IBaseQueryDefinition[])design.getQueries();
            itemPresentation.setReportQueries(queries);
            itemPresentation.setDynamicStyle(content.getComputedStyle());
            Map appContext = this.context.getAppContext();
            int resolution = 0;
            if (appContext != null && (tmp = appContext.get("CHART_RESOLUTION")) != null && tmp instanceof Number && (resolution = ((Number)tmp).intValue()) < 96) {
                resolution = 96;
            }
            if (resolution == 0) {
                resolution = this.isForPrinting() ? 192 : 96;
            }
            itemPresentation.setResolution(resolution);
            itemPresentation.setLocale(this.locale);
            String supportedImageFormats = "PNG;GIF;JPG;BMP;";
            IRenderOption renderOption = this.context.getRenderOption();
            String formats = renderOption.getSupportedImageFormats();
            if (formats != null) {
                supportedImageFormats = formats;
            }
            itemPresentation.setSupportedImageFormats(supportedImageFormats);
            itemPresentation.setActionHandler(this.context.getActionHandler());
            String outputFormat = this.getOutputFormat();
            itemPresentation.setOutputFormat(outputFormat);
            Object rawValue = content.getRawValue();
            if (rawValue instanceof byte[]) {
                byte[] values = (byte[])rawValue;
                itemPresentation.deserialize(new ByteArrayInputStream(values));
            }
            IRowSet[] rowSets = null;
            IBaseResultSet[] rsets = this.context.getResultSets();
            if (queries == null && (elementHandle = design.getHandle()) instanceof ReportElementHandle) {
                queries = (IBaseQueryDefinition[])this.context.getRunnable().getReportIR().getQueryByReportHandle((ReportElementHandle)elementHandle);
            }
            if (queries != null) {
                if (rsets != null) {
                    rowSets = new IRowSet[rsets.length];
                    int i = 0;
                    while (i < rowSets.length) {
                        rowSets[i] = new RowSet(this.context, (IQueryResultSet)rsets[i]);
                        ++i;
                    }
                }
            } else if (rsets != null) {
                rowSets = new IRowSet[]{new SingleRowSet(this.context, (IQueryResultSet)rsets[0])};
            }
            try {
                Object output = itemPresentation.onRowSets(rowSets);
                if (output != null) {
                    int type = itemPresentation.getOutputType();
                    String imageMIMEType = itemPresentation.getImageMIMEType();
                    generatedContent = this.processExtendedContent(content, type, output, imageMIMEType);
                } else {
                    generatedContent = null;
                }
                itemPresentation.finish();
            }
            catch (BirtException ex) {
                this.context.addException(design.getHandle(), ex);
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return generatedContent;
    }

    protected IContent processExtendedContent(IForeignContent content, int type, Object output, String imageMIMEType) {
        if (!$assertionsDisabled && !"object/external".equals(content.getRawType())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && output == null) {
            throw new AssertionError();
        }
        IReportContent reportContent = this.getReportContent();
        switch (type) {
            case 0: {
                break;
            }
            case 1: 
            case 6: {
                Object imageMap = null;
                byte[] imageContent = new byte[]{};
                Object image = output;
                if (type == 6) {
                    Object[] imageWithMap = (Object[])output;
                    if (imageWithMap.length > 0) {
                        image = imageWithMap[0];
                    }
                    if (imageWithMap.length > 1) {
                        imageMap = imageWithMap[1];
                    }
                }
                if (image instanceof InputStream) {
                    imageContent = LocalizedContentVisitor.readContent((InputStream)image);
                } else if (output instanceof byte[]) {
                    imageContent = (byte[])image;
                } else {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    logger.log(Level.WARNING, "unsupported image type:{0}", output);
                }
                IImageContent imageObj = reportContent.createImageContent(content);
                imageObj.setParent(content.getParent());
                imageObj.setImageSource(2);
                imageObj.setData(imageContent);
                imageObj.setImageMap(imageMap);
                imageObj.setMIMEType(imageMIMEType);
                imageObj.setAltText(content.getAltText());
                imageObj.setAltTextKey(content.getAltTextKey());
                this.processImage(imageObj);
                return imageObj;
            }
            case 5: {
                IDataContent dataObj = reportContent.createDataContent(content);
                dataObj.setValue(output);
                this.processData(dataObj);
                return dataObj;
            }
            case 3: {
                content.setRawType("text/html");
                content.setRawValue(output.toString());
                return content;
            }
            case 2: {
                ITextContent textObj = reportContent.createTextContent();
                textObj.setText(output.toString());
                return textObj;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                logger.log(Level.WARNING, "unsupported output format:{0}", new Integer(type));
            }
        }
        return content;
    }

    protected static byte[] readContent(InputStream in) {
        BufferedInputStream bin = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int readSize = 0;
        try {
            readSize = bin.read(buffer);
            while (readSize != -1) {
                out.write(buffer, 0, readSize);
                readSize = bin.read(buffer);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return out.toByteArray();
    }

    protected void handleOnRender(IContent content) {
        if (content.getGenerateBy() != null) {
            this.onRenderVisitor.onRender(content);
        }
    }
}

