/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IDataItemEventHandler;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.DataItem;
import org.eclipse.birt.report.engine.script.internal.instance.DataItemInstance;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class DataItemScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(DataItemHandle dataItemHandle, ExecutionContext context) {
        try {
            DataItem dataItem = new DataItem(dataItemHandle);
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemHandle, context);
            if (eh != null) {
                eh.onPrepare(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IDataContent content, ExecutionContext context) {
        try {
            ReportItemDesign dataItemDesign = (ReportItemDesign)content.getGenerateBy();
            DataItemInstance dataItem = new DataItemInstance(content, context);
            if (DataItemScriptExecutor.handleJS(dataItem, dataItemDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemDesign, context);
            if (eh != null) {
                eh.onCreate(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IDataContent content, ExecutionContext context) {
        try {
            ReportItemDesign dataItemDesign = (ReportItemDesign)content.getGenerateBy();
            DataItemInstance dataItem = new DataItemInstance(content, context);
            if (DataItemScriptExecutor.handleJS(dataItem, dataItemDesign.getOnRender(), context).didRun()) {
                return;
            }
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemDesign, context);
            if (eh != null) {
                eh.onRender(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IDataContent content, ExecutionContext context) {
        try {
            ReportItemDesign dataItemDesign = (ReportItemDesign)content.getGenerateBy();
            DataItemInstance dataItem = new DataItemInstance(content, context);
            if (DataItemScriptExecutor.handleJS(dataItem, dataItemDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IDataItemEventHandler eh = DataItemScriptExecutor.getEventHandler(dataItemDesign, context);
            if (eh != null) {
                eh.onPageBreak(dataItem, context.getReportContext());
            }
        }
        catch (Exception e) {
            DataItemScriptExecutor.addException(context, e);
        }
    }

    private static IDataItemEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        DataItemHandle handle = (DataItemHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return DataItemScriptExecutor.getEventHandler(handle, context);
    }

    private static IDataItemEventHandler getEventHandler(DataItemHandle handle, ExecutionContext context) {
        IDataItemEventHandler eh = null;
        try {
            eh = (IDataItemEventHandler)DataItemScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IDataItemEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            DataItemScriptExecutor.addClassCastException(context, e, string, clazz);
        }
        return eh;
    }
}

