/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IListGroupEventHandler;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.ListGroup;
import org.eclipse.birt.report.engine.script.internal.instance.ReportElementInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;

public class ListGroupScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(ListGroupHandle groupHandle, ExecutionContext context) {
        try {
            ListGroup group = new ListGroup(groupHandle);
            IListGroupEventHandler eh = ListGroupScriptExecutor.getEventHandler(groupHandle, context);
            if (eh != null) {
                eh.onPrepare(group, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListGroupScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IListGroupContent content, ExecutionContext context) {
        try {
            ReportItemDesign listGroupDesign = (ReportItemDesign)content.getGenerateBy();
            ReportElementInstance list = new ReportElementInstance(content, context);
            if (ListGroupScriptExecutor.handleJS(list, listGroupDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IListGroupEventHandler eh = ListGroupScriptExecutor.getEventHandler(listGroupDesign, context);
            if (eh != null) {
                eh.onPageBreak(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListGroupScriptExecutor.addException(context, e);
        }
    }

    private static IListGroupEventHandler getEventHandler(ListGroupHandle handle, ExecutionContext context) {
        IListGroupEventHandler eh = null;
        try {
            eh = (IListGroupEventHandler)ListGroupScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IListGroupEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ListGroupScriptExecutor.addClassCastException(context, e, string, clazz);
        }
        return eh;
    }

    private static IListGroupEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        ListGroupHandle handle = (ListGroupHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return ListGroupScriptExecutor.getEventHandler(handle, context);
    }
}

