/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IListEventHandler;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.List;
import org.eclipse.birt.report.engine.script.internal.instance.ListInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ListHandle;

public class ListScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(ListHandle listHandle, ExecutionContext context) {
        try {
            List list = new List(listHandle);
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listHandle, context);
            if (eh != null) {
                eh.onPrepare(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IListContent content, ExecutionContext context) {
        try {
            ReportItemDesign listDesign = (ReportItemDesign)content.getGenerateBy();
            ListInstance list = new ListInstance(content, context);
            if (ListScriptExecutor.handleJS(list, listDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listDesign, context);
            if (eh != null) {
                eh.onCreate(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IListContent content, ExecutionContext context) {
        try {
            ReportItemDesign listDesign = (ReportItemDesign)content.getGenerateBy();
            ListInstance list = new ListInstance(content, context);
            if (ListScriptExecutor.handleJS(list, listDesign.getOnRender(), context).didRun()) {
                return;
            }
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listDesign, context);
            if (eh != null) {
                eh.onRender(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IListContent content, ExecutionContext context) {
        try {
            ReportItemDesign listDesign = (ReportItemDesign)content.getGenerateBy();
            ListInstance list = new ListInstance(content, context);
            if (ListScriptExecutor.handleJS(list, listDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IListEventHandler eh = ListScriptExecutor.getEventHandler(listDesign, context);
            if (eh != null) {
                eh.onPageBreak(list, context.getReportContext());
            }
        }
        catch (Exception e) {
            ListScriptExecutor.addException(context, e);
        }
    }

    private static IListEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        ListHandle handle = (ListHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return ListScriptExecutor.getEventHandler(handle, context);
    }

    private static IListEventHandler getEventHandler(ListHandle handle, ExecutionContext context) {
        IListEventHandler eh = null;
        try {
            eh = (IListEventHandler)ListScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IListEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ListScriptExecutor.addClassCastException(context, e, string, clazz);
        }
        return eh;
    }
}

