/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.model.api.DesignElementHandle;

public class ScriptExecutor {
    public static final String PROPERTYSEPARATOR = EngineConstants.PROPERTYSEPARATOR;
    public static final String WEBAPP_CLASSPATH_KEY = "webapplication.projectclasspath";
    public static final String WORKSPACE_CLASSPATH_KEY = "workspace.projectclasspath";
    public static final String PROJECT_CLASSPATH_KEY = "user.projectclasspath";
    protected static Logger log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.script.internal.ScriptExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz.getName());
    }

    protected static JSScriptStatus handleJS(Object scope, String js, ExecutionContext context) {
        return ScriptExecutor.handleJSInternal(scope, js, context);
    }

    private static JSScriptStatus handleJSInternal(Object scope, Object js, ExecutionContext context) {
        if (js != null) {
            if (!(js instanceof String)) {
                return JSScriptStatus.NO_RUN;
            }
            try {
                if (scope != null) {
                    context.newScope(scope);
                }
                Object result = null;
                if (js instanceof String) {
                    result = context.evaluate((String)js);
                }
                JSScriptStatus jSScriptStatus = new JSScriptStatus(true, result);
                Object var4_5 = null;
                if (scope != null) {
                    context.exitScope();
                }
                return jSScriptStatus;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (scope != null) {
                    context.exitScope();
                }
                throw throwable;
            }
        }
        return JSScriptStatus.NO_RUN;
    }

    protected static Object getInstance(DesignElementHandle element, ExecutionContext context) {
        if (element == null) {
            return null;
        }
        String className = element.getEventHandlerClass();
        return ScriptExecutor.getInstance(className, context);
    }

    protected static Object getInstance(String className, ExecutionContext context) {
        Object o;
        block7: {
            if (className == null) {
                return null;
            }
            o = null;
            Class<?> c = null;
            try {
                ClassLoader classLoader = context.getApplicationClassLoader();
                c = classLoader.loadClass(className);
                o = c.newInstance();
            }
            catch (ClassNotFoundException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (context != null) {
                    context.addException(new EngineException("Error.ScriptClassNotFoundError", new Object[]{className}, (Throwable)e));
                }
            }
            catch (IllegalAccessException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (context != null) {
                    context.addException(new EngineException("Error.ScriptClassIllegalAccessError", new Object[]{className}, (Throwable)e));
                }
            }
            catch (InstantiationException e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (context == null) break block7;
                context.addException(new EngineException("Error.ScriptClassInstantiationError", new Object[]{className}, (Throwable)e));
            }
        }
        return o;
    }

    protected static void addClassCastException(ExecutionContext context, ClassCastException e, String className, Class requiredInterface) {
        ScriptExecutor.addException(context, e, "Error.ScriptClassCastError", new Object[]{className, requiredInterface.getName()});
    }

    protected static void addException(ExecutionContext context, Exception e) {
        ScriptExecutor.addException(context, e, "Error.UnhandledScriptError", null);
    }

    private static void addException(ExecutionContext context, Exception e, String errorType, Object[] args) {
        log.log(Level.WARNING, e.getMessage(), e);
        if (context == null) {
            return;
        }
        if (args == null) {
            context.addException(new EngineException(errorType, e));
        } else {
            context.addException(new EngineException(errorType, args, (Throwable)e));
        }
    }

    protected static class JSScriptStatus {
        private boolean didRun;
        private Object result;
        public static final JSScriptStatus NO_RUN = new JSScriptStatus(false, null);

        public JSScriptStatus(boolean didRun, Object result) {
            this.didRun = didRun;
            this.result = result;
        }

        public boolean didRun() {
            return this.didRun;
        }

        public Object result() {
            return this.result;
        }
    }
}

