/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.CompositeStyle;
import org.eclipse.birt.report.engine.css.dom.StyleDeclaration;
import org.eclipse.birt.report.engine.css.engine.BIRTCSSEngine;
import org.eclipse.birt.report.engine.parser.StylePropertyMapping;
import org.eclipse.birt.report.engine.script.internal.instance.StyleInstance;
import org.eclipse.birt.report.engine.toc.TOCTreeNode;
import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TOCHandle;

public class TOCTree
implements ITOCTree {
    private String format;
    private ULocale locale;
    TOCTreeNode root;
    private HashMap tocMapByID;
    private BIRTCSSEngine cssEngine;
    private ReportDesignHandle reportHandle;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.toc.TOCTree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TOCTree() {
    }

    public TOCTree(TOCTreeNode root, String format, ULocale locale, ReportDesignHandle reportHandle) {
        this.root = root;
        this.format = format;
        if ("html".equalsIgnoreCase(this.format)) {
            this.format = "viewer";
        }
        this.locale = locale;
        this.reportHandle = reportHandle;
        this.cssEngine = new BIRTCSSEngine();
    }

    public TOCNode findTOC(String tocNodeId) {
        this.initialize();
        this.initializeLocale();
        if (this.root == null) {
            return null;
        }
        if (this.tocMapByID == null) {
            this.generateIndex();
        }
        TOCTreeNode treeNode = (TOCTreeNode)this.tocMapByID.get(tocNodeId);
        return this.refactNode(treeNode, this.format, this.locale);
    }

    public List findTOCByValue(Object tocValue) {
        if (tocValue == null) {
            return null;
        }
        this.initialize();
        this.initializeLocale();
        if (this.root == null) {
            return null;
        }
        List nodes = this.search(tocValue, this.locale);
        ArrayList<TOCNode> result = new ArrayList<TOCNode>();
        int i = 0;
        while (i < nodes.size()) {
            TOCTreeNode treeNode = (TOCTreeNode)nodes.get(i);
            TOCNode node = this.refactNode(treeNode, this.format, this.locale);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public TOCTreeNode getTOCRoot() {
        this.initialize();
        return this.root;
    }

    public TOCNode getRoot() {
        return this.extractTOCNode(this.root, null, this.format, this.locale);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
        if ("html".equalsIgnoreCase(this.format)) {
            this.format = "viewer";
        }
    }

    public ULocale getLocale() {
        return this.locale;
    }

    public void setLocale(ULocale locale) {
        this.locale = locale;
    }

    void setRoot(TOCTreeNode root) {
        this.root = root;
    }

    protected void initialize() {
        if (this.root == null) {
            this.root = new TOCTreeNode();
        }
    }

    private List search(Object tocValue, ULocale locale) {
        HashSet nodes = new HashSet();
        List keys = this.parse(tocValue, locale);
        this.search(nodes, keys, this.root);
        return Collections.list(Collections.enumeration(nodes));
    }

    private void search(Set result, List keys, TOCTreeNode rootNode) {
        int i = 0;
        while (i < keys.size()) {
            if (this.equals(keys.get(i), rootNode.getTOCValue())) {
                result.add(rootNode);
            }
            ++i;
        }
        List children = rootNode.getChildren();
        int i2 = 0;
        while (i2 < children.size()) {
            this.search(result, keys, (TOCTreeNode)children.get(i2));
            ++i2;
        }
    }

    private boolean equals(Object searchKey, Object key) {
        if (!$assertionsDisabled && searchKey == null) {
            throw new AssertionError();
        }
        if (key == null) {
            return false;
        }
        if (searchKey instanceof String) {
            return searchKey.equals(key.toString());
        }
        if (searchKey instanceof Number && key instanceof Number) {
            BigDecimal decima2;
            BigDecimal searchDecimal = this.toBigDecimal((Number)searchKey);
            return searchDecimal.compareTo(decima2 = this.toBigDecimal((Number)key)) == 0;
        }
        return searchKey.equals(key);
    }

    private BigDecimal toBigDecimal(Number value) {
        BigDecimal decimal = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        decimal = decimal.setScale(20);
        return decimal;
    }

    private TOCNode refactNode(TOCTreeNode node, String format, ULocale locale) {
        if (node == null || node.isHidden(format)) {
            return null;
        }
        if (this.isFirstChildOfDummyGroup(node, format)) {
            TOCTreeNode parent = (TOCTreeNode)node.getParent();
            return this.extractTOCNode(parent, null, format, locale);
        }
        return this.extractTOCNode(node, null, format, locale);
    }

    private boolean isFirstChildOfDummyGroup(TOCTreeNode node, String format) {
        TOCTreeNode parent = (TOCTreeNode)node.getParent();
        if (parent != null && this.shouldRemove(parent)) {
            List children = parent.getChildren();
            int i = 0;
            while (i < children.size()) {
                TOCTreeNode tmpNode = (TOCTreeNode)children.get(i);
                if (tmpNode == node) {
                    return true;
                }
                if (!tmpNode.isHidden(format)) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    private void generateIndex() {
        this.tocMapByID = new HashMap();
        this.generateRootTOCIndex();
    }

    private TOCNode extractTOCNode(TOCTreeNode root, TOCNode parent, String format, ULocale locale) {
        if (root == null) {
            return null;
        }
        if (root.isHidden(format)) {
            return null;
        }
        TOCNode result = null;
        if (!this.shouldRemove(root)) {
            result = new TOCNode(root);
            if (parent != null) {
                result.setParent(parent);
                parent.getChildren().add(result);
            }
            long elementId = root.getElementId();
            if (this.reportHandle != null) {
                IStyle style = this.getStyle(this.reportHandle, elementId, result);
                result.setTOCStyle(new StyleInstance(style));
                result.setDisplayString(this.localizedValue(root.getTOCValue(), style, locale));
            } else {
                result.setDisplayString(this.localizedValue(root.getTOCValue(), null, locale));
            }
        }
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            TOCTreeNode child = (TOCTreeNode)children.get(i);
            if (result == null) {
                result = this.extractTOCNode(child, parent, format, locale);
            } else {
                this.extractTOCNode(child, result, format, locale);
            }
            ++i;
        }
        return result;
    }

    private String localizedValue(Object value, IStyle style, ULocale locale) {
        if (value == null) {
            return null;
        }
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        String displayString = null;
        if (value instanceof Number) {
            NumberFormatter fmt = null;
            fmt = style == null ? new NumberFormatter(locale) : new NumberFormatter(style.getNumberFormat(), locale);
            displayString = fmt.format((Number)value);
        } else if (value instanceof Date) {
            DateFormatter fmt = null;
            fmt = style == null ? new DateFormatter(locale) : new DateFormatter(style.getDateFormat(), locale);
            displayString = fmt.format((Date)value);
        } else if (value instanceof String) {
            StringFormatter fmt = null;
            fmt = style == null ? new StringFormatter(locale) : new StringFormatter(style.getStringFormat(), locale);
            displayString = fmt.format((String)value);
        } else {
            displayString = value.toString();
        }
        return displayString;
    }

    protected IStyle getStyle(ReportDesignHandle reportHandle, long elementId, TOCNode node) {
        String styleName;
        int level = TOCTree.getLevel(node);
        ReportElementHandle handle = (ReportElementHandle)reportHandle.getElementByID(elementId);
        SharedStyleHandle defaultStyleHandle = reportHandle.findStyle("TOC-level-" + level);
        SharedStyleHandle styleHandle = null;
        TOCHandle toc = null;
        if (handle instanceof ReportItemHandle) {
            toc = ((ReportItemHandle)handle).getTOC();
        } else if (handle instanceof GroupHandle) {
            toc = ((GroupHandle)handle).getTOC();
        }
        if (toc != null && (styleName = toc.getStyleName()) != null) {
            styleHandle = reportHandle.findStyle(styleName);
        }
        IStyle defaultStyle = this.createStyle((StyleHandle)defaultStyleHandle, this.cssEngine, true);
        IStyle style = this.createStyle((StyleHandle)styleHandle, this.cssEngine, false);
        IStyle privateStyle = this.createPrivateStyle(toc, this.cssEngine);
        CompositeStyle compositeStyle = new CompositeStyle(new CompositeStyle(defaultStyle, style), privateStyle);
        return compositeStyle;
    }

    protected void addStylePropertyValue(IStyle style, String name, StyleHandle handle, boolean isDefault) {
        this.addStylePropertyValue(style, name, handle, false, isDefault);
    }

    protected void addStylePropertyValue(IStyle style, String name, StyleHandle handle, boolean isColorProperty, boolean isDefault) {
        Object value = null;
        int index = StylePropertyMapping.getPropertyID(name);
        if (StylePropertyMapping.canInherit(name)) {
            if (handle != null) {
                if (isColorProperty) {
                    ColorHandle colorHandle = handle.getColorProperty(name);
                    if (colorHandle != null) {
                        value = colorHandle.getStringValue();
                    }
                } else {
                    value = handle.getProperty(name);
                }
            }
            if (value == null && isDefault) {
                value = StylePropertyMapping.getDefaultValue(name);
            }
            style.setCssText(index, value == null ? null : value.toString());
        } else {
            if (isDefault) {
                value = StylePropertyMapping.getDefaultValue(name);
            }
            style.setCssText(index, value == null ? null : value.toString());
        }
    }

    protected IStyle createPrivateStyle(TOCHandle toc, BIRTCSSEngine cssEngine) {
        StyleDeclaration style = new StyleDeclaration(cssEngine);
        if (toc != null) {
            ColorHandle colorHandle = toc.getBackgroundColor();
            style.setBackgroundColor(colorHandle == null ? null : colorHandle.getStringValue());
            style.setTextAlign(toc.getTextAlign());
            DimensionHandle dimensionHandle = toc.getTextIndent();
            style.setTextIndent(dimensionHandle == null ? null : dimensionHandle.getStringValue());
            style.setTextTransform(toc.getTextTransform());
            FontHandle fontHandle = toc.getFontFamily();
            style.setFontFamily(fontHandle == null ? null : fontHandle.getStringValue());
            colorHandle = toc.getColor();
            style.setColor(colorHandle == null ? null : colorHandle.getStringValue());
            dimensionHandle = toc.getFontSize();
            style.setFontSize(dimensionHandle == null ? null : dimensionHandle.getStringValue());
            style.setFontStyle(toc.getFontStyle());
            style.setFontWeight(toc.getFontWeight());
            style.setFontVariant(toc.getFontVariant());
            style.setTextLineThrough(toc.getTextLineThrough());
            style.setTextOverline(toc.getTextOverline());
            style.setTextUnderline(toc.getTextUnderline());
            colorHandle = toc.getBorderBottomColor();
            style.setBorderBottomColor(colorHandle == null ? null : colorHandle.getStringValue());
            style.setBorderBottomStyle(toc.getBorderBottomStyle());
            dimensionHandle = toc.getBorderBottomWidth();
            style.setBorderBottomWidth(dimensionHandle == null ? null : dimensionHandle.getStringValue());
            colorHandle = toc.getBorderLeftColor();
            style.setBorderLeftColor(colorHandle == null ? null : colorHandle.getStringValue());
            style.setBorderLeftStyle(toc.getBorderLeftStyle());
            dimensionHandle = toc.getBorderLeftWidth();
            style.setBorderLeftWidth(dimensionHandle == null ? null : dimensionHandle.getStringValue());
            colorHandle = toc.getBorderRightColor();
            style.setBorderRightColor(colorHandle == null ? null : colorHandle.getStringValue());
            style.setBorderRightStyle(toc.getBorderRightStyle());
            dimensionHandle = toc.getBorderRightWidth();
            style.setBorderRightWidth(dimensionHandle == null ? null : dimensionHandle.getStringValue());
            colorHandle = toc.getBorderTopColor();
            style.setBorderTopColor(colorHandle == null ? null : colorHandle.getStringValue());
            style.setBorderTopStyle(toc.getBorderTopStyle());
            dimensionHandle = toc.getBorderTopWidth();
            style.setBorderTopWidth(dimensionHandle == null ? null : dimensionHandle.getStringValue());
            style.setCssText(StylePropertyMapping.getPropertyID("stringFormat"), toc.getStringFormat());
            style.setCssText(StylePropertyMapping.getPropertyID("numberFormat"), toc.getNumberFormat());
            style.setCssText(StylePropertyMapping.getPropertyID("dateTimeFormat"), toc.getDateTimeFormat());
        }
        return style;
    }

    protected IStyle createStyle(StyleHandle handle, BIRTCSSEngine cssEngine, boolean isDefault) {
        StyleDeclaration style = new StyleDeclaration(cssEngine);
        if (handle != null) {
            this.addStylePropertyValue(style, "backgroundColor", handle, true, isDefault);
            this.addStylePropertyValue(style, "backgroundImage", handle, isDefault);
            this.addStylePropertyValue(style, "backgroundPositionX", handle, isDefault);
            this.addStylePropertyValue(style, "backgroundPositionY", handle, isDefault);
            this.addStylePropertyValue(style, "backgroundRepeat", handle, isDefault);
            this.addStylePropertyValue(style, "textAlign", handle, isDefault);
            this.addStylePropertyValue(style, "textIndent", handle, isDefault);
            this.addStylePropertyValue(style, "letterSpacing", handle, isDefault);
            this.addStylePropertyValue(style, "lineHeight", handle, isDefault);
            this.addStylePropertyValue(style, "orphans", handle, isDefault);
            this.addStylePropertyValue(style, "textTransform", handle, isDefault);
            this.addStylePropertyValue(style, "verticalAlign", handle, isDefault);
            this.addStylePropertyValue(style, "whiteSpace", handle, isDefault);
            this.addStylePropertyValue(style, "widows", handle, isDefault);
            this.addStylePropertyValue(style, "wordSpacing", handle, isDefault);
            this.addStylePropertyValue(style, "display", handle, isDefault);
            this.addStylePropertyValue(style, "masterPage", handle, isDefault);
            this.addStylePropertyValue(style, "pageBreakAfter", handle, isDefault);
            this.addStylePropertyValue(style, "pageBreakBefore", handle, isDefault);
            this.addStylePropertyValue(style, "pageBreakInside", handle, isDefault);
            this.addStylePropertyValue(style, "fontFamily", handle, isDefault);
            this.addStylePropertyValue(style, "color", handle, true, isDefault);
            this.addStylePropertyValue(style, "fontSize", handle, isDefault);
            this.addStylePropertyValue(style, "fontStyle", handle, isDefault);
            this.addStylePropertyValue(style, "fontWeight", handle, isDefault);
            this.addStylePropertyValue(style, "fontVariant", handle, isDefault);
            this.addStylePropertyValue(style, "textLineThrough", handle, isDefault);
            this.addStylePropertyValue(style, "textOverline", handle, isDefault);
            this.addStylePropertyValue(style, "textUnderline", handle, isDefault);
            this.addStylePropertyValue(style, "borderBottomColor", handle, true, isDefault);
            this.addStylePropertyValue(style, "borderBottomStyle", handle, isDefault);
            this.addStylePropertyValue(style, "borderBottomWidth", handle, isDefault);
            this.addStylePropertyValue(style, "borderLeftColor", handle, true, isDefault);
            this.addStylePropertyValue(style, "borderLeftStyle", handle, isDefault);
            this.addStylePropertyValue(style, "borderLeftWidth", handle, isDefault);
            this.addStylePropertyValue(style, "borderRightColor", handle, true, isDefault);
            this.addStylePropertyValue(style, "borderRightStyle", handle, isDefault);
            this.addStylePropertyValue(style, "borderRightWidth", handle, isDefault);
            this.addStylePropertyValue(style, "borderTopColor", handle, true, isDefault);
            this.addStylePropertyValue(style, "borderTopStyle", handle, isDefault);
            this.addStylePropertyValue(style, "borderTopWidth", handle, isDefault);
            this.addStylePropertyValue(style, "marginTop", handle, isDefault);
            this.addStylePropertyValue(style, "marginLeft", handle, isDefault);
            this.addStylePropertyValue(style, "marginBottom", handle, isDefault);
            this.addStylePropertyValue(style, "marginRight", handle, isDefault);
            this.addStylePropertyValue(style, "paddingTop", handle, isDefault);
            this.addStylePropertyValue(style, "paddingLeft", handle, isDefault);
            this.addStylePropertyValue(style, "paddingBottom", handle, isDefault);
            this.addStylePropertyValue(style, "paddingRight", handle, isDefault);
            this.addStylePropertyValue(style, "stringFormat", handle, isDefault);
            this.addStylePropertyValue(style, "numberFormat", handle, isDefault);
            this.addStylePropertyValue(style, "dateTimeFormat", handle, isDefault);
        }
        return style;
    }

    protected static int getLevel(TOCNode node) {
        TOCNode parent = node.getParent();
        if (parent != null) {
            return TOCTree.getLevel(parent) + 1;
        }
        return -1;
    }

    private void generateRootTOCIndex() {
        this.tocMapByID.put("/", this.root);
        this.generateTOCIndex(this.root);
    }

    private void generateTOCIndex(TOCTreeNode node) {
        this.tocMapByID.put(node.getNodeID(), node);
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            TOCTreeNode child = (TOCTreeNode)iter.next();
            this.generateTOCIndex(child);
        }
    }

    private boolean shouldRemove(TOCTreeNode node) {
        return node.isGroupRoot() && node.isBlank();
    }

    private void initializeLocale() {
        if (this.locale == null) {
            this.locale = ULocale.getDefault();
        }
    }

    private List parse(Object value, ULocale locale) {
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(value);
        if (value instanceof String) {
            String stringValue = (String)value;
            Comparable<BigDecimal> parseValue = null;
            try {
                parseValue = new BigDecimal(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (parseValue != null) {
                result.add(parseValue);
                parseValue = null;
            }
            DateFormatter formatter = new DateFormatter(locale);
            try {
                parseValue = formatter.parse(stringValue);
            }
            catch (ParseException parseException) {}
            if (parseValue != null) {
                result.add(parseValue);
            }
        } else {
            result.add(value.toString());
        }
        return result;
    }
}

