/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.ExcelWriter;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.ExcelLayoutEngine;
import org.eclipse.birt.report.engine.emitter.excel.layout.LayoutUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.PageDef;
import org.eclipse.birt.report.engine.emitter.excel.layout.Rule;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;

public class ExcelEmitter
extends ContentEmitterAdapter {
    protected static Logger logger;
    private IEmitterServices service = null;
    private OutputStream out = null;
    private ExcelLayoutEngine engine;
    ContentEmitterVisitor contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.excel.ExcelEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public void initialize(IEmitterServices service) {
        Object val;
        this.service = service;
        if (service != null) {
            Object fd = this.service.getOption("outputFile");
            File file = null;
            if (fd != null) {
                try {
                    file = new File(fd.toString());
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        if (this.out == null && (val = this.service.getOption("outputStream")) != null && val instanceof OutputStream) {
            this.out = (OutputStream)val;
        }
    }

    public void start(IReportContent report) {
        IStyle style = report.getRoot().getComputedStyle();
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)report.getDesign().getPageSetup().getMasterPage(0);
        this.engine = new ExcelLayoutEngine(new PageDef(master, style));
    }

    public void startPage(IPageContent page) {
        this.contentVisitor.visitChildren(page.getPageHeader(), null);
    }

    public void endPage(IPageContent page) {
        this.contentVisitor.visitChildren(page.getPageFooter(), null);
    }

    public void startTable(ITableContent table) {
        Rule rule = this.engine.getCurrentContainer().getRule();
        int width = rule.getWidth();
        TableInfo info = LayoutUtil.createTable(table, width);
        this.engine.addTable(info, table.getComputedStyle());
    }

    public void startRow(IRowContent row) {
        this.engine.addRow(row.getComputedStyle());
    }

    public void endRow(IRowContent row) {
        this.engine.endRow();
    }

    public void startCell(ICellContent cell) {
        IStyle style = cell.getComputedStyle();
        this.engine.addCell(cell.getColumn(), cell.getColSpan(), style);
    }

    public void endCell(ICellContent cell) {
        this.engine.endCell();
    }

    public void endTable(ITableContent table) {
        this.engine.endTable();
    }

    public void startList(IListContent list) {
        Rule rule = this.engine.getCurrentContainer().getRule();
        this.engine.addTable(LayoutUtil.createTable(1, rule.getWidth()), list.getComputedStyle());
        if (list.getChildren() == null) {
            HyperlinkDef link = this.parseHyperLink((IContent)list);
            this.engine.addData("", list.getComputedStyle(), link);
        }
    }

    public void startListBand(IListBandContent listBand) {
        this.engine.addCell(0, 1, listBand.getComputedStyle());
    }

    public void endListBand(IListBandContent listBand) {
        this.engine.endCell();
    }

    public void endList(IListContent list) {
        this.engine.endTable();
    }

    public void startForeign(IForeignContent foreign) {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content convert = new HTML2Content(foreign.getReportContent().getDesign().getReportDesign());
            convert.html2Content(foreign);
            HyperlinkDef link = this.parseHyperLink((IContent)foreign);
            this.engine.addContainer(foreign.getComputedStyle(), link);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.engine.endContainer();
        }
    }

    public void startText(ITextContent text) {
    }

    public void startData(IDataContent data) {
        super.startData(data);
        HyperlinkDef url = this.parseHyperLink((IContent)data);
        this.engine.addData(data.getText(), data.getComputedStyle(), url);
    }

    public void startLabel(ILabelContent label) {
        Object design = label.getGenerateBy();
        ILabelContent container = label;
        while (design == null) {
            container = (IContent)container.getParent();
            design = container.getGenerateBy();
        }
        HyperlinkDef url = this.parseHyperLink((IContent)label);
        if (!"\n".equalsIgnoreCase(label.getText()) || !(container instanceof IForeignContent)) {
            this.engine.addData(label.getText(), label.getComputedStyle(), url);
        }
    }

    public void startAutoText(IAutoTextContent autoText) {
        HyperlinkDef link = this.parseHyperLink((IContent)autoText);
        this.engine.addData(autoText.getText(), autoText.getComputedStyle(), link);
    }

    public void end(IReportContent report) {
        this.engine.complete();
        ExcelWriter writer = new ExcelWriter(this.out);
        writer.writeDeclarations();
        writer.declareStyles(this.engine.getStyleMap());
        writer.startSheet();
        writer.startTable(this.engine.getCoordinates());
        int count = 0;
        while (count < this.engine.getRowCount()) {
            this.outputData(this.engine.getRow(count), writer);
            ++count;
        }
        writer.endTable();
        writer.closeSheet();
        writer.close(true);
    }

    private void outputData(Data[] row, ExcelWriter writer) {
        writer.startRow();
        int i = 0;
        while (i < row.length) {
            writer.writeTxtData(row[i]);
            ++i;
        }
        writer.endRow();
    }

    private HyperlinkDef parseHyperLink(IContent content) {
        IHyperlinkAction linkaction = content.getHyperlinkAction();
        if (linkaction != null) {
            if (linkaction.getType() == 2) {
                return new HyperlinkDef(linkaction.getBookmark().replaceAll(" ", "_"), 2, null);
            }
            if (linkaction.getType() == 1) {
                return new HyperlinkDef(linkaction.getHyperlink(), 1, null);
            }
            if (linkaction.getType() == 3) {
                Action act = new Action(linkaction);
                IHTMLActionHandler actionHandler = null;
                Object ac = this.service.getOption("actionHandler");
                if (ac != null && ac instanceof IHTMLActionHandler) {
                    actionHandler = (IHTMLActionHandler)ac;
                    actionHandler.getURL((IAction)act, null);
                    return new HyperlinkDef(actionHandler.getURL((IAction)act, this.service.getReportContext()), 3, null);
                }
            }
        } else if (this.getBookMark(content) != null) {
            return this.getBookMark(content);
        }
        return null;
    }

    private HyperlinkDef getBookMark(IContent content) {
        if (content.getBookmark() != null && !content.getBookmark().startsWith("__TOC")) {
            return new HyperlinkDef(null, -1, content.getBookmark());
        }
        if (content.getParent() == null) {
            return null;
        }
        return this.getBookMark((IContent)content.getParent());
    }
}

