/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.HyperlinkDef;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;

public class ExcelWriter {
    private XMLWriterXLS writer = new XMLWriterXLS();
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.excel.ExcelWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ExcelWriter(OutputStream out) {
        this(out, "UTF-8");
    }

    public ExcelWriter(OutputStream out, String encoding) {
        this.writer.open(out, encoding);
    }

    public void writeText(String txt) {
        this.writer.openTag("Data");
        try {
            Integer.parseInt(txt);
            this.writer.attribute("ss:Type", "Number");
        }
        catch (Exception exception) {
            this.writer.attribute("ss:Type", "String");
        }
        this.writer.text(txt);
        this.writer.closeTag("Data");
    }

    public void startRow() {
        this.writer.openTag("Row");
    }

    public void endRow() {
        this.writer.closeTag("Row");
    }

    public void startCell(int cellindex, int colspan, int rowspan, int styleid, HyperlinkDef hyperLink) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", cellindex);
        this.writer.attribute("ss:StyleID", styleid);
        if (hyperLink != null) {
            if (hyperLink.getType() == 2) {
                this.writer.attribute("ss:HRef", "#Sheet1!" + hyperLink.getUrl());
            } else {
                this.writer.attribute("ss:HRef", hyperLink.getUrl());
            }
        }
        this.writer.attribute("ss:MergeAcross", colspan);
        this.writer.attribute("ss:MergeDown", rowspan);
    }

    public void writeDefaultCell(String content) {
        this.writer.openTag("Cell");
        this.writeText(content);
        this.writer.closeTag("Cell");
    }

    protected void writeTxtData(Data d) {
        this.startCell(d.span.getCol(), d.span.getColSpan(), 0, d.styleId, d.url);
        this.writeText(d.txt);
        this.endCell();
    }

    protected void writeFormulaData(Data d) {
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", d.span.getCol());
        this.writer.attribute("ss:Formula", d.txt);
        this.writer.attribute("ss:MergeAcross", d.span.getColSpan());
        this.writer.attribute("ss:StyleID", d.styleId);
        this.writer.closeTag("Cell");
    }

    public void endCell() {
        this.writer.closeTag("Cell");
    }

    public void writeAlignment(String horizontal, String vertical) {
        this.writer.openTag("Alignment");
        this.writer.attribute("ss:Horizontal", horizontal);
        this.writer.attribute("ss:Vertical", vertical);
        this.writer.attribute("ss:WrapText", "1");
        this.writer.closeTag("Alignment");
    }

    public void writeBorder(String position, String lineStyle, String weight, String color) {
        this.writer.openTag("Border");
        this.writer.attribute("ss:Position", position);
        if (this.isValid(lineStyle)) {
            this.writer.attribute("ss:LineStyle", lineStyle);
        }
        if (this.isValid(weight)) {
            this.writer.attribute("ss:Weight", weight);
        }
        if (this.isValid(color)) {
            this.writer.attribute("ss:Color", color);
        }
        this.writer.closeTag("Border");
    }

    public void writeFont(String fontName, String size, String bold, String italic, String strikeThrough, String underline, String color) {
        this.writer.openTag("Font");
        if (this.isValid(fontName)) {
            this.writer.attribute("ss:FontName", fontName);
        }
        this.writer.attribute("ss:Size", size);
        this.writer.attribute("ss:Bold", bold);
        this.writer.attribute("ss:Italic", italic);
        this.writer.attribute("ss:StrikeThrough", strikeThrough);
        if (!"0".equalsIgnoreCase(underline)) {
            this.writer.attribute("ss:Underline", "Single");
        }
        if (this.isValid(color)) {
            this.writer.attribute("ss:Color", color);
        }
        this.writer.closeTag("Font");
    }

    public void writeBackGroudColor(String bgColor) {
        if (this.isValid(bgColor)) {
            this.writer.openTag("Interior");
            this.writer.attribute("ss:Color", bgColor);
            this.writer.attribute("ss:Pattern", "Solid");
            this.writer.closeTag("Interior");
        }
    }

    private boolean isValid(String value) {
        return "NULL" != value;
    }

    private void declareStyle(StyleEntry style, int id) {
        this.writer.openTag("Style");
        this.writer.attribute("ss:ID", id);
        String horizontalAlign = style.getProperty(8);
        String verticalAlign = style.getProperty(9);
        this.writeAlignment(horizontalAlign, verticalAlign);
        this.writer.openTag("Borders");
        String bottomColor = style.getProperty(10);
        String bottomLineStyle = style.getProperty(11);
        String bottomWeight = style.getProperty(12);
        this.writeBorder("Bottom", bottomLineStyle, bottomWeight, bottomColor);
        String topColor = style.getProperty(13);
        String topLineStyle = style.getProperty(14);
        String topWeight = style.getProperty(15);
        this.writeBorder("Top", topLineStyle, topWeight, topColor);
        String leftColor = style.getProperty(16);
        String leftLineStyle = style.getProperty(17);
        String leftWeight = style.getProperty(18);
        this.writeBorder("Left", leftLineStyle, leftWeight, leftColor);
        String rightColor = style.getProperty(19);
        String rightLineStyle = style.getProperty(20);
        String rightWeight = style.getProperty(21);
        this.writeBorder("Right", rightLineStyle, rightWeight, rightColor);
        this.writer.closeTag("Borders");
        String fontName = style.getProperty(0);
        String size = style.getProperty(1);
        String fontStyle = style.getProperty(2);
        String fontWeight = style.getProperty(3);
        String strikeThrough = style.getProperty(4);
        String underline = style.getProperty(5);
        String color = style.getProperty(7);
        this.writeFont(fontName, size, fontWeight, fontStyle, strikeThrough, underline, color);
        String bgColor = style.getProperty(6);
        this.writeBackGroudColor(bgColor);
        this.writer.closeTag("Style");
    }

    public void writeDeclarations() {
        this.writer.startWriter();
        this.writer.getPrint().println();
        this.writer.getPrint().println("<?mso-application progid=\"Excel.Sheet\"?>");
        this.writer.openTag("Workbook");
        this.writer.attribute("xmlns", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:x", "urn:schemas-microsoft-com:office:excel");
        this.writer.attribute("xmlns:ss", "urn:schemas-microsoft-com:office:spreadsheet");
        this.writer.attribute("xmlns:html", "http://www.w3.org/TR/REC-html40");
    }

    public void declareStyles(Map style2id) {
        this.writer.openTag("Styles");
        Iterator it = style2id.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object style = entry.getKey();
            int id = (Integer)entry.getValue();
            this.declareStyle((StyleEntry)style, id);
        }
        this.writer.closeTag("Styles");
    }

    public void close(boolean complete) {
        if (complete) {
            this.writer.closeTag("Workbook");
        }
        this.writer.close();
    }

    public void startSheet(String name) {
        this.writer.openTag("Worksheet");
        this.writer.attribute("ss:Name", name);
    }

    public void startSheet() {
        this.startSheet("Sheet1");
    }

    public void closeSheet() {
        this.writer.closeTag("Worksheet");
    }

    public void startTable(int[] width) {
        this.writer.openTag("ss:Table");
        if (width == null) {
            logger.log(Level.SEVERE, "Invalid columns width");
            throw new IllegalArgumentException("columns width is null");
        }
        int i = 0;
        while (i < width.length) {
            this.writer.openTag("ss:Column");
            this.writer.attribute("ss:Width", width[i]);
            this.writer.closeTag("ss:Column");
            ++i;
        }
    }

    public void endTable() {
        this.writer.closeTag("ss:Table");
    }

    public void insertHorizontalMargin(int height, int span) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", height);
        this.writer.openTag("Cell");
        this.writer.attribute(" ss:MergeAcross", span);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insertVerticalMargin(int start, int end, int length) {
        this.writer.openTag("Row");
        this.writer.attribute("ss:AutoFitHeight", 0);
        this.writer.attribute("ss:Height", 1);
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", start);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.openTag("Cell");
        this.writer.attribute("ss:Index", end);
        this.writer.attribute(" ss:MergeDown", length);
        this.writer.closeTag("Cell");
        this.writer.closeTag("Row");
    }

    public void insert(File file) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                this.writer.literal(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private class XMLWriterXLS
    extends XMLWriter {
        private XMLWriterXLS() {
        }

        public PrintWriter getPrint() {
            return this.printWriter;
        }
    }
}

