/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.DefaultTableInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class LayoutUtil {
    public static int[] getColumnWidth(TableInfo table, int width) {
        int[] col = new int[table.getColumnCount()];
        int tmp = 0;
        int nullNumber = 0;
        int i = 0;
        while (i < table.getColumnCount()) {
            int colwidth = table.getColumnWidth(i);
            if (colwidth == 0) {
                ++nullNumber;
                col[i] = -1;
            } else {
                col[i] = colwidth;
                tmp += col[i];
            }
            ++i;
        }
        if (nullNumber != 0) {
            int aveWidth = (width - tmp) / nullNumber;
            tmp = 0;
            int i2 = 0;
            while (i2 < col.length) {
                if (col[i2] == -1) {
                    col[i2] = aveWidth;
                }
                tmp += col[i2];
                ++i2;
            }
        }
        int n = col.length - 1;
        col[n] = col[n] + (width - tmp);
        return col;
    }

    public static TableInfo createTable(int col, int width) {
        return new DefaultTableInfo(col, width);
    }

    public static TableInfo createTable(ITableContent table, int width) {
        int colcount = table.getColumnCount();
        int[] index = new int[colcount];
        int know = 0;
        ArrayList<Integer> unmount = new ArrayList<Integer>();
        int i = 0;
        while (i < colcount) {
            DimensionType value = table.getColumn(i).getWidth();
            if (value == null) {
                unmount.add(new Integer(i));
            } else {
                index[i] = ExcelUtil.covertDimensionType(value, width);
                know += index[i];
            }
            ++i;
        }
        int left = width - know;
        if (left >= 0 && unmount.size() == 0) {
            return new DefaultTableInfo(index);
        }
        if (left <= 0 && unmount.size() > 0) {
            return new DefaultTableInfo(LayoutUtil.split(width, colcount));
        }
        if (left > 0 && unmount.size() > 0) {
            int[] size = LayoutUtil.split(left, unmount.size());
            Iterator iter = unmount.iterator();
            int i2 = 0;
            while (iter.hasNext()) {
                int pos = (Integer)iter.next();
                index[pos] = size[i2];
                ++i2;
            }
            return new DefaultTableInfo(index);
        }
        System.out.println("impossible in the case");
        return null;
    }

    public static int[] split(int width, int count) {
        int[] size = new int[count];
        int per = width / count;
        int i = 0;
        while (i < count - 1) {
            size[i] = per;
            ++i;
        }
        size[count - 1] = width - per * (count - 1);
        return size;
    }
}

