/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.text.UTF16;

public abstract class UTF32 {
    private static UTF32 beInstance = null;
    private static UTF32 leInstance = null;

    protected abstract void pack(byte[] var1, int var2, int var3);

    protected abstract int unpack(byte[] var1, int var2);

    public byte[] toBytes(String utf16) {
        int codePoints = UTF16.countCodePoint(utf16);
        byte[] bytes = new byte[codePoints * 4];
        int out = 0;
        int cp = 0;
        while (cp < codePoints) {
            int codePoint = UTF16.charAt(utf16, cp);
            this.pack(bytes, codePoint, out);
            cp += UTF16.getCharCount(codePoint);
            out += 4;
        }
        return bytes;
    }

    public String fromBytes(byte[] bytes, int offset, int count) {
        StringBuffer buffer = new StringBuffer();
        int limit = offset + count;
        int cp = offset;
        while (cp < limit) {
            int codePoint = this.unpack(bytes, cp);
            UTF16.append(buffer, codePoint);
            cp += 4;
        }
        return buffer.toString();
    }

    public String fromBytes(byte[] bytes) {
        return this.fromBytes(bytes, 0, bytes.length);
    }

    public static UTF32 getBEInstance() {
        if (beInstance == null) {
            beInstance = new BE();
        }
        return beInstance;
    }

    public static UTF32 getLEInstance() {
        if (leInstance == null) {
            leInstance = new LE();
        }
        return leInstance;
    }

    public static UTF32 getInstance(String encoding) {
        if (encoding.equals("UTF-32BE")) {
            return UTF32.getBEInstance();
        }
        if (encoding.equals("UTF-32LE")) {
            return UTF32.getLEInstance();
        }
        return null;
    }

    static class BE
    extends UTF32 {
        BE() {
        }

        public void pack(byte[] bytes, int codePoint, int out) {
            bytes[out + 0] = (byte)(codePoint >> 24 & 0xFF);
            bytes[out + 1] = (byte)(codePoint >> 16 & 0xFF);
            bytes[out + 2] = (byte)(codePoint >> 8 & 0xFF);
            bytes[out + 3] = (byte)(codePoint >> 0 & 0xFF);
        }

        public int unpack(byte[] bytes, int index) {
            return (bytes[index + 0] & 0xFF) << 24 | (bytes[index + 1] & 0xFF) << 16 | (bytes[index + 2] & 0xFF) << 8 | bytes[index + 3] & 0xFF;
        }
    }

    static class LE
    extends UTF32 {
        LE() {
        }

        public void pack(byte[] bytes, int codePoint, int out) {
            bytes[out + 3] = (byte)(codePoint >> 24 & 0xFF);
            bytes[out + 2] = (byte)(codePoint >> 16 & 0xFF);
            bytes[out + 1] = (byte)(codePoint >> 8 & 0xFF);
            bytes[out + 0] = (byte)(codePoint >> 0 & 0xFF);
        }

        public int unpack(byte[] bytes, int index) {
            return (bytes[index + 3] & 0xFF) << 24 | (bytes[index + 2] & 0xFF) << 16 | (bytes[index + 1] & 0xFF) << 8 | bytes[index + 0] & 0xFF;
        }
    }
}

