/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlUtils;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.IDataSourceService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.registry.util.RegistryBindingUtil;
import org.eclipse.cosmos.dc.common.spi.BindingService;
import org.eclipse.cosmos.dc.common.spi.descriptor.IContextDescriptor;
import org.eclipse.cosmos.dc.common.spi.descriptor.IFilterDescriptor;
import org.eclipse.cosmos.dc.common.spi.descriptor.IQueryDescriptor;
import org.eclipse.cosmos.dc.common.spi.descriptor.IResponseDescriptor;
import org.eclipse.cosmos.dc.common.spi.descriptor.ISinkDescriptor;
import org.eclipse.cosmos.dc.common.spi.descriptor.ISourceDescriptor;
import org.eclipse.cosmos.dc.common.spi.descriptor.ITransformDescriptor;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.sample.components.filter.EchoFilter;
import org.eclipse.cosmos.dc.sample.components.filter.TimeObjectFilter;
import org.eclipse.cosmos.dc.sample.components.query.CBEQuery;
import org.eclipse.cosmos.dc.sample.components.query.StatisticalQuery;
import org.eclipse.cosmos.dc.sample.components.sink.ByteStreamPersistor;
import org.eclipse.cosmos.dc.sample.components.sink.StatisticalPersistor;
import org.eclipse.cosmos.dc.sample.components.sink.TimePersistor;
import org.eclipse.cosmos.dc.sample.components.sink.cbe.CBERDBSink;
import org.eclipse.cosmos.dc.sample.components.source.JMXMetricSource;
import org.eclipse.cosmos.dc.sample.components.source.JMXPollingSource;
import org.eclipse.cosmos.dc.sample.components.source.WefSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleBindingService
implements BindingService {
    static final String SAMPLE_NAMESPACE = "http://www.eclipse.org/xmlns/sample/1.0";
    static QName MAPPINGS_QNAME = new QName("http://www.eclipse.org/xmlns/sample/1.0", "mappings");
    static QName MAPPING_QNAME = new QName("http://www.eclipse.org/xmlns/sample/1.0", "mapping");
    private ContributionManager manager;
    private ProviderRegistry registry;
    private SqlMapClient sqlMapper;
    private static HashMap<String, Class> typeMap;

    public String getNamespace() {
        return SAMPLE_NAMESPACE;
    }

    public IDataCollectionContext bindContext(IContextDescriptor context, Element binding) throws Exception {
        return null;
    }

    public IDataFilterService bindFilter(IFilterDescriptor filter, Element binding) throws Exception {
        System.out.println(filter.getFactoryName());
        if ("org.eclipse.cosmos.dc.sample.components.filter.EchoFilter".equals(filter.getFactoryName())) {
            return (IDataFilterService)this.manager.manage((Object)new EchoFilter(this.manager));
        }
        if ("org.eclipse.cosmos.dc.sample.components.filter.TimeObjectFilter".equals(filter.getFactoryName())) {
            return (IDataFilterService)this.manager.manage((Object)new TimeObjectFilter(this.manager));
        }
        return null;
    }

    public IDataSinkService bindSink(ISinkDescriptor sink, Element binding) throws Exception {
        DimensionSet keyset = RegistryBindingUtil.getDimensionSet((ProviderRegistry)this.registry, (Element)binding);
        HashMap<String, String> keyMap = this.getKeyMap(binding);
        if ("org.eclipse.cosmos.dc.sample.components.sink.ByteStreamPersistor".equals(sink.getFactoryName())) {
            return (IDataSinkService)this.manager.manage((Object)new ByteStreamPersistor(this.manager));
        }
        if ("org.eclipse.cosmos.dc.sample.components.sink.TimePersistor".equals(sink.getFactoryName())) {
            return (IDataSinkService)this.manager.manage((Object)new TimePersistor(this.manager));
        }
        if ("org.eclipse.cosmos.dc.sample.components.sink.StatisticalPersistor".equals(sink.getFactoryName())) {
            return (IDataSinkService)this.manager.manage((Object)new StatisticalPersistor(this.manager, this.sqlMapper, keyset, keyMap));
        }
        if ("org.eclipse.cosmos.dc.sample.components.sink.cbe.CBERDBSink".equals(sink.getFactoryName())) {
            return (IDataSinkService)this.manager.manage((Object)new CBERDBSink(this.manager, this.sqlMapper, keyset, keyMap));
        }
        return null;
    }

    public IDataSourceService bindSource(ISourceDescriptor source, Element binding) throws Exception {
        DataSource ds = RegistryBindingUtil.getDataSource((ProviderRegistry)this.registry, (Element)binding);
        IDataSourceService service = null;
        if ("org.eclipse.cosmos.dc.sample.components.source.WefSource".equals(source.getFactoryName())) {
            service = (IDataSourceService)this.manager.manage((Object)new WefSource(this.manager, binding));
        } else if ("org.eclipse.cosmos.dc.sample.components.source.JMXMetricSource".equals(source.getFactoryName())) {
            service = (IDataSourceService)this.manager.manage((Object)new JMXMetricSource(this.manager, binding));
        } else if ("org.eclipse.cosmos.dc.sample.components.source.JMXPollingSource".equals(source.getFactoryName())) {
            JMXPollingSource src = new JMXPollingSource(this.manager, binding);
            service = (IDataSourceService)this.manager.manage((Object)src);
            src.setDataSource(ds);
        }
        return service;
    }

    public IDataTransformService bindTransform(ITransformDescriptor transform, Element binding) throws Exception {
        return null;
    }

    public void setManager(ContributionManager manager) {
        this.manager = manager;
    }

    public IDataQueryService bindQuery(IQueryDescriptor query, Element binding) throws Exception {
        IDataQueryService service = null;
        if ("org.eclipse.cosmos.dc.sample.components.query.StatisticalQuery".equals(query.getFactoryName())) {
            service = (IDataQueryService)this.manager.manage((Object)new StatisticalQuery(this.manager, this.sqlMapper, this.registry, binding));
        } else if ("org.eclipse.cosmos.dc.sample.components.query.CBEQuery".equals(query.getFactoryName())) {
            service = (IDataQueryService)this.manager.manage((Object)new CBEQuery(this.manager, this.sqlMapper, this.registry, binding));
        }
        return service;
    }

    public IDataResponseService bindResponse(IResponseDescriptor response, Element binding) throws Exception {
        return null;
    }

    public void setRegistry(ProviderRegistry registry) {
        this.registry = registry;
        ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/sample/components/persistence/sql/SqlMapConfig.xml");
                this.sqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
                reader.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(prevLoader);
        }
    }

    private HashMap<String, String> getKeyMap(Element binding) {
        HashMap<String, String> keyMap = null;
        Element mappingsElement = XmlUtils.getElement((Node)binding, (QName)MAPPINGS_QNAME);
        if (mappingsElement != null) {
            Element[] mappings;
            keyMap = new HashMap<String, String>();
            Element[] elementArray = mappings = XmlUtils.getAllElements((Node)mappingsElement, (String)SAMPLE_NAMESPACE, (String)"map");
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                Element mapping = elementArray[n];
                String attribute = mapping.getAttribute("attribute");
                String key = mapping.getAttribute("key");
                keyMap.put(attribute, key);
                ++n;
            }
        }
        return keyMap;
    }
}

