/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.sink;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.dc.common.api.IDataSinkService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractPersistor;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.sample.persistence.impl.StatisticalDatasetImpl;
import org.eclipse.cosmos.dc.sample.persistence.impl.StatisticalObservationImpl;
import org.eclipse.cosmos.dc.spec.types.StatisticalObservation;
import org.eclipse.cosmos.dc.spec.types.StatisticalTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class StatisticalPersistor
extends AbstractPersistor
implements IDataSinkService {
    private static Class[] supportedTypes = new Class[]{StatisticalTuple.class};
    private SqlMapClient sqlMapper;
    private DimensionSet dims;
    private DataSet dataset;
    private HashMap<String, Integer> keyMap = new HashMap();
    private int datasetId;

    public StatisticalPersistor(ContributionManager manager, SqlMapClient sqlMapper, DimensionSet dims, Map<String, String> keyMap) {
        super(manager);
        this.sqlMapper = sqlMapper;
        this.dims = dims;
        int i = 1;
        for (Dimension dim : dims.getDimensions()) {
            this.keyMap.put(dim.getName(), new Integer(i++));
        }
        if (keyMap != null) {
            for (String key : keyMap.keySet()) {
                this.keyMap.put(key, this.keyMap.get(keyMap.get(key)));
            }
        }
    }

    public void store(StatisticalTuple tuple) throws Exception {
        System.out.println("STORE:" + tuple);
        StatisticalObservation[] obvs = tuple.getObservations();
        StatisticalObservationImpl impl = new StatisticalObservationImpl();
        impl.setDataSet(this.datasetId);
        StatisticalObservation[] statisticalObservationArray = obvs;
        int n = 0;
        int n2 = statisticalObservationArray.length;
        while (n < n2) {
            StatisticalObservation obv = statisticalObservationArray[n];
            try {
                impl.resetValues();
                impl.setTimeStamp(tuple.getTimeStamp());
                impl.setKeyEntry(this.keyMap.get(obv.getName()));
                if (obv.isContinuousObservation()) {
                    impl.setContinuousValue(obv.getContinuousValue());
                } else if (obv.isIntegralObservation()) {
                    impl.setIntegralValue(obv.getIntegralValue());
                } else if (obv.isStringObservation()) {
                    impl.setStringValue(obv.getStringValue());
                }
                this.sqlMapper.insert("addObservation", (Object)impl);
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
            ++n;
        }
    }

    protected Class[] getSupportedTypes() {
        return supportedTypes;
    }

    public boolean acceptWireSource(IWireSource target) throws Exception {
        return true;
    }

    public DimensionSet getDimensionSet() {
        return this.dims;
    }

    public void setDataSet(DataSet dataset) {
        try {
            StatisticalDatasetImpl ds = (StatisticalDatasetImpl)this.sqlMapper.queryForObject("getStatisticalDataset", (Object)dataset.getName());
            if (ds == null) {
                ds = new StatisticalDatasetImpl();
                ds.setName(dataset.getName());
                this.datasetId = (Integer)this.sqlMapper.insert("addStatisticalDataset", (Object)ds);
            } else {
                this.datasetId = ds.getId();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dataset = dataset;
    }
}

