/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.sink.cbe;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cosmos.dc.common.api.impl.AbstractPersistor;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.DimensionSet;
import org.eclipse.cosmos.dc.common.spi.IWireSource;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.sample.components.sink.cbe.CBEModelConverter;
import org.eclipse.cosmos.dc.sample.components.sink.cbe.wrapper.CommonBaseEventWrapper;
import org.eclipse.cosmos.dc.sample.components.sink.cbe.wrapper.ComponentIdentificationWrapper;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource
public class CBERDBSink
extends AbstractPersistor {
    private static Class[] supportedTypes = new Class[]{CommonBaseEvent.class};
    private DimensionSet dims;
    private DataSet dataset;
    private HashMap<String, Integer> keyMap = new HashMap();
    private static SqlMapClient CBESqlMapper;
    private SqlMapClient sqlMapper;

    static {
        try {
            Thread.currentThread().setContextClassLoader(CBERDBSink.class.getClassLoader());
            Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/sample/components/sink/cbe/CBESqlMapConfig.xml");
            CBESqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CBERDBSink(ContributionManager manager, SqlMapClient sqlMapper, DimensionSet dims, Map<String, String> keyMap) {
        super(manager);
        this.sqlMapper = sqlMapper;
        this.dims = dims;
        int i = 1;
        for (Dimension dim : dims.getDimensions()) {
            this.keyMap.put(dim.getName(), new Integer(i++));
        }
        if (keyMap != null) {
            for (String key : keyMap.keySet()) {
                this.keyMap.put(key, this.keyMap.get(keyMap.get(key)));
            }
        }
    }

    public boolean acceptWireSource(IWireSource target) throws Exception {
        Class[] types;
        Class[] classArray = types = target.getOutputTypes();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class type = classArray[n];
            if (CommonBaseEvent.class.isAssignableFrom(type)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Class[] getSupportedTypes() {
        return supportedTypes;
    }

    public void store(CommonBaseEvent event) throws Exception {
        org.eclipse.tptp.logging.events.cbe.CommonBaseEvent nonemfcbe = CBEModelConverter.convertCommonBaseEvent(event);
        try {
            Integer sourceComponentId = (Integer)CBESqlMapper.insert("insertComponentIdentification", (Object)new ComponentIdentificationWrapper(nonemfcbe.getSourceComponentId()));
            CommonBaseEventWrapper cbewrapper = new CommonBaseEventWrapper(nonemfcbe);
            cbewrapper.setCreationTimeDouble(nonemfcbe.getCreationTime());
            cbewrapper.setSourceComponentFk(sourceComponentId);
            cbewrapper.setDatasetName(this.dataset.getName());
            CBESqlMapper.insert("insertCBE", (Object)cbewrapper);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DimensionSet getDimensionSet() {
        return this.dims;
    }

    public void setDataSet(DataSet ds) {
        this.dataset = ds;
    }
}

