/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ProcessUnit
extends Component
implements IProcessUnit {
    private Hashtable properties = null;
    protected boolean flushingMode = false;

    public Object[] processEventItems(Object[] msgs) {
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_ProcessUnit_ERROR_");
        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID()});
        event.setSeverity((short)60);
        this.log(event);
        return null;
    }

    public Object[] flushEventItems(Object[] msgs) {
        this.flushingMode = true;
        Object[] temp = this.processEventItems(msgs);
        this.flushingMode = false;
        return temp;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        return null;
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        Element element = this.getConfiguration();
        String propertyName = null;
        String propertyValue = null;
        if (element != null) {
            this.properties = new Hashtable();
            NodeList sensorNodes = element.getChildNodes();
            int i = 0;
            while (i < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item(i).getNodeType() == 1 && (sensorNode = (Element)sensorNodes.item(i)).getTagName().equals("pu:Property")) {
                    Element sensorProperty = sensorNode;
                    if (sensorProperty.hasAttribute("propertyName")) {
                        propertyName = sensorProperty.getAttribute("propertyName");
                    }
                    if (sensorProperty.hasAttribute("propertyValue")) {
                        propertyValue = sensorProperty.getAttribute("propertyValue");
                    }
                    if (propertyName != null && propertyName.length() > 0 && propertyValue != null && propertyValue.length() > 0) {
                        this.properties.put(propertyName, propertyValue);
                    }
                }
                ++i;
            }
        }
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public void setProperties(Hashtable hashtable) {
        Element puNode;
        this.properties = hashtable;
        Element config = this.getConfiguration();
        if (config == null) {
            return;
        }
        NodeList puNodes = config.getChildNodes();
        int i = 0;
        while (i < puNodes.getLength()) {
            if (puNodes.item(i).getNodeType() == 1 && (puNode = (Element)puNodes.item(i)).getTagName().equals("pu:Property")) {
                config.removeChild(puNode);
            }
            ++i;
        }
        if (hashtable != null) {
            Set propertySet = hashtable.entrySet();
            Document doc = config.getOwnerDocument();
            Iterator i2 = propertySet.iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                try {
                    puNode = doc.createElement("pu:Property");
                    puNode.setAttribute("propertyName", (String)entry.getKey());
                    puNode.setAttribute("propertyValue", (String)entry.getValue());
                    config.appendChild(puNode);
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    protected void updateConfigurationPropertyChild(String propName, String propValue) {
        Element config = this.getConfiguration();
        if (config != null) {
            Element puNode;
            NodeList puNodes = config.getChildNodes();
            int i = 0;
            while (i < puNodes.getLength()) {
                if (puNodes.item(i).getNodeType() == 1 && (puNode = (Element)puNodes.item(i)).getTagName().equals("pu:Property") && puNode.getAttribute("propertyName").equals(propName)) {
                    puNode.setAttribute("propertyValue", propValue);
                    return;
                }
                ++i;
            }
            Document doc = config.getOwnerDocument();
            puNode = doc.createElement("pu:Property");
            puNode.setAttribute("propertyName", propName);
            puNode.setAttribute("propertyValue", propValue);
            config.appendChild(puNode);
        }
    }
}

