/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.logging.adapter.ICBEPropertyConstants;
import org.eclipse.hyades.logging.adapter.internal.filters.InvalidAttributeNameException;
import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;

public class CBEComplexHelper
implements ICBEPropertyConstants {
    public static String[] getValuesFromPath(CommonBaseEvent cbe, List path) throws InvalidAttributeNameException {
        if (cbe == null | path == null) {
            return null;
        }
        Iterator i = path.iterator();
        if (path.isEmpty() || !i.next().equals("CommonBaseEvent")) {
            throw new InvalidAttributeNameException();
        }
        if (i.hasNext()) {
            String node = (String)i.next();
            if (node.equals("associatedEvents")) {
                if (!i.hasNext()) {
                    return null;
                }
                String nextNode = (String)i.next();
                EList events = cbe.getAssociatedEvents();
                if (events == null || events.size() == 0) {
                    return null;
                }
                String[] values = new String[events.size()];
                if (nextNode.equals("associationEngine")) {
                    int k = 0;
                    while (k < events.size()) {
                        values[k] = ((AssociatedEvent)events.get(k)).getAssociationEngine();
                        ++k;
                    }
                } else if (nextNode.equals("associationEngineInfo")) {
                    if (!i.hasNext()) {
                        return null;
                    }
                    nextNode = (String)i.next();
                    int k = 0;
                    while (k < events.size()) {
                        AssociationEngine e = ((AssociatedEvent)events.get(k)).getAssociationEngineInfo();
                        if (e != null) {
                            if (nextNode.equals("id")) {
                                values[k] = e.getId();
                            } else if (nextNode.equals("name")) {
                                values[k] = e.getName();
                            } else if (nextNode.equals("type")) {
                                values[k] = e.getType();
                            }
                        }
                        ++k;
                    }
                } else if (nextNode.equals("resolvedEvents")) {
                    int k = 0;
                    while (k < events.size()) {
                        values[k] = ((AssociatedEvent)events.get(k)).getResolvedEvents();
                        ++k;
                    }
                } else {
                    throw new InvalidAttributeNameException();
                }
                return values;
            }
            if (node.equals("contextDataElements")) {
                if (!i.hasNext()) {
                    return null;
                }
                String nextNode = (String)i.next();
                EList events = cbe.getContextDataElements();
                if (events == null || events.size() == 0) {
                    return null;
                }
                String[] values = new String[events.size()];
                if (nextNode.equals("contextId")) {
                    int k = 0;
                    while (k < events.size()) {
                        values[k] = ((ContextDataElement)events.get(k)).getContextId();
                        ++k;
                    }
                } else if (nextNode.equals("name")) {
                    int k = 0;
                    while (k < events.size()) {
                        values[k] = ((ContextDataElement)events.get(k)).getName();
                        ++k;
                    }
                } else if (nextNode.equals("type")) {
                    int k = 0;
                    while (k < events.size()) {
                        values[k] = ((ContextDataElement)events.get(k)).getType();
                        ++k;
                    }
                } else if (nextNode.equals("contextValue")) {
                    int k = 0;
                    while (k < events.size()) {
                        values[k] = ((ContextDataElement)events.get(k)).getContextValue();
                        ++k;
                    }
                } else {
                    throw new InvalidAttributeNameException();
                }
                return values;
            }
            if (node.equals("extendedDataElements")) {
                EList edeList = cbe.getExtendedDataElements();
                if (i.hasNext() && !edeList.isEmpty()) {
                    List subPath = path.subList(path.indexOf(node) + 1, path.size());
                    ArrayList values = new ArrayList();
                    int k = 0;
                    while (k < edeList.size()) {
                        ArrayList newValues = CBEComplexHelper.getExtendedDataValueFromPath((ExtendedDataElement)edeList.get(k), subPath);
                        if (newValues != null) {
                            values.addAll(newValues);
                        }
                        ++k;
                    }
                    if (!values.isEmpty()) {
                        String[] valueStrings = new String[values.size()];
                        int s = 0;
                        while (s < values.size()) {
                            valueStrings[s] = (String)values.get(s);
                            ++s;
                        }
                        return valueStrings;
                    }
                    return null;
                }
                return null;
            }
            if (node.equals("msgDataElement")) {
                String nextNode;
                MsgDataElement mde = cbe.getMsgDataElement();
                if (i.hasNext() && mde != null && (nextNode = (String)i.next()).equals("msgCatalogTokens")) {
                    String[] tokenArray = mde.getMsgCatalogTokensAsStrings();
                    return tokenArray;
                }
                return null;
            }
            if (node.equals("##other")) {
                EList otherData = cbe.getAny();
                if (otherData == null || otherData.isEmpty()) {
                    return null;
                }
                String[] values = new String[otherData.size()];
                int k = 0;
                while (k < otherData.size()) {
                    values[k] = (String)otherData.get(k);
                    ++k;
                }
                return values;
            }
        }
        throw new InvalidAttributeNameException();
    }

    private static ArrayList getExtendedDataValueFromPath(ExtendedDataElement ede, List path) throws InvalidAttributeNameException {
        if (path == null || path.isEmpty()) {
            throw new InvalidAttributeNameException();
        }
        Iterator i = path.iterator();
        if (i.hasNext()) {
            String node = (String)i.next();
            ArrayList<String> v = new ArrayList<String>();
            if (node.equals("name")) {
                v.add(ede.getName());
            } else if (node.equals("type")) {
                if (!v.contains(ede.getType())) {
                    v.add(ede.getType());
                }
            } else if (node.equals("values")) {
                v.addAll((Collection<String>)ede.getValues());
            } else if (node.equals("hexValue")) {
                v.add(ede.getHexValue());
            } else if (node.equals("children")) {
                EList children = ede.getChildren();
                if (i.hasNext()) {
                    List subPath = path.subList(path.indexOf(node) + 1, path.size());
                    int k = 0;
                    while (k < children.size()) {
                        ArrayList childrenValues = CBEComplexHelper.getExtendedDataValueFromPath((ExtendedDataElement)children.get(k), subPath);
                        if (childrenValues != null && !childrenValues.isEmpty()) {
                            v.addAll(childrenValues);
                        }
                        ++k;
                    }
                }
            } else {
                throw new InvalidAttributeNameException();
            }
            if (!v.isEmpty()) {
                return v;
            }
        }
        return null;
    }
}

