/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.filters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.hyades.logging.adapter.internal.filters.NumericalFilterType;

public class TimeFilterType
extends NumericalFilterType {
    private static SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S Z");
    private static SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S");
    private static SimpleDateFormat formatter3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss Z");
    private static SimpleDateFormat formatter4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static Pattern tzPattern = Pattern.compile("(.*)([-,+]\\d{2}:\\d{2})");

    protected boolean equals(String lhs, String rhs) {
        if (lhs == null && rhs == null) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            Date ldt = this.getDate(lhs);
            Date rdt = this.getDate(rhs);
            return ldt.equals(rdt);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    protected boolean greaterThan(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            Date ldt = this.getDate(lhs);
            Date rdt = this.getDate(rhs);
            return ldt.after(rdt);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    protected boolean lessThan(String lhs, String rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        try {
            Date ldt = this.getDate(lhs);
            Date rdt = this.getDate(rhs);
            return ldt.before(rdt);
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private Date getDate(String timestr) throws ParseException {
        Date dt;
        String millis;
        int periodOffset;
        if (timestr.endsWith("Z")) {
            timestr = String.valueOf(timestr.substring(0, timestr.length() - 1)) + " GMT";
        } else {
            Matcher matcher = tzPattern.matcher(timestr);
            if (matcher.find()) {
                timestr = matcher.replaceAll("$1 GMT$2");
            }
        }
        String timestamp = timestr;
        String timezone = null;
        int spaceOffset = timestr.indexOf(32);
        if (spaceOffset != -1) {
            timestamp = timestr.substring(0, spaceOffset);
            timezone = timestr.substring(spaceOffset);
        }
        if ((periodOffset = timestamp.indexOf(46)) != -1 && (millis = timestamp.substring(periodOffset + 1)).length() != 3) {
            if (millis.length() == 1) {
                millis = String.valueOf(millis) + "00";
            } else if (millis.length() == 2) {
                millis = String.valueOf(millis) + "0";
            } else if (millis.length() > 3) {
                millis = millis.substring(0, 3);
            }
            timestr = String.valueOf(timestamp.substring(0, periodOffset + 1)) + millis;
            if (timezone != null) {
                timestr = String.valueOf(timestr) + timezone;
            }
        }
        try {
            dt = formatter1.parse(timestr);
        }
        catch (ParseException parseException) {
            try {
                dt = formatter2.parse(timestr);
            }
            catch (ParseException parseException2) {
                try {
                    dt = formatter3.parse(timestr);
                }
                catch (ParseException parseException3) {
                    dt = formatter4.parse(timestr);
                }
            }
        }
        return dt;
    }
}

