/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.parsers;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IDirectedGraph;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.internal.parsers.DirectedGraphImpl;
import org.eclipse.hyades.logging.adapter.internal.parsers.PositionParser;
import org.eclipse.hyades.logging.adapter.internal.util.ICUTimeParser;
import org.eclipse.hyades.logging.adapter.internal.util.SubstitutionExtensionLoaderUtil;
import org.eclipse.hyades.logging.adapter.internal.util.TimeParser;
import org.eclipse.hyades.logging.adapter.parsers.IStatefulSubstitutionExtension;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.ISubstitutionExtension;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.parsers.StatementException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Element;

public class SubstituteStatement
implements IStatement {
    protected String name;
    protected String positions;
    protected String match;
    protected String substitute;
    protected Pattern pattern;
    protected List positionsList;
    protected boolean processTime;
    protected TimeParser timeParser;
    protected String substitutionExtensionClass;
    protected IStatefulSubstitutionExtension statefulExtension = null;
    protected boolean callout = false;
    protected boolean calloutNewInstance = true;
    protected Class substitutionExtensionClassClass = null;
    protected boolean useBuiltin;
    protected List path;
    protected IDirectedGraph resultGraph;
    private IParser parser;
    private Exception matchException = null;
    private List resultList = new ArrayList(1);
    private static final String KEYWORD_SYMBOL = "@";
    private static final String KEYWORD_TIMEZONE = "@TIMEZONE";
    private static final String KEYWORD_YEAR = "@YEAR";
    private static final String KEYWORD_MONTH = "@MONTH";
    private static final String KEYWORD_DAY = "@DAY";

    public SubstituteStatement(IParser parser) {
        this.parser = parser;
    }

    public void prepare(Element node, String path) throws PreparationException {
        IContext theContext = null;
        IComponent current = this.parser;
        while (current != null) {
            if (current instanceof IContext) {
                theContext = (IContext)current;
                break;
            }
            current = current.getParent();
        }
        this.positions = node.getAttribute("positions");
        this.match = node.getAttribute("match");
        this.substitute = node.getAttribute("substitute");
        this.substitutionExtensionClass = node.getAttribute("substitutionExtensionClass");
        String timeFormat = node.getAttribute("timeFormat");
        String builtin = node.getAttribute("useBuiltInFunction");
        this.useBuiltin = builtin != null && !builtin.equals("") ? builtin.equals("true") : false;
        this.name = path;
        this.path = DirectedGraphImpl.createPath(path);
        if (timeFormat != null && !timeFormat.equals("") && !this.useBuiltin) {
            this.processTime = true;
            Locale locale = null;
            ULocale uLocale = null;
            if (theContext != null) {
                if (theContext instanceof Context && ((Context)theContext).isEnableICU()) {
                    uLocale = ((Context)theContext).getULocale();
                } else {
                    locale = theContext.getLocale();
                }
            } else {
                locale = Locale.getDefault();
            }
            if (this.substitute != null && !this.substitute.equals("") && this.substitute.indexOf(KEYWORD_TIMEZONE) != -1 && ((Context)theContext).getTimezone() == null) {
                this.substitute = this.substitute.replaceFirst(KEYWORD_TIMEZONE, "").trim();
                timeFormat = timeFormat.indexOf("Z") != -1 ? timeFormat.replaceFirst("Z", "").trim() : timeFormat.replaceFirst("z", "").trim();
            }
            try {
                this.timeParser = locale != null ? new TimeParser(timeFormat, locale) : (uLocale != null ? new ICUTimeParser(timeFormat, uLocale) : new TimeParser(timeFormat, Locale.getDefault()));
            }
            catch (AdapterException e) {
                PreparationException details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_Invalid_Time_Format_ERROR_", timeFormat), e);
                details.setDigraph(this.name);
                throw details;
            }
        }
        if (this.substitute != null && !this.substitute.equals("") && this.substitute.indexOf(KEYWORD_SYMBOL) != -1) {
            Context context = null;
            if (theContext instanceof Context) {
                context = (Context)theContext;
            }
            if (context != null && this.substitute.indexOf(KEYWORD_TIMEZONE) != -1) {
                String timezone = context.getTimezone();
                if (timezone == null) {
                    int min;
                    String minStr;
                    GregorianCalendar cal = new GregorianCalendar();
                    int tzOffset = cal.get(15);
                    if ((tzOffset += cal.get(16)) < 0) {
                        timezone = "-";
                        tzOffset = -tzOffset;
                    } else {
                        timezone = "+";
                    }
                    int hours = tzOffset / 3600000;
                    String hrStr = Integer.toString(hours);
                    if (hrStr.length() == 1) {
                        hrStr = "0" + hrStr;
                    }
                    if ((minStr = Integer.toString(min = (tzOffset - hours * 3600000) / 60000)).length() == 1) {
                        minStr = "0" + minStr;
                    }
                    timezone = String.valueOf(timezone) + hrStr + ":" + minStr;
                } else if (timezone.indexOf(58) == -1 && (timeFormat == null || timeFormat.equals(""))) {
                    timezone = String.valueOf(timezone.substring(0, 3)) + ":" + timezone.substring(3);
                }
                this.substitute = this.substitute.replaceAll(KEYWORD_TIMEZONE, timezone);
            }
            if (context != null && this.substitute.indexOf(KEYWORD_YEAR) != -1) {
                this.substitute = this.substitute.replaceAll(KEYWORD_YEAR, Integer.toString(context.getYear()));
            }
            if (context != null && this.substitute.indexOf(KEYWORD_MONTH) != -1) {
                this.substitute = this.substitute.replaceAll(KEYWORD_MONTH, Integer.toString(context.getMonth()));
            }
            if (context != null && this.substitute.indexOf(KEYWORD_DAY) != -1) {
                this.substitute = this.substitute.replaceAll(KEYWORD_DAY, Integer.toString(context.getDay()));
            }
        }
        if (!(this.substitutionExtensionClass == null || this.substitutionExtensionClass.equals("") || this.useBuiltin || this.processTime)) {
            PreparationException details;
            this.callout = true;
            ISubstitutionExtension extension = null;
            try {
                this.substitutionExtensionClassClass = Class.forName(this.substitutionExtensionClass);
            }
            catch (Throwable throwable) {}
            try {
                extension = SubstitutionExtensionLoaderUtil.instantiate(this.substitutionExtensionClassClass, this.substitutionExtensionClass);
            }
            catch (ClassCastException e) {
                details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Run_SubstitutionExtensionClass_Invalid_ERROR_", this.substitutionExtensionClass), e);
                details.setDigraph(this.name);
                throw details;
            }
            catch (ClassNotFoundException e) {
                details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_NotFound_ERROR_", this.substitutionExtensionClass), e);
                details.setDigraph(this.name);
                throw details;
            }
            catch (Exception e) {
                details = new PreparationException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                details.setDigraph(this.name);
                throw details;
            }
            try {
                this.statefulExtension = (IStatefulSubstitutionExtension)extension;
                this.calloutNewInstance = false;
            }
            catch (ClassCastException classCastException) {
                this.calloutNewInstance = true;
            }
        }
        this.resultGraph = null;
        if (this.positions != null && !this.positions.equals("")) {
            this.positionsList = PositionParser.getPositionedString(this.positions, true);
        }
        if (this.match != null && !this.match.equals("")) {
            this.compileMatchString(this.match);
        }
    }

    protected void compileMatchString(String match) throws PreparationException {
        try {
            this.pattern = Pattern.compile(match);
        }
        catch (PatternSyntaxException e) {
            PreparationException details = new PreparationException(Messages.getString("HyadesGAMalformedParserExpression_ERROR_"));
            String detailsString = Messages.getString("HyadesGAPatternSyntaxException_Details", e.getDescription(), e.getPattern());
            if (e.getIndex() >= 0) {
                detailsString = String.valueOf(detailsString) + "  " + Messages.getString("HyadesGAPatternSyntaxException_Index", String.valueOf(e.getIndex()));
            }
            details.setDetails(detailsString);
            details.setDigraph(this.name);
            throw details;
        }
    }

    public List run(String line, HashMap inputs) throws AdapterException, StatementException {
        String tmpLine = line;
        boolean result = false;
        this.resultList.clear();
        if (this.useBuiltin) {
            this.resultGraph = new DirectedGraphImpl(this.path, (Object)"##BUILTIN");
            this.resultList.add(this.resultGraph);
            return this.resultList;
        }
        if (this.positions != null && !this.positions.equals("")) {
            tmpLine = this.positionsToString(line, inputs);
        }
        if (tmpLine != null) {
            String newLine;
            if (this.match != null && !this.match.equals("")) {
                if (this.substitute != null && !this.substitute.equals("")) {
                    this.matchException = null;
                    newLine = this.matchAndSubstitute(tmpLine);
                    if (this.matchException != null) {
                        throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_Match_And_Substitution_Failure_ERROR_", this.substitute, this.match, (String)this.path.get(this.path.size() - 2), this.matchException.getLocalizedMessage()));
                    }
                } else {
                    newLine = null;
                }
                result = newLine != null && newLine.length() > 0;
            } else {
                newLine = this.substitute != null && !this.substitute.equals("") ? this.substitute : tmpLine;
                result = true;
            }
            if (result) {
                if (this.processTime) {
                    String convertedTime = this.timeParser.parse(newLine);
                    if (convertedTime == null || convertedTime.equals("")) {
                        this.resultGraph = null;
                        throw StatementException.instance();
                    }
                    this.resultGraph = new DirectedGraphImpl(this.path, (Object)convertedTime);
                    this.resultList.add(this.resultGraph);
                    return this.resultList;
                }
                if (this.callout) {
                    if (this.calloutNewInstance) {
                        ISubstitutionExtension statelessExtension;
                        try {
                            statelessExtension = this.substitutionExtensionClassClass == null ? SubstitutionExtensionLoaderUtil.instantiate(this.substitutionExtensionClass) : (ISubstitutionExtension)this.substitutionExtensionClassClass.newInstance();
                        }
                        catch (Throwable e) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Preparation_SubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                        }
                        try {
                            if (newLine == line) {
                                newLine = statelessExtension.processRecord(newLine);
                            }
                            newLine = statelessExtension.processMatchResult(newLine);
                        }
                        catch (Exception e) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_StatelessSubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                        }
                    } else {
                        try {
                            newLine = newLine == line ? this.statefulExtension.processRecord(newLine) : this.statefulExtension.processMatchResult(newLine);
                        }
                        catch (Exception e) {
                            throw new AdapterException(Messages.getString("HyadesGA_CBE_Parser_Run_StatefulSubstitutionExtensionClass_Exception_ERROR_", this.substitutionExtensionClass), e);
                        }
                    }
                    if (newLine == null) {
                        this.resultGraph = null;
                        throw StatementException.instance();
                    }
                }
                this.resultGraph = new DirectedGraphImpl(this.path, (Object)newLine);
                this.resultList.add(this.resultGraph);
                return this.resultList;
            }
        }
        this.resultGraph = null;
        throw StatementException.instance();
    }

    protected String matchAndSubstitute(String line) {
        if (this.substitute != null && !this.substitute.equals("")) {
            Matcher matcher;
            block4: {
                try {
                    matcher = this.pattern.matcher(line);
                    if (matcher.find()) break block4;
                    return null;
                }
                catch (Exception e) {
                    this.matchException = e;
                    return null;
                }
            }
            String result = this.pattern.pattern().equals("(.*)") || this.pattern.pattern().equals(".*") ? matcher.replaceFirst(this.substitute) : matcher.replaceAll(this.substitute);
            return result.trim();
        }
        return null;
    }

    protected String positionsToString(String line, HashMap inputs) {
        if (this.positionsList != null && this.positionsList.size() > 0) {
            StringBuffer result = new StringBuffer();
            ListIterator iterator = this.positionsList.listIterator();
            boolean first = true;
            while (iterator.hasNext()) {
                Object current = iterator.next();
                if (first) {
                    first = !first;
                } else {
                    result.append("@@");
                }
                if (current instanceof String) {
                    String val = (String)inputs.get(current);
                    if (val != null && val.length() > 0) {
                        result.append(val);
                        continue;
                    }
                    return null;
                }
                if (!(current instanceof Long)) continue;
                Long item = (Long)current;
                int index = item.intValue() - 1;
                String val = (String)inputs.get(new Long(index));
                if (val != null && val.length() > 0) {
                    result.append(val);
                    continue;
                }
                return null;
            }
            return result.toString();
        }
        return line;
    }

    public IDirectedGraph getResultGraph() {
        return this.resultGraph;
    }

    public IDirectedGraph createResultGraph(Object value) {
        this.resultGraph = new DirectedGraphImpl();
        this.resultGraph.setPath(this.path);
        this.resultGraph.setValue(value);
        return this.resultGraph;
    }

    public boolean isRequiredByParent() {
        return false;
    }

    public boolean isChildChoice() {
        return false;
    }
}

