/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.outputters;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.Outputter;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CBEFileOutputter
extends Outputter
implements IOutputter {
    private String directory = null;
    private String fileName = null;
    protected String rawLogFileName = null;
    protected FileWriter fw = null;

    public Object[] processEventItems(Object[] msgs) {
        if (msgs == null) {
            return null;
        }
        return this.processCBEs((CommonBaseEvent[])msgs);
    }

    protected void writeToFile(String event) throws IOException, AdapterException {
        if (this.fw == null) {
            this.setFileWriter();
        }
        this.fw.write(event);
        this.fw.write("\n");
        this.fw.flush();
    }

    private CommonBaseEvent[] processCBEs(CommonBaseEvent[] events) {
        int cbesReturned = 0;
        if (events != null) {
            int i = 0;
            while (i < events.length) {
                if (events[i] != null) {
                    CommonBaseEvent event;
                    try {
                        String outstr = EventFormatter.toCanonicalXMLString((CommonBaseEvent)events[i], (boolean)false);
                        if (outstr != null) {
                            this.writeToFile(outstr);
                            this.incrementItemsProcessedCount();
                            ++cbesReturned;
                        }
                    }
                    catch (IOException ioe) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, ioe.getMessage()});
                        event.setSeverity((short)60);
                        this.log(event);
                    }
                    catch (NullPointerException npe) {
                        event = this.getEventFactory().createCommonBaseEvent();
                        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Write_ERROR_");
                        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, npe.toString()});
                        event.setSeverity((short)60);
                        this.log(event);
                    }
                    catch (AdapterException adapterException) {
                        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(cbesReturned));
                        return events;
                    }
                }
                ++i;
            }
        }
        this.trace("HyadesGATrace_Component_Processing_End_INFO_", this.getName(), Integer.toString(cbesReturned));
        return events;
    }

    public Object[] testProcessEventItems(Object[] msgs) throws AdapterInvalidConfig {
        if (!(msgs instanceof CommonBaseEvent[])) {
            throw new AdapterInvalidConfig("This outputter will only accept arrays of CommonBaseEvent");
        }
        return this.testProcessCBEs((CommonBaseEvent[])msgs);
    }

    private CommonBaseEvent[] testProcessCBEs(CommonBaseEvent[] events) {
        return events;
    }

    public final String getDirectory() {
        return this.directory;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final void setDirectory(String directory) {
        this.directory = directory;
        this.updateConfigurationPropertyChild("directory", directory);
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateConfigurationPropertyChild("fileName", fileName);
    }

    public void update() throws AdapterInvalidConfig {
        super.update();
        String directory = this.getDirectory();
        String fileName = this.getFileName();
        Element element = this.getConfiguration();
        Element outputterTypeInstance = null;
        Hashtable outputterProperties = this.getProperties();
        if (outputterProperties != null && !outputterProperties.isEmpty()) {
            directory = (String)outputterProperties.get("directory");
            fileName = (String)outputterProperties.get("fileName");
        } else if (element != null) {
            NodeList outputterNodes = element.getChildNodes();
            int i = 0;
            while (i < outputterNodes.getLength()) {
                Element outputterNode;
                if (outputterNodes.item(i).getNodeType() == 1 && (outputterNode = (Element)outputterNodes.item(i)).getTagName().equals("op:SingleFileOutputterType")) {
                    outputterTypeInstance = outputterNode;
                    if (outputterTypeInstance.hasAttribute("directory")) {
                        directory = outputterTypeInstance.getAttribute("directory");
                    }
                    if (outputterTypeInstance.hasAttribute("fileName")) {
                        fileName = outputterTypeInstance.getAttribute("fileName");
                    }
                }
                ++i;
            }
        }
        if (directory == null || directory.length() == 0 || fileName == null || fileName.length() == 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileOutputter_Invalid_Config_File_ERROR_"));
        }
        File dir = new File(directory);
        if (!dir.isDirectory()) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_SingleFileOutputter_Invalid_Config_File_ERROR_"));
        }
        this.setDirectory(directory);
        this.setFileName(fileName);
        boolean validating = false;
        IComponent current = this;
        while (current != null) {
            if (current instanceof IContext) {
                IContext context = (IContext)current;
                if (!(context instanceof Context)) break;
                validating = ((Context)context).isValidating();
                break;
            }
            current = current.getParent();
        }
        if (!validating && !this.isDisabled()) {
            this.prepareFile();
        }
    }

    protected void prepareFile() throws AdapterInvalidConfig {
        String pathSeparator = System.getProperty("file.separator");
        this.rawLogFileName = this.getDirectory().endsWith(pathSeparator) ? String.valueOf(this.getDirectory()) + this.getFileName() : String.valueOf(this.getDirectory()) + pathSeparator + this.getFileName();
        try {
            this.setFileWriter();
        }
        catch (AdapterException ae) {
            throw new AdapterInvalidConfig(ae);
        }
    }

    protected void setFileWriter() throws AdapterException {
        try {
            this.fw = new FileWriter(this.rawLogFileName);
        }
        catch (IOException ioe) {
            CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
            event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_File_Outputter_Create_ERROR_");
            event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID(), this.rawLogFileName, ioe.getMessage()});
            event.setSeverity((short)60);
            this.log(event);
            throw new AdapterException(Messages.getString("HyadesGA_CBE_File_Outputter_Create_ERROR_", this.getUniqueID(), this.rawLogFileName, ioe.getMessage()));
        }
    }

    public void stop() {
        super.stop();
        if (this.fw != null) {
            try {
                this.fw.close();
            }
            catch (IOException iOException) {}
        }
    }
}

