/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.parsers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.IParser;
import org.eclipse.hyades.logging.adapter.parsers.AttributeStatement;
import org.eclipse.hyades.logging.adapter.parsers.IStatement;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.parsers.StatementException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GroupStatement
implements IStatement {
    private List ruleAttributes;
    private String name;
    private IParser parser;
    private boolean isChildChoice = false;
    private boolean isRequiredByParent = false;

    public GroupStatement() {
    }

    public GroupStatement(IParser parser) {
        this.parser = parser;
    }

    public void prepare(Element node, String path) throws PreparationException {
        String isChildChoice;
        this.name = path == null ? node.getAttribute("name") : String.valueOf(path) + "." + node.getAttribute("name");
        String index = node.getAttribute("index");
        if (index != null && !index.equals("")) {
            this.name = String.valueOf(this.name) + "[" + index + "]";
        }
        this.isChildChoice = (isChildChoice = node.getAttribute("isChildChoice")) != null && isChildChoice.equals("true");
        String isRequiredByParent = node.getAttribute("isRequiredByParent");
        this.isRequiredByParent = isRequiredByParent != null && isRequiredByParent.equals("true");
        NodeList children = node.getChildNodes();
        this.ruleAttributes = new ArrayList();
        int i = 0;
        while (i < children.getLength()) {
            block7: {
                IStatement statement;
                Element child = null;
                try {
                    child = (Element)children.item(i);
                }
                catch (ClassCastException classCastException) {
                    break block7;
                }
                if (child.getNodeName().endsWith("RuleElement")) {
                    statement = new GroupStatement(this.parser);
                    statement.prepare(child, this.name);
                    this.ruleAttributes.add(statement);
                } else if (child.getNodeName().endsWith("RuleAttribute")) {
                    statement = new AttributeStatement(this.parser);
                    statement.prepare(child, this.name);
                    this.ruleAttributes.add(statement);
                }
            }
            ++i;
        }
    }

    public List run(String line, HashMap inputs) throws AdapterException, StatementException {
        if (this.ruleAttributes != null) {
            ArrayList list = new ArrayList();
            ListIterator iterator = this.ruleAttributes.listIterator();
            while (iterator.hasNext()) {
                IStatement statement = (IStatement)iterator.next();
                try {
                    list.addAll(statement.run(line, inputs));
                    if (!this.isChildChoice) continue;
                    return list;
                }
                catch (StatementException e) {
                    if (!statement.isRequiredByParent()) continue;
                    throw e;
                }
            }
            if (list.isEmpty()) {
                throw StatementException.instance();
            }
            return list;
        }
        throw StatementException.instance();
    }

    public boolean isRequiredByParent() {
        return this.isRequiredByParent;
    }

    public boolean isChildChoice() {
        return this.isChildChoice;
    }
}

