/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import org.eclipse.hyades.logging.adapter.util.AdapterMigrationException;
import org.eclipse.hyades.logging.adapter.util.IComponentMigrator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SensorMigrator
implements IComponentMigrator {
    public Element migrate(Element oldSensorConfiguration) throws AdapterMigrationException {
        boolean migrated = false;
        Element newSensorConfiguration = null;
        try {
            Document doc = oldSensorConfiguration.getOwnerDocument();
            newSensorConfiguration = (Element)oldSensorConfiguration.cloneNode(false);
            if (newSensorConfiguration.hasAttribute("type")) {
                newSensorConfiguration.removeAttribute("type");
                migrated = true;
            }
            NodeList sensorNodes = oldSensorConfiguration.getChildNodes();
            int k = 0;
            while (k < sensorNodes.getLength()) {
                Element sensorNode;
                if (sensorNodes.item(k).getNodeType() == 1 && ((sensorNode = (Element)sensorNodes.item(k)).getTagName().equals("sensor:StaticParserSensor") || sensorNode.getTagName().equals("sensor:SingleFileSensor"))) {
                    Element sensorProperty;
                    String propertyValue;
                    String propertyName;
                    NamedNodeMap sensorTypeAttributeList = sensorNode.getAttributes();
                    int sensorTypeAttributeCount = sensorTypeAttributeList.getLength();
                    int j = 0;
                    while (j < sensorTypeAttributeCount) {
                        Node sensorTypeAttribute = sensorTypeAttributeList.item(j);
                        propertyName = sensorTypeAttribute.getNodeName();
                        propertyValue = sensorTypeAttribute.getNodeValue();
                        sensorProperty = doc.createElement("pu:Property");
                        sensorProperty.setAttribute("propertyValue", propertyValue);
                        sensorProperty.setAttribute("propertyName", propertyName);
                        newSensorConfiguration.appendChild(sensorProperty);
                        ++j;
                    }
                    NodeList sensorPropertyList = sensorNode.getElementsByTagName("sensor:SensorProperty");
                    int sensorPropertyCount = sensorPropertyList.getLength();
                    int j2 = 0;
                    while (j2 < sensorPropertyCount) {
                        Element oldSensorProperty = (Element)sensorPropertyList.item(j2);
                        sensorProperty = doc.createElement("pu:Property");
                        propertyName = oldSensorProperty.getAttribute("propertyName");
                        propertyValue = oldSensorProperty.getAttribute("propertyValue");
                        sensorProperty.setAttribute("propertyValue", propertyValue);
                        sensorProperty.setAttribute("propertyName", propertyName);
                        newSensorConfiguration.appendChild(sensorProperty);
                        ++j2;
                    }
                    if (sensorTypeAttributeCount > 0 || sensorPropertyCount > 0) {
                        migrated = true;
                    }
                }
                ++k;
            }
        }
        catch (Exception e) {
            throw new AdapterMigrationException("bad error", e);
        }
        if (!migrated) {
            newSensorConfiguration = null;
        }
        return newSensorConfiguration;
    }
}

