/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.mini.internal;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.mini.internal.OSGiMinServlet;
import org.apache.muse.osgi.soa.core.web.ServletDescriptor;
import org.apache.muse.osgi.soa.core.web.WebApp;
import org.apache.muse.osgi.soa.core.web.WebAppDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ResourceManagementAdminServiceImpl
implements ResourceManagementProvider {
    public static final String DEFAULT_CONTEXT = "management";
    private BundleContext context;
    private Bundle bundle;
    private ServiceReference provider;
    private Map contextToWebAppMap = new HashMap();

    public void intializeContext(Bundle bundle, String contextPath) throws Exception {
        WebApp webApp = null;
        if (contextPath != null) {
            webApp = this.getWebApp(bundle, contextPath, true);
        }
    }

    public ResourceManagementAdminServiceImpl(BundleContext context, ServiceReference provider) {
        this.context = context;
        this.provider = provider;
    }

    public void deployManagementService(Bundle bundle, String homeName, String wsdlPath) throws Exception {
        this.deployManagementService(bundle, DEFAULT_CONTEXT, homeName);
    }

    private WebAppDescriptor getWebAppDescriptor(String context, boolean requiresHttps) {
        WebAppDescriptor wad = new WebAppDescriptor();
        OSGiMinServlet servlet = new OSGiMinServlet();
        wad.servlet = new ServletDescriptor[1];
        wad.context = context.startsWith("/") ? context : "/" + context;
        wad.servlet[0] = new ServletDescriptor("/services", (HttpServlet)servlet);
        return wad;
    }

    private WebApp getWebApp(Bundle bundle, String contextPath, boolean create) {
        WebApp webApp = (WebApp)this.contextToWebAppMap.get(contextPath);
        if (webApp == null && create) {
            try {
                String secureString = (String)bundle.getHeaders().get("SOA-HTTPS-REQUIRED");
                boolean requiresHttps = false;
                if ("true".equals(secureString)) {
                    requiresHttps = true;
                }
                webApp = new WebApp(this.getWebAppDescriptor(contextPath, requiresHttps));
                webApp.start(this.context);
                this.contextToWebAppMap.put(contextPath, webApp);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return webApp;
    }

    private WebApp getWebApp(String contextPath, boolean create) {
        return this.getWebApp(this.context.getBundle(), contextPath, create);
    }

    public void deployManagementService(Bundle bundle, String contextPath, String srvName, String wsdlPath) throws Exception {
        WebApp webApp = null;
        if (contextPath != null) {
            try {
                webApp = this.getWebApp(bundle, contextPath, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

