/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.muse.core.Environment;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.MessageHeaders;
import org.apache.muse.ws.addressing.soap.SimpleSoapClient;
import org.apache.muse.ws.addressing.soap.SoapClient;
import org.w3c.dom.Document;

public abstract class AbstractEnvironment
implements Environment {
    private static final String FILE_SCHEME = "file";
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$AbstractEnvironment == null ? (class$org$apache$muse$core$AbstractEnvironment = AbstractEnvironment.class$("org.apache.muse.core.AbstractEnvironment")) : class$org$apache$muse$core$AbstractEnvironment);
    private ClassLoader _classLoader = null;
    private Map _contextByThread = new HashMap();
    private String _defaultURI = null;
    private SoapClient _soapClient = null;
    static /* synthetic */ Class class$org$apache$muse$core$AbstractEnvironment;

    public AbstractEnvironment() {
        this(true);
    }

    public AbstractEnvironment(boolean createSoapClient) {
        this.initialize(this.getClass().getClassLoader(), createSoapClient);
    }

    public AbstractEnvironment(ClassLoader classLoader) {
        this(classLoader, true);
    }

    public AbstractEnvironment(ClassLoader classLoader, boolean createSoapClient) {
        this.initialize(classLoader, createSoapClient);
    }

    public synchronized void addAddressingContext(MessageHeaders context) {
        this._contextByThread.put(Thread.currentThread(), context);
    }

    public String createRelativePath(String originalPath, String relativePath) {
        URI original = URI.create(originalPath);
        if (this.isAbsolute(relativePath)) {
            return relativePath;
        }
        return original.resolve(relativePath).toString();
    }

    private boolean isAbsolute(String path) {
        File file;
        URI uri = URI.create(path);
        if (uri.isAbsolute()) {
            return true;
        }
        return (uri.getScheme() == null || uri.getScheme().equals(FILE_SCHEME)) && (file = new File(uri.getPath())).isAbsolute();
    }

    protected SoapClient createSoapClient() {
        return new SimpleSoapClient();
    }

    public synchronized MessageHeaders getAddressingContext() {
        return (MessageHeaders)this._contextByThread.get(Thread.currentThread());
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public URL getDataResource(String path) {
        URL url = this.getClassLoader().getResource(path);
        if (url == null) {
            Object[] filler = new Object[]{path};
            throw new RuntimeException(_MESSAGES.get("NoDataResource", filler));
        }
        return url;
    }

    public InputStream getDataResourceStream(String path) {
        InputStream stream = this.getClassLoader().getResourceAsStream(path);
        if (stream == null) {
            Object[] filler = new Object[]{path};
            throw new RuntimeException(_MESSAGES.get("NoDataResource", filler));
        }
        return stream;
    }

    protected EndpointReference getDefaultEPR() {
        String defaultURI = this.getDefaultURI();
        if (defaultURI == null) {
            throw new IllegalStateException(_MESSAGES.get("NoDefaultURI"));
        }
        return new EndpointReference(URI.create(defaultURI));
    }

    public String getDefaultURI() {
        return this._defaultURI;
    }

    protected String getDeploymentURI(String uriString) {
        URI uri = URI.create(uriString);
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        try {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), ip, uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        return uri.toString();
    }

    public Document getDocument(String path) {
        InputStream stream = this.getDataResourceStream(path);
        try {
            return XmlUtils.createDocument(stream);
        }
        catch (Exception error) {
            Object[] filler = new Object[]{path, error.getMessage()};
            throw new RuntimeException(_MESSAGES.get("CreateDocFailed", filler));
        }
    }

    public SoapClient getSoapClient() {
        return this._soapClient;
    }

    private void initialize(ClassLoader classLoader, boolean createSoapClient) {
        if (classLoader == null) {
            throw new NullPointerException(_MESSAGES.get("NullClassLoader"));
        }
        this._classLoader = classLoader;
        if (createSoapClient) {
            this._soapClient = this.createSoapClient();
        }
    }

    public synchronized void removeAddressingContext() {
        this._contextByThread.remove(Thread.currentThread());
    }

    public void setDefaultURI(String defaultURI) {
        this._defaultURI = defaultURI;
    }

    public void setSoapClient(SoapClient soapClient) {
        if (soapClient == null) {
            throw new NullPointerException(_MESSAGES.get("NullSoapClient"));
        }
        this._soapClient = soapClient;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ File getRealDirectory();

    public abstract /* synthetic */ EndpointReference getDeploymentEPR();
}

