/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.util.Map;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.CapabilityDefinition;
import org.apache.muse.core.descriptor.CapabilityDescriptor;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.InitParamDescriptor;
import org.apache.muse.core.descriptor.PersistenceDefinition;
import org.apache.muse.core.descriptor.PersistenceDescriptor;
import org.apache.muse.core.descriptor.SimpleInitParamDescriptor;
import org.apache.muse.core.descriptor.SimplePersistenceDescriptor;
import org.apache.muse.util.ReflectUtils;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleCapabilityDescriptor
implements CapabilityDescriptor {
    private CapabilityDefinition _definition = null;

    protected Class createImplementationClass(Element xml, Environment env) {
        String className = XmlUtils.getElementText(xml, DescriptorConstants.JAVA_CAPABILITY_QNAME);
        if (className == null) {
            return null;
        }
        return ReflectUtils.getClass(className, env.getClassLoader());
    }

    protected InitParamDescriptor createInitParamDescriptor() {
        return new SimpleInitParamDescriptor();
    }

    protected PersistenceDefinition createPersistence(Element xml, Environment env) throws SoapFault {
        Element persistenceXML = XmlUtils.getElement(xml, DescriptorConstants.PERSISTENCE_QNAME);
        if (persistenceXML == null) {
            return null;
        }
        PersistenceDescriptor desc = this.createPersistenceDescriptor();
        desc.load(persistenceXML, env);
        return desc.getPersistenceDefinition();
    }

    protected PersistenceDescriptor createPersistenceDescriptor() {
        return new SimplePersistenceDescriptor();
    }

    protected String createURI(Element xml) {
        return XmlUtils.getElementText(xml, DescriptorConstants.CAPABILITY_URI_QNAME);
    }

    public CapabilityDefinition getCapabilityDefinition() {
        return this._definition;
    }

    public void load(Element xml, Environment environment) throws SoapFault {
        String uri = this.createURI(xml);
        Class implClass = this.createImplementationClass(xml, environment);
        PersistenceDefinition persistence = this.createPersistence(xml, environment);
        InitParamDescriptor paramDesc = this.createInitParamDescriptor();
        paramDesc.load(xml);
        Map parameters = paramDesc.getInitializationParameters();
        this._definition = new CapabilityDefinition();
        this._definition.setURI(uri);
        this._definition.setImplementationClass(implClass);
        this._definition.setPersistenceDefinition(persistence);
        this._definition.setInitializationParameters(parameters);
    }

    public void setCapabilityDefinition(CapabilityDefinition definition) {
        this._definition = definition;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Map parameters;
        CapabilityDefinition def = this.getCapabilityDefinition();
        Element root = XmlUtils.createElement(doc, DescriptorConstants.CAPABILITY_QNAME);
        XmlUtils.setElement(root, DescriptorConstants.CAPABILITY_URI_QNAME, def.getURI());
        XmlUtils.setElement(root, DescriptorConstants.JAVA_CAPABILITY_QNAME, def.getImplementationClass().getName());
        PersistenceDefinition persistence = def.getPersistenceDefinition();
        if (persistence != null) {
            PersistenceDescriptor pd = this.createPersistenceDescriptor();
            pd.setPersistenceDefinition(persistence);
            Element persistenceXML = pd.toXML(doc);
            root.appendChild(persistenceXML);
        }
        if ((parameters = def.getInitializationParameters()) != null) {
            InitParamDescriptor id = this.createInitParamDescriptor();
            id.setInitializationParameters(parameters);
            Element initParamXML = id.toXML(doc);
            XmlUtils.moveSubTree(initParamXML, root);
        }
        return root;
    }
}

