/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.muse.core.Environment;
import org.apache.muse.core.descriptor.DeploymentDescriptor;
import org.apache.muse.core.descriptor.DescriptorConstants;
import org.apache.muse.core.descriptor.ResourceDefinition;
import org.apache.muse.core.descriptor.ResourceDescriptor;
import org.apache.muse.core.descriptor.RouterDefinition;
import org.apache.muse.core.descriptor.RouterDescriptor;
import org.apache.muse.core.descriptor.SerializerDefinition;
import org.apache.muse.core.descriptor.SerializerDescriptor;
import org.apache.muse.core.descriptor.SimpleResourceDescriptor;
import org.apache.muse.core.descriptor.SimpleRouterDescriptor;
import org.apache.muse.core.descriptor.SimpleSerializerDescriptor;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleDeploymentDescriptor
implements DeploymentDescriptor {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor == null ? (class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor = SimpleDeploymentDescriptor.class$("org.apache.muse.core.descriptor.SimpleDeploymentDescriptor")) : class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor);
    private Collection _resourceDefinitions = Collections.EMPTY_LIST;
    private RouterDefinition _routerDefinition = null;
    private Collection _serializerDefinitions = Collections.EMPTY_LIST;
    static /* synthetic */ Class class$org$apache$muse$core$descriptor$SimpleDeploymentDescriptor;

    protected Collection createResourceDefinitions(Element xml, Environment env) throws SoapFault {
        Element[] resourceXML = XmlUtils.getElements(xml, DescriptorConstants.RESOURCE_TYPE_QNAME);
        ArrayList<ResourceDefinition> definitions = new ArrayList<ResourceDefinition>(resourceXML.length);
        for (int n = 0; n < resourceXML.length; ++n) {
            ResourceDescriptor rd = this.createResourceDescriptor();
            rd.load(resourceXML[n], env);
            ResourceDefinition definition = rd.getResourceDefinition();
            definitions.add(definition);
        }
        return definitions;
    }

    protected ResourceDescriptor createResourceDescriptor() {
        return new SimpleResourceDescriptor();
    }

    protected RouterDefinition createRouterDefinition(Element xml, Environment env) throws SoapFault {
        Element routerXML = XmlUtils.getElement(xml, DescriptorConstants.ROUTER_QNAME);
        RouterDescriptor rd = this.createRouterDescriptor();
        rd.load(routerXML, env);
        return rd.getRouterDefinition();
    }

    protected RouterDescriptor createRouterDescriptor() {
        return new SimpleRouterDescriptor();
    }

    public Collection createSerializerDefinitions(Element xml, Environment env) throws SoapFault {
        QName qname = DescriptorConstants.CUSTOM_SERIALIZER_QNAME;
        Element[] serializerXML = XmlUtils.getElements(xml, qname);
        ArrayList<SerializerDefinition> definitions = new ArrayList<SerializerDefinition>(serializerXML.length);
        for (int n = 0; n < serializerXML.length; ++n) {
            SerializerDescriptor sd = this.createSerializerDescriptor();
            sd.load(serializerXML[n], env);
            SerializerDefinition definition = sd.getSerializerDefinition();
            definitions.add(definition);
        }
        return definitions;
    }

    protected SerializerDescriptor createSerializerDescriptor() {
        return new SimpleSerializerDescriptor();
    }

    public Collection getResourceDefinitions() {
        return this._resourceDefinitions;
    }

    public RouterDefinition getRouterDefinition() {
        return this._routerDefinition;
    }

    public Collection getSerializerDefinitions() {
        return this._serializerDefinitions;
    }

    public void load(Document xml, Environment environment) throws SoapFault {
        Element root = XmlUtils.getFirstElement(xml);
        QName rootName = XmlUtils.getElementQName(root);
        if (!rootName.equals(DescriptorConstants.MUSE_QNAME)) {
            Object[] filler = new Object[]{DescriptorConstants.MUSE_QNAME, rootName};
            throw new RuntimeException(_MESSAGES.get("InvalidDescriptorRoot", filler));
        }
        this._serializerDefinitions = this.createSerializerDefinitions(root, environment);
        this._routerDefinition = this.createRouterDefinition(root, environment);
        this._resourceDefinitions = this.createResourceDefinitions(root, environment);
        this._routerDefinition.setResourceDefinitions(this._resourceDefinitions);
    }

    public void setResourceDefinitions(Collection definitions) {
        this._resourceDefinitions = definitions;
    }

    public void setRouterDefinition(RouterDefinition definition) {
        this._routerDefinition = definition;
    }

    public void setSerializerDefinitions(Collection definitions) {
        this._serializerDefinitions = definitions;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        RouterDefinition routerDef = this.getRouterDefinition();
        Collection resourceDefs = this.getResourceDefinitions();
        Collection serializerDefs = this.getSerializerDefinitions();
        Element root = XmlUtils.createElement(doc, DescriptorConstants.MUSE_QNAME);
        RouterDescriptor router = this.createRouterDescriptor();
        router.setRouterDefinition(routerDef);
        Element routerXML = router.toXML(doc);
        root.appendChild(routerXML);
        Iterator i = resourceDefs.iterator();
        ResourceDescriptor resource = this.createResourceDescriptor();
        while (i.hasNext()) {
            ResourceDefinition next = (ResourceDefinition)i.next();
            resource.setResourceDefinition(next);
            Element resourceXML = resource.toXML(doc);
            root.appendChild(resourceXML);
        }
        i = serializerDefs.iterator();
        SerializerDescriptor serializer = this.createSerializerDescriptor();
        while (i.hasNext()) {
            SerializerDefinition next = (SerializerDefinition)i.next();
            serializer.setSerializerDefinition(next);
            Element serializerXML = serializer.toXML(doc);
            root.appendChild(serializerXML);
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

