/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi;

import org.apache.muse.core.platform.osgi.OSGiLogHandler;
import org.apache.muse.core.platform.osgi.ResourceManagementProvider;
import org.apache.muse.core.platform.osgi.routing.OSGiResourceRouter;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    private static final String MANAGEMENT_ENVIRONMENT_FILTER = "(objectclass=org.apache.muse.core.platform.osgi.ResourceManagementProvider)";
    private static final String LOG_SERVICE_FILTER = "(objectclass=org.osgi.service.log.LogService)";
    private static final String LOG_READER_SERVICE_FILTER = "(objectclass=org.osgi.service.log.LogReaderService)";
    private ServiceReference managementServiceRef;
    private ServiceReference logServiceReference = null;
    private ServiceReference logReaderServiceReference = null;
    private static Activator activator;
    private BundleContext context;
    private ResourceManagementProvider provider;
    private ManagementServiceListener managementListener = new ManagementServiceListener();
    private LogServiceListener logListener = new LogServiceListener();

    public void start(BundleContext context) throws Exception {
        activator = this;
        this.context = context;
        try {
            OSGiResourceRouter.getDefault().initialize(context);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.managementServiceRef = context.getServiceReference("org.apache.muse.core.platform.osgi.ResourceManagementProvider");
        if (this.managementServiceRef != null) {
            Activator.activator.provider = (ResourceManagementProvider)Activator.activator.context.getService(Activator.activator.managementServiceRef);
            OSGiResourceRouter.getDefault().attachManagementProvider(Activator.activator.provider);
        }
        OSGiReflectUtilHelper.getDefault().initialize(context);
        context.addServiceListener((ServiceListener)this.managementListener, MANAGEMENT_ENVIRONMENT_FILTER);
        context.addServiceListener((ServiceListener)this.logListener, LOG_SERVICE_FILTER);
        context.addServiceListener((ServiceListener)this.logListener, LOG_READER_SERVICE_FILTER);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)OSGiResourceRouter.getDefault());
        context.removeServiceListener((ServiceListener)this.managementListener);
        context.removeServiceListener((ServiceListener)this.logListener);
    }

    private static class LogServiceListener
    implements ServiceListener {
        private boolean enabled = false;

        private LogServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference ref = event.getServiceReference();
            switch (event.getType()) {
                case 1: {
                    if (this.enabled) break;
                    try {
                        activator.logServiceReference = activator.context.getServiceReference("org.osgi.service.log.LogService");
                        if (activator.logServiceReference != null) {
                            LogService logService = (LogService)activator.context.getService(activator.logServiceReference);
                            OSGiLogHandler.setLogService(logService);
                            this.enabled = true;
                        }
                        activator.logReaderServiceReference = activator.context.getServiceReference("org.osgi.service.log.LogReaderService");
                        if (activator.logReaderServiceReference == null) break;
                        LogReaderService logReaderService = (LogReaderService)activator.context.getService(activator.logReaderServiceReference);
                        OSGiLogHandler.setLogReaderService(logReaderService);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    if (ref == activator.logServiceReference) {
                        OSGiLogHandler.setLogService(null);
                    }
                    if (ref == activator.logReaderServiceReference) {
                        OSGiLogHandler.setLogReaderService(null);
                    }
                    this.enabled = false;
                }
            }
        }
    }

    private static class ManagementServiceListener
    implements ServiceListener {
        private ManagementServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference ref = event.getServiceReference();
            switch (event.getType()) {
                case 1: {
                    if (activator.managementServiceRef != null) break;
                    activator.managementServiceRef = event.getServiceReference();
                    activator.provider = (ResourceManagementProvider)activator.context.getService(activator.managementServiceRef);
                    OSGiResourceRouter.getDefault().attachManagementProvider(activator.provider);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    ref = event.getServiceReference();
                    if (ref != activator.managementServiceRef) break;
                    activator.managementServiceRef = null;
                    OSGiResourceRouter.getDefault().releaseManagementProvider();
                }
            }
        }
    }
}

