/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.muse.core.AbstractEnvironment;
import org.apache.muse.core.platform.osgi.OSGiEnvironment;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.apache.muse.ws.addressing.EndpointReference;
import org.osgi.framework.Bundle;

public class OSGiEnvironmentImpl
extends AbstractEnvironment
implements OSGiEnvironment {
    protected ThreadLocal localEnvironmentContext = new ThreadLocal();
    private OSGiReflectUtilHelper reflectHelper;

    public OSGiEnvironmentImpl(boolean createSoapClient) {
        super(createSoapClient);
    }

    public EndpointReference getDeploymentEPR() {
        return null;
    }

    public File getRealDirectory() {
        return null;
    }

    public Bundle getThreadLocalBundle() {
        return (Bundle)this.localEnvironmentContext.get();
    }

    public void setThreadLocalBundle(Bundle bundle) {
        this.localEnvironmentContext.set(bundle);
        if (this.reflectHelper != null) {
            this.reflectHelper.setThreadLocalBundle(bundle);
        }
    }

    public InputStream getDataResourceStream(String path) {
        URL url;
        if (path == null) {
            throw new NullPointerException("Resource path is null.");
        }
        InputStream input = null;
        Bundle bundle = this.getThreadLocalBundle();
        if (bundle != null && (url = bundle.getResource(path)) != null) {
            try {
                input = url.openStream();
            }
            catch (IOException ioe) {
                input = null;
            }
        }
        if (input == null) {
            input = this.getClass().getResourceAsStream(path);
        }
        if (input == null) {
            input = this.getClass().getResourceAsStream("/OSGI-INF/" + path);
        }
        if (input == null) {
            input = OSGiReflectUtilHelper.getDefault().getResource(path);
        }
        return input;
    }
}

