/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi;

import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.muse.core.platform.osgi.OSGiLogListener;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class OSGiLogHandler
extends Handler {
    private static LogService _logService = null;
    private static LogReaderService _logReaderService = null;
    protected OSGiLogListener _listener = null;

    public OSGiLogHandler(String logfile) throws IOException {
        this._listener = new OSGiLogListener(logfile);
        if (_logReaderService != null) {
            _logReaderService.addLogListener((LogListener)this._listener);
        }
    }

    public static void setLogService(LogService logService) {
        _logService = logService;
    }

    public static void setLogReaderService(LogReaderService logReaderService) {
        _logReaderService = logReaderService;
    }

    public void publish(LogRecord record) {
        if (_logService != null) {
            _logService.log(record.getLevel().intValue(), record.getMessage());
        } else {
            this._listener.log(record.getLevel(), record.getMessage());
        }
    }

    public void close() {
        if (_logReaderService != null) {
            _logReaderService.removeLogListener((LogListener)this._listener);
        }
        this._listener.close();
    }

    public void flush() {
    }
}

