/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core.platform.osgi.routing;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.muse.core.platform.osgi.util.OSGiReflectUtilHelper;
import org.apache.muse.core.routing.ResourceIdFactory;
import org.apache.muse.ws.addressing.WsaConstants;
import org.osgi.framework.Bundle;

public class OSGiResourceIdFactory
implements ResourceIdFactory {
    protected HashMap bundleToCounterMap = new HashMap();
    protected String name;
    private static final String _DEFAULT_NAME = "MuseResource";
    private int count = 0;
    private Integer FIRST = new Integer(1);

    public OSGiResourceIdFactory() {
        this.name = _DEFAULT_NAME;
    }

    public OSGiResourceIdFactory(String name) {
        this.name = name;
    }

    public QName getIdentifierName() {
        return WsaConstants.DEFAULT_RESOURCE_ID_QNAME;
    }

    public synchronized String getNextIdentifier() {
        Bundle bundle = OSGiReflectUtilHelper.getDefault().getThreadLocalBundle();
        if (bundle != null) {
            Integer bCount = (Integer)this.bundleToCounterMap.get(bundle);
            if (bCount == null) {
                bCount = this.FIRST;
            }
            int value = bCount;
            this.bundleToCounterMap.put(bundle, new Integer(value + 1));
            return this.name + '-' + value++;
        }
        return this.name + '-' + this.count++;
    }
}

