/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;

public final class FileUtils {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$util$FileUtils == null ? (class$org$apache$muse$util$FileUtils = FileUtils.class$("org.apache.muse.util.FileUtils")) : class$org$apache$muse$util$FileUtils);
    public static final File CURRENT_DIR = new File(".");
    static /* synthetic */ Class class$org$apache$muse$util$FileUtils;

    public static void close(InputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Writer writer) {
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void copy(File source, File destination) throws IOException {
        if (source == null) {
            throw new NullPointerException(_MESSAGES.get("NullSource"));
        }
        if (destination == null) {
            throw new NullPointerException(_MESSAGES.get("NullDestination"));
        }
        if (source.isDirectory()) {
            FileUtils.copyDirectory(source, destination);
        } else {
            FileUtils.copyFile(source, destination);
        }
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        FileUtils.copyDirectory(source, destination, null);
    }

    public static void copyDirectory(File source, File destination, FileFilter filter) throws IOException {
        File nextDirectory = new File(destination, source.getName());
        if (!nextDirectory.exists() && !nextDirectory.mkdirs()) {
            Object[] filler = new Object[]{nextDirectory.getAbsolutePath()};
            String message = _MESSAGES.get("DirCopyFailed", filler);
            throw new IOException(message);
        }
        File[] files = source.listFiles();
        for (int n = 0; n < files.length; ++n) {
            if (filter != null && !filter.accept(files[n])) continue;
            if (files[n].isDirectory()) {
                FileUtils.copyDirectory(files[n], nextDirectory, filter);
                continue;
            }
            FileUtils.copyFile(files[n], nextDirectory);
        }
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (destination.isDirectory()) {
            destination = new File(destination, source.getName());
        }
        FileInputStream input = new FileInputStream(source);
        FileUtils.copyFile(input, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream input, File destination) throws IOException {
        FileOutputStream output;
        block6: {
            output = null;
            try {
                output = new FileOutputStream(destination);
                byte[] buffer = new byte[1024];
                int bytesRead = input.read(buffer);
                while (bytesRead >= 0) {
                    ((OutputStream)output).write(buffer, 0, bytesRead);
                    bytesRead = input.read(buffer);
                }
                Object var6_5 = null;
                if (input == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (input != null) {
                    FileUtils.close(input);
                }
                if (output != null) {
                    FileUtils.close(output);
                }
                throw throwable;
            }
            FileUtils.close(input);
        }
        if (output != null) {
            FileUtils.close(output);
        }
    }

    public static String createRelativePath(String originalPath, String relativePath) {
        int slash;
        if (originalPath == null) {
            throw new NullPointerException(_MESSAGES.get("NullOriginalPath"));
        }
        if (relativePath == null) {
            throw new NullPointerException(_MESSAGES.get("NullRelativePath"));
        }
        if (relativePath.startsWith("./")) {
            relativePath = relativePath.substring(2);
        }
        if (relativePath.startsWith("../")) {
            slash = originalPath.lastIndexOf(47);
            originalPath = originalPath.substring(0, slash);
            relativePath = relativePath.substring(3);
        }
        if ((slash = originalPath.lastIndexOf(47)) < 0) {
            return relativePath;
        }
        String dir = originalPath.substring(0, slash + 1);
        return dir + relativePath;
    }

    public static File find(File contextRoot, String fileName) {
        return FileUtils.find(contextRoot, fileName, false);
    }

    public static File find(File contextRoot, String fileName, boolean matchDirectories) {
        if (contextRoot == null) {
            throw new NullPointerException(_MESSAGES.get("NullContextRoot"));
        }
        if (fileName == null) {
            throw new NullPointerException(_MESSAGES.get("NullFileName"));
        }
        if (!contextRoot.isDirectory()) {
            Object[] filler = new Object[]{contextRoot.getAbsolutePath()};
            String message = _MESSAGES.get("NotDirectory", filler);
            throw new IllegalArgumentException(message);
        }
        File[] files = contextRoot.listFiles();
        for (int n = 0; n < files.length; ++n) {
            String nextName = files[n].getName();
            if (files[n].isDirectory()) {
                if (nextName.equals(fileName) && matchDirectories) {
                    return files[n];
                }
                File match = FileUtils.find(files[n], fileName);
                if (match == null) continue;
                return match;
            }
            if (!nextName.equals(fileName)) continue;
            return files[n];
        }
        return null;
    }

    public static InputStream loadFromContext(Class context, String path) {
        return context.getResourceAsStream(path);
    }

    public static String makePath(String[] strings) {
        String result = "";
        for (int i = 0; i < strings.length; ++i) {
            result = result + File.separator + strings[i];
        }
        return result;
    }

    public static void pruneEmptyDirectories(File directory) throws IOException {
        File[] directoryFiles;
        if (directory == null) {
            throw new NullPointerException(_MESSAGES.get("NullFile"));
        }
        if (!directory.isDirectory()) {
            Object[] filler = new Object[]{directory.getAbsolutePath()};
            String message = _MESSAGES.get("NotDirectory", filler);
            throw new IllegalArgumentException(message);
        }
        while (directory != null && (directoryFiles = directory.listFiles()).length <= 0) {
            if (!directory.delete()) {
                Object[] filler = new Object[]{directory.getAbsolutePath()};
                String message = _MESSAGES.get("DeleteFailed", filler);
                throw new IOException(message);
            }
            directory = directory.getParentFile();
        }
    }

    public static void remove(File file) throws IOException {
        FileUtils.remove(file, false);
    }

    public static void remove(File file, boolean pruneEmptyDirectories) throws IOException {
        if (file == null) {
            throw new NullPointerException(_MESSAGES.get("NullFile"));
        }
        if (file.isDirectory()) {
            FileUtils.removeDirectory(file);
        } else {
            FileUtils.removeFile(file);
        }
        if (pruneEmptyDirectories) {
            FileUtils.pruneEmptyDirectories(file.getParentFile());
        }
    }

    private static void removeDirectory(File directory) throws IOException {
        File[] files = directory.listFiles();
        for (int n = 0; n < files.length; ++n) {
            File nextFile = files[n];
            if (nextFile.isDirectory()) {
                FileUtils.removeDirectory(nextFile);
                continue;
            }
            FileUtils.removeFile(nextFile);
        }
        if (!directory.delete()) {
            Object[] filler = new Object[]{directory.getAbsolutePath()};
            String message = _MESSAGES.get("DeleteFailed", filler);
            throw new IOException(message);
        }
    }

    private static void removeFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.delete()) {
            Object[] filler = new Object[]{file.getAbsolutePath()};
            String message = _MESSAGES.get("DeleteFailed", filler);
            throw new IOException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

