/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.addressing.soap;

import javax.xml.namespace.QName;
import org.apache.muse.util.xml.XmlSerializable;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.soap.SoapConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapFault
extends Exception
implements XmlSerializable {
    private static final long serialVersionUID = -8612773172898054578L;
    private QName _code = SoapConstants.RECEIVER_QNAME;
    private QName _subCode = null;
    private String _reason = null;
    private String _nodeURI = null;
    private String _roleURI = null;
    private Element _detail = null;

    public SoapFault(Element xml) {
        Element codeXML = XmlUtils.getElement(xml, SoapConstants.CODE_QNAME);
        this._code = XmlUtils.getQNameFromChild(codeXML, SoapConstants.VALUE_QNAME);
        Element subCodeXML = XmlUtils.getElement(codeXML, SoapConstants.SUBCODE_QNAME);
        if (subCodeXML != null) {
            this._subCode = XmlUtils.getQNameFromChild(subCodeXML, SoapConstants.VALUE_QNAME);
        }
        Element reasonXML = XmlUtils.getElement(xml, SoapConstants.REASON_QNAME);
        this._reason = XmlUtils.getElementText(reasonXML, SoapConstants.TEXT_QNAME);
        this._nodeURI = XmlUtils.getElementText(xml, SoapConstants.NODE_QNAME);
        this._roleURI = XmlUtils.getElementText(xml, SoapConstants.ROLE_QNAME);
        Element detailXML = XmlUtils.getElement(xml, SoapConstants.DETAIL_QNAME);
        if (detailXML != null) {
            this._detail = XmlUtils.getFirstElement(detailXML);
        }
    }

    public SoapFault(String message) {
        super(message);
        this._reason = message;
    }

    public SoapFault(String message, Throwable cause) {
        super(message, cause);
        this._reason = message;
    }

    public SoapFault(Throwable cause) {
        super(cause);
        this._reason = cause.getMessage();
    }

    public QName getCode() {
        return this._code;
    }

    public void setCode(QName code) {
        this._code = code;
    }

    public Element getDetail() {
        return this._detail;
    }

    public void setDetail(Element detail) {
        this._detail = detail;
    }

    public String getMessage() {
        return this.getReason();
    }

    public String getNodeURI() {
        return this._nodeURI;
    }

    public void setNodeURI(String nodeURI) {
        this._nodeURI = nodeURI;
    }

    public String getReason() {
        return this._reason;
    }

    public void setReason(String reason) {
        this._reason = reason;
    }

    public String getRoleURI() {
        return this._roleURI;
    }

    public void setRoleURI(String roleURI) {
        this._roleURI = roleURI;
    }

    public QName getSubCode() {
        return this._subCode;
    }

    public void setSubCode(QName subCode) {
        this._subCode = subCode;
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Element detail;
        String roleURI;
        Element faultXML = XmlUtils.createElement(doc, SoapConstants.FAULT_QNAME);
        Element codeXML = XmlUtils.createElement(doc, SoapConstants.CODE_QNAME);
        faultXML.appendChild(codeXML);
        XmlUtils.setElement(codeXML, SoapConstants.VALUE_QNAME, this.getCode());
        QName subCode = this.getSubCode();
        if (subCode != null) {
            Element subCodeXML = XmlUtils.createElement(doc, SoapConstants.SUBCODE_QNAME);
            codeXML.appendChild(subCodeXML);
            XmlUtils.setElement(subCodeXML, SoapConstants.VALUE_QNAME, subCode);
        }
        Element reasonXML = XmlUtils.createElement(doc, SoapConstants.REASON_QNAME);
        faultXML.appendChild(reasonXML);
        XmlUtils.setElement(reasonXML, SoapConstants.TEXT_QNAME, this.getReason());
        String nodeURI = this.getNodeURI();
        if (nodeURI != null) {
            XmlUtils.setElement(faultXML, SoapConstants.NODE_QNAME, nodeURI);
        }
        if ((roleURI = this.getRoleURI()) != null) {
            XmlUtils.setElement(faultXML, SoapConstants.ROLE_QNAME, roleURI);
        }
        if ((detail = this.getDetail()) != null) {
            XmlUtils.setElement(faultXML, SoapConstants.DETAIL_QNAME, detail, false);
        }
        return faultXML;
    }
}

