/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.ws.dm.muws.events.impl;

import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.uuid.RandomUuidFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.util.xml.XsdUtils;
import org.apache.muse.ws.dm.muws.events.Component;
import org.apache.muse.ws.dm.muws.events.ManagementEvent;
import org.apache.muse.ws.dm.muws.events.Situation;
import org.apache.muse.ws.dm.muws.events.WefConstants;
import org.apache.muse.ws.dm.muws.events.WefFactory;
import org.apache.muse.ws.dm.muws.events.impl.AbstractExtendedElements;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SimpleManagementEvent
extends AbstractExtendedElements
implements ManagementEvent {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$ws$dm$muws$events$impl$SimpleManagementEvent == null ? (class$org$apache$muse$ws$dm$muws$events$impl$SimpleManagementEvent = SimpleManagementEvent.class$("org.apache.muse.ws.dm.muws.events.impl.SimpleManagementEvent")) : class$org$apache$muse$ws$dm$muws$events$impl$SimpleManagementEvent);
    private String _eventID = RandomUuidFactory.getInstance().createUUID();
    private Component _reporter = null;
    private Date _reportTime = new Date();
    private long _sequenceNumber = -1L;
    private Situation _situation = null;
    private Component _source = null;
    static /* synthetic */ Class class$org$apache$muse$ws$dm$muws$events$impl$SimpleManagementEvent;

    public SimpleManagementEvent() {
    }

    public SimpleManagementEvent(Element xml, WefFactory factory) {
        Element sourceXML;
        Element reporterXML;
        String sequenceString = xml.getAttributeNS("http://docs.oasis-open.org/wsdm/muws2-2.xsd", "sequenceNumber");
        if (sequenceString != null && sequenceString.length() > 0) {
            this._sequenceNumber = Long.parseLong(sequenceString);
        }
        String timeString = xml.getAttribute("ReportTime");
        try {
            if (timeString != null && timeString.length() > 0) {
                this.setReportTime(XsdUtils.getLocalTime(timeString));
            }
        }
        catch (ParseException error) {
            throw new RuntimeException(error.getMessage(), error);
        }
        HashSet<Element> alreadySeen = new HashSet<Element>();
        Element idXML = XmlUtils.getElement(xml, WefConstants.EVENT_ID_QNAME);
        if (idXML != null) {
            this.setEventID(XmlUtils.extractText(idXML));
            alreadySeen.add(idXML);
        }
        if ((reporterXML = XmlUtils.getElement(xml, WefConstants.REPORTER_COMP_QNAME)) != null) {
            Component reporter = factory.createComponent(reporterXML);
            this.setReporter(reporter);
            alreadySeen.add(reporterXML);
        }
        if ((sourceXML = XmlUtils.getElement(xml, WefConstants.SOURCE_COMP_QNAME)) == null) {
            throw new RuntimeException(_MESSAGES.get("NoSourceComponent"));
        }
        Component source = factory.createComponent(sourceXML);
        this.setSource(source);
        alreadySeen.add(sourceXML);
        Element situationXML = XmlUtils.getElement(xml, WefConstants.SITUATION_QNAME);
        if (situationXML != null) {
            Situation situation = factory.createSituation(situationXML);
            this.setSituation(situation);
            alreadySeen.add(situationXML);
        }
        Element[] children = XmlUtils.getAllElements(xml);
        for (int n = 0; n < children.length; ++n) {
            if (alreadySeen.contains(children[n])) continue;
            this.addExtendedElement(children[n]);
        }
    }

    public final String getEventID() {
        return this._eventID;
    }

    public final Component getReporter() {
        return this._reporter;
    }

    public final Date getReportTime() {
        return this._reportTime;
    }

    public final long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public final Situation getSituation() {
        return this._situation;
    }

    public final Component getSource() {
        return this._source;
    }

    public final void setEventID(String eventID) {
        this._eventID = eventID;
    }

    public final void setReporter(Component reporter) {
        this._reporter = reporter;
    }

    public final void setReportTime(Date reportTime) {
        this._reportTime = reportTime;
    }

    public final void setSequenceNumber(long sequenceNumber) {
        this._sequenceNumber = sequenceNumber;
    }

    public final void setSituation(Situation situation) {
        this._situation = situation;
    }

    public final void setSource(Component source) {
        this._source = source;
    }

    public String toString() {
        return XmlUtils.toString(this.toXML(), false);
    }

    public Element toXML() {
        return this.toXML(XmlUtils.EMPTY_DOC);
    }

    public Element toXML(Document doc) {
        Situation situation;
        String eventID;
        Date time;
        Element wef = XmlUtils.createElement(doc, WefConstants.MGMT_EVENT_QNAME);
        long sequence = this.getSequenceNumber();
        if (sequence >= 0L) {
            String name = "muws2:sequenceNumber";
            wef.setAttributeNS("http://docs.oasis-open.org/wsdm/muws2-2.xsd", name, Long.toString(sequence));
        }
        if ((time = this.getReportTime()) != null) {
            wef.setAttribute("ReportTime", XsdUtils.getLocalTimeString(time));
        }
        if ((eventID = this.getEventID()) == null) {
            throw new RuntimeException(_MESSAGES.get("NoEventID"));
        }
        XmlUtils.setElement(wef, WefConstants.EVENT_ID_QNAME, eventID);
        Component source = this.getSource();
        if (source == null) {
            throw new RuntimeException(_MESSAGES.get("NoSourceComponent"));
        }
        Element sourceXML = source.toXML(doc);
        wef.appendChild(sourceXML);
        Component reporter = this.getReporter();
        if (reporter != null) {
            Element reporterXML = reporter.toXML(doc);
            wef.appendChild(reporterXML);
        }
        if ((situation = this.getSituation()) != null) {
            Element situationXML = situation.toXML(doc);
            wef.appendChild(situationXML);
        }
        this.appendExtendedElements(wef);
        return wef;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

